<?php

class Elementor_ultra_tv_grid_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_tv_grid';
    }


    public function get_title()
    {
        return 'تلویزیون مدل 2 اولترا';
    }

    public function get_icon()
    {
        return 'eicon-slideshow';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['tv'];
    }

    protected function register_controls()
    {
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); // دریافت تنظیمات برای نمایش
        ?>
        <section class="ultra-tv">
            <div class="main-tv">
                <?php $big_tv = new WP_Query(array(
                    'post_type' => 'tv',
                    'posts_per_page' => 1,
                    'no_found_rows' => true,
                ));
                if ($big_tv->have_posts()) :
                    while ($big_tv->have_posts()) : $big_tv->the_post(); ?>
                        <div class="tv-box">
                            <a href="<?php the_permalink(); ?>">
                                <figure>
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail(); ?>
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             xmlns:xlink="http://www.w3.org/1999/xlink" fill="#000000"
                                             height="800px" width="800px" version="1.1" id="Capa_1"
                                             viewBox="0 0 60 60" xml:space="preserve">
                    <g>
                        <path d="M45.563,29.174l-22-15c-0.307-0.208-0.703-0.231-1.031-0.058C22.205,14.289,22,14.629,22,15v30   c0,0.371,0.205,0.711,0.533,0.884C22.679,45.962,22.84,46,23,46c0.197,0,0.394-0.059,0.563-0.174l22-15   C45.836,30.64,46,30.331,46,30S45.836,29.36,45.563,29.174z M24,43.107V16.893L43.225,30L24,43.107z"/>
                        <path d="M30,0C13.458,0,0,13.458,0,30s13.458,30,30,30s30-13.458,30-30S46.542,0,30,0z M30,58C14.561,58,2,45.439,2,30   S14.561,2,30,2s28,12.561,28,28S45.439,58,30,58z"/>
                    </g>
                    </svg>
                                    <?php } else { ?>
                                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             xmlns:xlink="http://www.w3.org/1999/xlink" fill="#000000"
                                             height="800px" width="800px" version="1.1" id="Capa_1"
                                             viewBox="0 0 60 60" xml:space="preserve">
                    <g>
                        <path d="M45.563,29.174l-22-15c-0.307-0.208-0.703-0.231-1.031-0.058C22.205,14.289,22,14.629,22,15v30   c0,0.371,0.205,0.711,0.533,0.884C22.679,45.962,22.84,46,23,46c0.197,0,0.394-0.059,0.563-0.174l22-15   C45.836,30.64,46,30.331,46,30S45.836,29.36,45.563,29.174z M24,43.107V16.893L43.225,30L24,43.107z"/>
                        <path d="M30,0C13.458,0,0,13.458,0,30s13.458,30,30,30s30-13.458,30-30S46.542,0,30,0z M30,58C14.561,58,2,45.439,2,30   S14.561,2,30,2s28,12.561,28,28S45.439,58,30,58z"/>
                    </g>
                    </svg>
                                    <?php } ?>
                                </figure>
                            </a>
                            <h3><?php the_title(); ?></h3>
                        </div>
                    <?php endwhile;
                endif;
                wp_reset_postdata(); ?>

            </div>
            <?php $side_tv = new WP_Query(array(
                'post_type' => 'tv',
                'posts_per_page' => 2,
                'offset' => 1,
                'no_found_rows' => true,
            ));
		 ?>   <div class="side-tv">  <?php
            if ($side_tv->have_posts()) :
                while ($side_tv->have_posts()) : $side_tv->the_post(); ?>
                 
                        <div class="tv-box">
                            <a href="<?php the_permalink(); ?>">
                                <figure>
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail(); ?>
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             xmlns:xlink="http://www.w3.org/1999/xlink" fill="#000000"
                                             height="800px" width="800px" version="1.1" id="Capa_1"
                                             viewBox="0 0 60 60" xml:space="preserve">
                    <g>
                        <path d="M45.563,29.174l-22-15c-0.307-0.208-0.703-0.231-1.031-0.058C22.205,14.289,22,14.629,22,15v30   c0,0.371,0.205,0.711,0.533,0.884C22.679,45.962,22.84,46,23,46c0.197,0,0.394-0.059,0.563-0.174l22-15   C45.836,30.64,46,30.331,46,30S45.836,29.36,45.563,29.174z M24,43.107V16.893L43.225,30L24,43.107z"/>
                        <path d="M30,0C13.458,0,0,13.458,0,30s13.458,30,30,30s30-13.458,30-30S46.542,0,30,0z M30,58C14.561,58,2,45.439,2,30   S14.561,2,30,2s28,12.561,28,28S45.439,58,30,58z"/>
                    </g>
                    </svg>
                                    <?php } else { ?>
                                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             xmlns:xlink="http://www.w3.org/1999/xlink" fill="#000000"
                                             height="800px" width="800px" version="1.1" id="Capa_1"
                                             viewBox="0 0 60 60" xml:space="preserve">
                    <g>
                        <path d="M45.563,29.174l-22-15c-0.307-0.208-0.703-0.231-1.031-0.058C22.205,14.289,22,14.629,22,15v30   c0,0.371,0.205,0.711,0.533,0.884C22.679,45.962,22.84,46,23,46c0.197,0,0.394-0.059,0.563-0.174l22-15   C45.836,30.64,46,30.331,46,30S45.836,29.36,45.563,29.174z M24,43.107V16.893L43.225,30L24,43.107z"/>
                        <path d="M30,0C13.458,0,0,13.458,0,30s13.458,30,30,30s30-13.458,30-30S46.542,0,30,0z M30,58C14.561,58,2,45.439,2,30   S14.561,2,30,2s28,12.561,28,28S45.439,58,30,58z"/>
                    </g>
                    </svg>
                                    <?php } ?>
                                </figure>
                            </a>
                            <h3><?php the_title(); ?></h3>
                        </div>
                 
                <?php endwhile;
            endif;
            wp_reset_postdata(); ?>
   </div>
        </section>
        <?php
    }
}