<?php
/**
 * Elementor Widget: Ultra ‑ Product Showcase (Tile)
 * -------------------------------------------------
 * نمایش محصولات ووکامرس در قالب «کاشی ویترین»
 * @author  Ultra Market
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

class Elementor_ultra_product_showcase_widget extends Widget_Base
{

    /*---------------------------------------------*/
    /*  Basics
    /*---------------------------------------------*/

    public function get_name()
    {
        return 'ultra_product_showcase';
    }

    public function get_title()
    {
        return 'ویترین محصول (کاشی)';
    }

    public function get_icon()
    {
        return 'eicon-product-gallery';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product', 'showcase', 'tile', 'woocommerce'];
    }

    function get_product_cats()
    {
        $cat_list = [];
        $product_cats = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => true,
        ));

        if (!empty($product_cats) && !is_wp_error($product_cats)) {
            foreach ($product_cats as $cat) {
                $cat_list[$cat->term_id] = $cat->name;
            }
        }
        return $cat_list;
    }

    function get_product_tags()
    {
        $tag_list = [];
        $product_tags = get_terms('product_tag');

        if (!empty($product_tags) && !is_wp_error($product_tags)) {
            foreach ($product_tags as $tag) {
                $tag_list[$tag->term_id] = $tag->name;
            }
        }
        return $tag_list;
    }

    function get_product_brands()
    {
        $brand_list = [];
        $product_brands = get_terms('product_brand');

        if (!empty($product_brands) && !is_wp_error($product_brands)) {
            foreach ($product_brands as $brand) {
                $brand_list[$brand->term_id] = $brand->name;
            }
        }
        return $brand_list;
    }

    protected function register_controls()
    {
        $this->start_controls_section('content_section', [
            'label' => __('فیلتر محصولات', 'ultra-market'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('product_filter', [
            'label' => __('نوع فیلتر', 'ultra-market'),
            'type' => Controls_Manager::SELECT,
            'default' => 'all',
            'options' => [
                'all' => 'همه محصولات',
                'category' => 'براساس دسته‌بندی',
                'tag' => 'براساس برچسب',
                'brand' => 'براساس برند',
            ],
        ]);
        $this->add_control('cat', [
            'label' => 'انتخاب دسته‌بندی',
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => $this->get_product_cats(),
            'condition' => ['product_filter' => 'category'],
        ]);

        $this->add_control('tag', [
            'label' => 'انتخاب برچسب',
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => $this->get_product_tags(),
            'condition' => ['product_filter' => 'tag'],
        ]);

        $this->add_control('brand', [
            'label' => 'انتخاب برند',
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => $this->get_product_brands(),
            'condition' => ['product_filter' => 'brand'],
        ]);

        $this->end_controls_section();

        $this->start_controls_section('display_section', [
            'label' => __('تنظیمات نمایش', 'ultra-market'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('number', [
            'label' => __('تعداد محصولات', 'ultra-market'),
            'type' => Controls_Manager::NUMBER,
            'default' => 4,
            'min' => 1,
            'max' => 50,
        ]);

        $this->add_control('orderby_rand', [
            'label' => __('نمایش تصادفی', 'ultra-market'),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => 'بله',
            'label_off' => 'خیر',
            'return_value' => 'yes',
            'default' => 'yes',
        ]);

        $this->add_control('stock', [
            'label' => __('فقط محصولات موجود'),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => 'بله',
            'label_off' => 'خیر',
            'return_value' => 'yes',
            'default' => '',
        ]);

        $this->add_control('excerpt_length', [
            'label' => __('تعداد کلمات توضیح کوتاه', 'ultra-market'),
            'type' => Controls_Manager::NUMBER,
            'min' => 5,
            'max' => 50,
            'default' => 25,
            'description' => 'تعداد کلمات مجاز برای توضیح کوتاه محصول',
        ]);

        $this->add_control('low_stock_limit', [
            'label' => __('هشدار موجودی کمتر از', 'ultra-market'),
            'type' => Controls_Manager::NUMBER,
            'min' => 1,
            'default' => 5,
        ]);

        $this->end_controls_section();
        /* ===== استایل ===== */
        $this->start_controls_section('style_text_section', [
            'label' => __('استایل متن‌ها (عنوان و توضیح)', 'ultra-market'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('title_color', [
            'label' => __('رنگ عنوان', 'ultra-market'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase h3 a' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => __('تایپوگرافی عنوان', 'ultra-market'),
            'selector' => '{{WRAPPER}} .ultra-product-showcase h3',
        ]);

        $this->add_control('excerpt_color', [
            'label' => __('رنگ توضیح کوتاه', 'ultra-market'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase p' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'excerpt_typography',
            'label' => __('تایپوگرافی توضیح کوتاه', 'ultra-market'),
            'selector' => '{{WRAPPER}} .ultra-product-showcase p',
        ]);

        $this->end_controls_section();

        /* ===== استایل: امتیاز محصول ===== */
        $this->start_controls_section('style_rating_section', [
            'label' => __('استایل امتیاز (ستاره)', 'ultra-market'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('rating_color', [
            'label' => __('رنگ ستاره و عدد', 'ultra-market'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase .star svg path' => 'fill: {{VALUE}}',
                '{{WRAPPER}} .ultra-product-showcase .star span' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_control('rating_size', [
            'label' => __('اندازه امتیاز', 'ultra-market'),
            'type' => Controls_Manager::SLIDER,
            'size_units' => ['px', 'em', 'rem'],
            'range' => [
                'px' => [
                    'min' => 8,
                    'max' => 40,
                    'step' => 1,
                ],
            ],
            'default' => [
                'unit' => 'px',
                'size' => 14,
            ],
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase .star' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]);


        $this->end_controls_section();

        /* ===== استایل: هشدار موجودی و برچسب‌ها ===== */
        $this->start_controls_section('style_tags_section', [
            'label' => __('استایل برچسب‌ها و هشدارها', 'ultra-market'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('low_stock_color', [
            'label' => __('رنگ هشدار کمبود موجودی', 'ultra-market'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase .remain' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_control('fast_color', [
            'label' => __('رنگ متن ارسال فوری', 'ultra-market'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase .product-bottom .fast-sending' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_control('fast_bg', [
            'label' => __('رنگ پس‌زمینه ارسال فوری', 'ultra-market'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase .product-bottom .fast-sending' => 'background-color: {{VALUE}}',
            ],
        ]);

        $this->add_control('fast_border', [
            'label' => __('رنگ حاشیه کادر ارسال فوری', 'ultra-market'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase .product-bottom .fast-sending' => 'border-color: {{VALUE}}',
            ],
        ]);

        $this->add_control('category_color', [
            'label' => __('رنگ متن دسته بندی', 'ultra-market'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase .product-bottom .category a' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_control('category_bg', [
            'label' => __('رنگ پس‌زمینه دسته بندی', 'ultra-market'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase .product-bottom .category a' => 'background-color: {{VALUE}}',
            ],
        ]);

        $this->end_controls_section();

        /* ===== استایل: کارت محصول ===== */
        $this->start_controls_section('style_card_section', [
            'label' => __('استایل کارت محصول', 'ultra-market'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'box_border',
            'label' => __('حاشیه کارت', 'ultra-market'),
            'selector' => '{{WRAPPER}} .ultra-product-showcase',
        ]);

        $this->add_control('box_border_radius', [
            'label' => __('گردی گوشه‌ها', 'ultra-market'),
            'type' => Controls_Manager::SLIDER,
            'selectors' => [
                '{{WRAPPER}} .ultra-product-showcase' => 'border-radius: {{SIZE}}{{UNIT}}',
            ],
        ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(), [
            'name' => 'box_shadow',
            'label' => __('سایه کارت', 'ultra-market'),
            'selector' => '{{WRAPPER}} .ultra-product-showcase',
        ]);

        $this->end_controls_section();

    }

    /*---------------------------------------------*/
    /*  Render
    /*---------------------------------------------*/

    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>
        <section class="ultra-product-showcase-box">
            <div class="ultra-header-widgets">
                <div class="title">
               <figure>
                  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
            <path d="M15 1.96594H5.00002C3.15907 1.96594 1.66669 3.45833 1.66669 5.29928V15.2993C1.66669 17.1402 3.15907 18.6326 5.00002 18.6326H15C16.841 18.6326 18.3334 17.1402 18.3334 15.2993V5.29928C18.3334 3.45833 16.841 1.96594 15 1.96594ZM15 1.96594L11.6667 6.96594M1.66669 6.96594H18.3334M8.33335 1.96594L5.00002 6.96594M8.33335 11.8016V13.797C8.33335 14.7953 9.44604 15.3908 10.2767 14.837L11.7733 13.8393C12.5154 13.3446 12.5154 12.254 11.7733 11.7592L10.2767 10.7615C9.44603 10.2077 8.33335 10.8032 8.33335 11.8016Z" stroke="#007AF4" stroke-width="1.5" stroke-linejoin="round"/>
            </svg>
               </figure>
            <h3>محصولات ویژه
            </h3>
            </div>

                <a href="#" class="view-all">مشاهده همه</a>
            </div>
        <div class="product-items">
            <?php
            $product_args = array(
                'post_type' => 'product',
                'posts_per_page' => $settings['number'],
            );
            if ($settings['product_filter'] == 'category') {
                $tax_query = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $settings['cat'],
                    ),
                );
                $product_args['tax_query'] = $tax_query;
            } elseif ($settings['product_filter'] == 'tag') {
                $tax_query = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'product_tag',
                        'field' => 'term_id',
                        'terms' => $settings['tag'],
                    ),
                );
                $product_args['tax_query'] = $tax_query;
            } elseif ($settings['product_filter'] == 'brand') {
                $tax_query = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'product_brand',
                        'field' => 'term_id',
                        'terms' => $settings['brand'],
                    ),
                );
                $product_args['tax_query'] = $tax_query;
            }
            if ($settings['orderby_rand'] == 'yes') {
                $product_args['orderby'] = 'rand';
            }
            if ($settings['stock']) {
                $meta_query = array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock',
                        'compare' => '=',
                    ),
                );
                $product_args['meta_query'] = $meta_query;
            }
            $pro = new WP_Query($product_args);
            if ($pro->have_posts()) {
                while ($pro->have_posts()) : $pro->the_post();
                    global $product;
                    $product = wc_get_product(get_the_ID()); ?>
                    <div class="item ultra-product-showcase">
                        <figure class="image-section">
                            <div class="terms">
                                <?php
                                $attr_taxonomy = wc_get_attribute_taxonomies() ?: [];


                                foreach ($attr_taxonomy as $taxonomy) {
                                    $attr_name = $taxonomy->attribute_name;
                                    $terms = get_the_terms($product->get_id(), 'pa_' . $attr_name);
                                    if (is_array($terms)) { ?>
                                        <div class="term">
                                            <ul>
                                                <?php
                                                $count = 0;
                                                $total = count($terms);
                                                foreach ($terms as $term) {
                                                    if ($count >= 4) break;

                                                    $tooltip = $term->name;
                                                    $colors = get_term_meta($term->term_id, 'product_attribute_color', 1);

                                                    if (!function_exists('lighten_color')) {
                                                        function lighten_color($hex, $percent = 80)
                                                        {
                                                            $hex = str_replace('#', '', $hex);
                                                            $r = hexdec(substr($hex, 0, 2));
                                                            $g = hexdec(substr($hex, 2, 2));
                                                            $b = hexdec(substr($hex, 4, 2));

                                                            $r = min(255, intval($r + (255 - $r) * $percent / 100));
                                                            $g = min(255, intval($g + (255 - $g) * $percent / 100));
                                                            $b = min(255, intval($b + (255 - $b) * $percent / 100));

                                                            return sprintf("#%02x%02x%02x", $r, $g, $b);
                                                        }
                                                    }
                                                    ?>
                                                    <li>
                                                        <?php if ($colors) {
                                                            $lighter = lighten_color($colors, 60); ?>
                                                            <span style="background: <?php echo esc_attr($lighter); ?>; border: 1px solid <?php echo esc_attr($colors); ?>;">
                                <b><?php echo esc_html($tooltip); ?></b>
                            </span>
                                                        <?php } else { ?>
                                                            <small><?php echo esc_html($tooltip); ?></small>
                                                        <?php } ?>
                                                    </li>
                                                    <?php
                                                    $count++;
                                                }

                                                // اگر تعداد بیشتر از ۴ بود، نمایش +n
                                                if ($total > 4) {
                                                    $more = $total - 4;
                                                    ?>
                                                    <li>
                        <span style="font-size:10px; color:white; font-weight:600;">
                            +<?php echo $more; ?>
                        </span>
                                                    </li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php }
                                }


                                ?>
                            </div>
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('product');
                            } else {
                                echo '<img src="' . esc_url(get_template_directory_uri() . '/assets/image/empty.webp') . '" alt="placeholder">';
                            } ?>
                        </figure>
                        <div class="product-content">
                            <div class="title">
                                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                <span class="star">
                   
                    <span><?php
                        $rating = $product->get_average_rating();
                        echo (floor($rating) == $rating) ? number_format($rating, 0) : number_format($rating, 1);
                        ?></span>
                     <svg xmlns="http://www.w3.org/2000/svg" width="12" height="13" viewBox="0 0 12 13" fill="none">
                        <path
                                d="M4.57658 3.20419C5.20991 2.06806 5.52657 1.5 6 1.5C6.47343 1.5 6.79009 2.06806 7.42342 3.20419L7.58727 3.49812C7.76724 3.82097 7.85722 3.98239 7.99753 4.0889C8.13783 4.19541 8.31257 4.23495 8.66206 4.31402L8.98023 4.38601C10.2101 4.66428 10.825 4.80341 10.9713 5.27387C11.1176 5.74432 10.6984 6.23454 9.85995 7.21496L9.64304 7.46861C9.40479 7.74722 9.28566 7.88652 9.23207 8.05886C9.17848 8.23119 9.19649 8.41706 9.23251 8.78878L9.2653 9.1272C9.39206 10.4353 9.45544 11.0894 9.07243 11.3801C8.68941 11.6709 8.11366 11.4058 6.96216 10.8756L6.66426 10.7384C6.33704 10.5878 6.17343 10.5124 6 10.5124C5.82657 10.5124 5.66296 10.5878 5.33574 10.7384L5.03784 10.8756C3.88634 11.4058 3.31059 11.6709 2.92757 11.3801C2.54456 11.0894 2.60794 10.4353 2.7347 9.1272L2.76749 8.78878C2.80351 8.41706 2.82152 8.23119 2.76793 8.05886C2.71434 7.88652 2.59521 7.74722 2.35696 7.46861L2.14005 7.21496C1.30162 6.23454 0.882412 5.74432 1.02871 5.27387C1.17501 4.80341 1.78993 4.66428 3.01977 4.38601L3.33794 4.31402C3.68743 4.23495 3.86217 4.19541 4.00247 4.0889C4.14278 3.98239 4.23276 3.82097 4.41273 3.49812L4.57658 3.20419Z"
                                fill="#F58D70"/>
                    </svg>
                </span>
                            </div>
                            <p><?php echo wp_trim_words(get_the_excerpt(), intval($settings['excerpt_length']), '…'); ?></p>
                            <?php
                            // گرفتن موجودی انبار
                            $qty = $product->managing_stock() ? $product->get_stock_quantity() : null;
                            $discount_percent = function_exists('ultra_woocommerce_discount') ? ultra_woocommerce_discount(get_the_ID()) : 0;
                            // Tick Fast Sending
                            $fast_send = get_post_meta(get_the_ID(), 'fast_sending_express_shipping', true) === 'yes';
                            $primary_cat = '';
                            $cats = wp_get_post_terms(get_the_ID(), 'product_cat');
                            if (!is_wp_error($cats) && !empty($cats)) {
                                $primary_cat_obj = $cats[0];
                                $primary_cat = '<a href="' . get_term_link($primary_cat_obj) . '">' . esc_html($primary_cat_obj->name) . '</a>';
                            }
                            // شرط موجودی کم با سوئیچ
                            switch (true) {
                                case ($qty !== null && $qty <= intval($settings['low_stock_limit'])): ?>
                                    <div class="product-bottom">
                                        <?php if ($product->is_in_stock()) { ?>
                                            <span class="remain">
                    <span><?php echo sprintf(__('فقط %d عدد باقی مانده!', 'ultra-market'), $qty); ?></span>
                </span>
                                        <?php } ?>
                                        <?php if ($product->get_price_html() || !$product->is_in_stock() || $product->is_on_sale()) : ?>
                                            <div class="box-price">
                                                <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                                    <div class="price">
                                                        <?php echo $product->get_price_html(); ?>
                                                    </div>
                                                <?php } elseif (!$product->is_in_stock()) { ?>
                                                    <span class="not_stock">ناموجود</span>
                                                <?php } else { ?>
                                                    <div class="no_price">
                                                        <span>تماس بگیرید</span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15"
                                                             viewBox="0 0 15 15" fill="none">
                                                            <path d="M3.48438 1.25C4.09773 1.25 4.64916 1.62387 4.87695 2.19336L5.4873 3.71875C5.77691 4.44301 5.46326 5.2683 4.76562 5.61719L4.5 5.75C4.5 5.75 4.875 7.625 6.375 9.125C7.875 10.625 9.75 11 9.75 11L9.88281 10.7344C10.2317 10.0367 11.057 9.72309 11.7812 10.0127L13.3066 10.623C13.8761 10.8508 14.25 11.4023 14.25 12.0156V13.25C14.25 14.0784 13.5784 14.75 12.75 14.75C6.12258 14.75 0.75 9.37742 0.75 2.75C0.75 1.92157 1.42157 1.25 2.25 1.25H3.48438Z"
                                                                  fill="white"/>
                                                        </svg>
                                                    </div>
                                                <?php } ?>

                                                <?php if ($product->is_on_sale() && !empty($discount_percent) && $discount_percent > 0 && $product->is_in_stock()) : ?>
                                                    <span class="sale">
                <span class="num"><?php echo esc_html($discount_percent); ?></span>
                <span class="sale-symbol">%</span>
            
            </span>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>


                                    </div>
                                    <?php break;
                                /* ───────── Category && Express Shipping ───────── */
                                default:
                                    ?>
                                    <div class="product-bottom">
                                        <?php if ($fast_send) : ?>
                                            <span class="fast-sending">
                    <span>ارسال فوری</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                        <g clip-path="url(#clip0_2001_1113)">
                            <path
                                    d="M11.25 10C11.25 10.6904 10.6904 11.25 10 11.25C9.30964 11.25 8.75 10.6904 8.75 10C8.75 9.30964 9.30964 8.75 10 8.75C10.6904 8.75 11.25 9.30964 11.25 10Z"
                                    stroke="#F58D70" stroke-width="1.5"></path>
                            <path d="M10 5V8.75M11.25 11.25L12.5 12.5" stroke="#F58D70" stroke-width="1.5"
                                  stroke-linecap="round" stroke-linejoin="round"></path>
                            <path
                                    d="M1.66675 10.0013C1.66675 5.39893 5.39771 1.66797 10.0001 1.66797C14.6025 1.66797 18.3334 5.39893 18.3334 10.0013C18.3334 14.6037 14.6025 18.3346 10.0001 18.3346H1.66675"
                                    stroke="#F58D70" stroke-width="1.5" stroke-linecap="round"></path>
                            <path d="M6.66675 15H1.66675" stroke="#F58D70" stroke-width="1.5" stroke-linecap="round"
                                  stroke-linejoin="round"></path>
                            <path d="M5.00008 12.5H1.66675" stroke="#F58D70" stroke-width="1.5" stroke-linecap="round"
                                  stroke-linejoin="round"></path>
                        </g>
                        <defs>
                            <clipPath id="clip0_2001_1113">
                                <rect width="20" height="20" fill="white"></rect>
                            </clipPath>
                        </defs>
                    </svg>
                </span>
                                        <?php else : ?>
                                            <span class="category"><?php echo $primary_cat; ?></span>
                                        <?php endif; ?>

                                        <?php if (!$product->is_in_stock()) : ?>
                                            <span class='not_stock'>ناموجود</span>

                                        <?php elseif ($product->get_price_html()) : ?>
                                            <div class="box-price">
                                                <div class="price"><?php echo $product->get_price_html(); ?></div>

                                                <?php if ($product->is_on_sale() && !empty($discount_percent) && $discount_percent > 0) : ?>
                                                    <span class="sale">
                        <span class="num"><?php echo esc_html($discount_percent); ?></span>
                        <span class="sale-symbol">%</span>
                    </span>
                                                <?php endif; ?>
                                            </div>

                                        <?php else : ?>
                                            <div class="no_price">
                                                <span>تماس بگیرید</span>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15"
                                                     viewBox="0 0 15 15" fill="none">
                                                    <path
                                                            d="M3.48438 1.25C4.09773 1.25 4.64916 1.62387 4.87695 2.19336L5.4873 3.71875C5.77691 4.44301 5.46326 5.2683 4.76562 5.61719L4.5 5.75C4.5 5.75 4.875 7.625 6.375 9.125C7.875 10.625 9.75 11 9.75 11L9.88281 10.7344C10.2317 10.0367 11.057 9.72309 11.7812 10.0127L13.3066 10.623C13.8761 10.8508 14.25 11.4023 14.25 12.0156V13.25C14.25 14.0784 13.5784 14.75 12.75 14.75C6.12258 14.75 0.75 9.37742 0.75 2.75C0.75 1.92157 1.42157 1.25 2.25 1.25H3.48438ZM8.25 3.6875C8.71783 3.6875 9.18106 3.77995 9.61328 3.95898C10.0455 4.13802 10.4387 4.39968 10.7695 4.73047C11.1003 5.06126 11.362 5.45453 11.541 5.88672C11.72 6.31894 11.8125 6.78217 11.8125 7.25C11.8125 7.56066 11.5607 7.8125 11.25 7.8125C10.9393 7.8125 10.6875 7.56066 10.6875 7.25C10.6875 6.92996 10.6244 6.61307 10.502 6.31738C10.3795 6.02165 10.2 5.75271 9.97363 5.52637C9.74729 5.30002 9.47835 5.12054 9.18262 4.99805C8.88693 4.87559 8.57004 4.8125 8.25 4.8125C7.93934 4.8125 7.6875 4.56066 7.6875 4.25C7.6875 3.93934 7.93934 3.6875 8.25 3.6875ZM8.25 0.6875C9.1118 0.6875 9.96552 0.857704 10.7617 1.1875C11.5577 1.51729 12.2814 2.00011 12.8906 2.60938C13.4999 3.21864 13.9827 3.94227 14.3125 4.73828C14.6423 5.53448 14.8125 6.3882 14.8125 7.25C14.8125 7.56066 14.5607 7.8125 14.25 7.8125C13.9393 7.8125 13.6875 7.56066 13.6875 7.25C13.6875 6.53594 13.5467 5.82865 13.2734 5.16895C13.0002 4.50933 12.5996 3.91013 12.0947 3.40527C11.5899 2.90042 10.9907 2.49982 10.3311 2.22656C9.67135 1.9533 8.96406 1.8125 8.25 1.8125C7.93934 1.8125 7.6875 1.56066 7.6875 1.25C7.6875 0.93934 7.93934 0.6875 8.25 0.6875Z"
                                                            fill="white"></path>
                                                </svg>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <?php break;
                            }
                            ?>

                        </div>
                    </div>
                <?php
                endwhile;
            } else {
                echo "<p>مطلبی پیدا نشد</p>";
            }
            wp_reset_postdata();
            ?>
        </div>
        </section>
        <?php
    }
}