<?php

class Elementor_ultra_teamMembers_widget extends \Elementor\Widget_Base
{
    public function get_name() {
        return 'ultra_teamMembers';
    }

    public function get_title() {
        return 'اعضای تیم اولترا';
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_categories() {
        return ['ultra'];
    }

    public function get_keywords() {
        return ['Team', 'Profiles', 'Members'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('اعضای تیم', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control('img_team', [
            'label' => 'عکس عضو',
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
        ]);
        $repeater->add_control('name', [
            'label' => 'نام',
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'نام شخص',
        ]);

        $repeater->add_control('description', [
            'label' => 'توضیح کوتاه',
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'توضیح کوتاه درباره شخص',
        ]);

        $repeater->add_control('facebook', [
            'label' => 'فیسبوک',
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => 'https://facebook.com/',
        ]);

        $repeater->add_control('twitter', [
            'label' => 'توییتر',
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => 'https://twitter.com/',
        ]);

        $repeater->add_control('instagram', [
            'label' => 'اینستاگرام',
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => 'https://instagram.com/',
        ]);

        $repeater->add_control('whatsapp', [
            'label' => 'واتساپ',
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => 'https://wa.me/...',
        ]);

        $repeater->add_control('youtube', [
            'label' => 'یوتیوب',
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => 'https://youtube.com/',
        ]);

        $this->add_control('teamMembers', [
            'label' => 'لیست اعضا',
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
        ]);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'shape_svg_section',
            [
                'label' => __('تنظیمات اشکال تزئینی', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('global_shape2_svg', [
            'label' => 'کد SVG شکل بالای عکس (ردپا)',
            'type' => \Elementor\Controls_Manager::CODE,
            'language' => 'html',
            'rows' => 10,
            'default' => '<svg width="127" height="84" viewBox="0 0 127 84" fill="none" xmlns="http://www.w3.org/2000/svg" data-inject-url="https://petpal.torbateno.ir/assets/img/team/team_img_shape02.svg" class="injectable">
                                            <path d="M2.11135 29.6298C2.11135 29.6298 -1.96487 21.6589 3.14219 13.9667C7.27878 7.63917 16.4671 7.0997 21.0488 13.0911C22.4436 14.9356 23.6642 17.471 24.52 20.9516C28.3978 37.125 21.9686 42.3115 21.9686 42.3115C21.9686 42.3115 9.94138 50.7644 2.11135 29.6298Z" fill="currentcolor"></path>
                                            <path d="M40.1946 18.1642C40.1946 18.1642 45.178 -1.53029 58.6976 0.778556C58.6976 0.778556 73.118 1.22375 72.7058 18.6459C72.2937 36.068 62.8659 53.6209 50.5203 50.3352C50.3256 50.2553 31.7091 48.7273 40.1946 18.1642Z" fill="currentcolor"></path>
                                            <path d="M89.2309 33.3096C99.9647 23.3201 108.328 32.2041 108.328 32.2041C117.351 39.4621 107.7 53.5874 107.7 53.5874C93.1175 75.9999 81.7649 65.0877 81.6599 64.9797C72.6556 59.0368 78.4617 43.2987 89.2309 33.3096Z" fill="currentcolor"></path>
                                            <path d="M126.089 73.4137C124.622 79.9295 118.448 81.7945 118.448 81.7945C103.552 88.2598 101.958 77.7762 101.958 77.7762C101.958 77.7762 101.45 71.8046 111.79 65.7601C114.007 64.46 115.926 63.8363 117.592 63.6532C123.016 63.0429 127.301 68.1038 126.089 73.4137Z" fill="currentcolor"></path>
                                        </svg>',
            'description' => 'کد SVG دایره یا تزئین اطراف تصویر اعضای تیم را وارد کنید. اگر خالی بگذارید، حذف خواهد شد.',
        ]);
        $this->add_control('global_shape1_svg', [
             'label' => 'کد SVG دور عکس (دایره نقطه‌چین)',
            'type' => \Elementor\Controls_Manager::CODE,
            'language' => 'html',
            'rows' => 10,
            'default' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 284 263" fill="none" x="0px" y="0px" preserveAspectRatio="none" data-inject-url="https://petpal.torbateno.ir/assets/img/team/team_img_shape01.svg" class="injectable">
                                            <path class="animation-dashed" d="M6.10826 107.444L6.10828 107.444L6.10831 107.444L6.11408 107.425L6.11916 107.406C6.38877 106.405 6.66335 105.413 6.94283 104.43L5.98096 104.157C6.54248 102.182 7.12371 100.244 7.72394 98.3417L8.6776 98.6425C9.28902 96.7047 9.92017 94.8044 10.5703 92.9409L9.62609 92.6115C10.3038 90.6691 11.002 88.7663 11.72 86.9024L12.6532 87.2618C13.3837 85.3653 14.1347 83.5094 14.9052 81.6934L13.9846 81.3028C14.7869 79.412 15.6103 77.5639 16.4538 75.7575L17.3599 76.1807C18.2221 74.3341 19.1055 72.5318 20.0088 70.7726L19.1192 70.3158C20.0526 68.4979 21.0074 66.7254 21.9823 64.9974L22.8532 65.4887C23.8584 63.7069 24.8851 61.9729 25.9317 60.2854L25.0819 59.7583C26.1522 58.0327 27.2435 56.3552 28.3544 54.7245L29.1809 55.2875C30.3356 53.5926 31.5115 51.9488 32.7069 50.3547L31.9069 49.7548C33.1337 48.1188 34.3812 46.5346 35.6476 45.0005L36.4188 45.6372C37.7074 44.0763 39.0156 42.5679 40.3416 41.1105L39.602 40.4375C40.9857 38.9166 42.3889 37.4505 43.8094 36.0373L44.5147 36.7462C45.9504 35.3179 47.404 33.9442 48.8731 32.6232L48.2045 31.8796C49.7191 30.5179 51.2502 29.2116 52.7956 27.9586L53.4254 28.7354C55.0055 27.4544 56.6006 26.2296 58.2083 25.0588L57.6196 24.2504C59.2709 23.0479 60.9354 21.9019 62.6105 20.8098L63.1566 21.6475C64.8485 20.5445 66.5514 19.497 68.2624 18.5026L67.7599 17.638C69.5225 16.6136 71.2937 15.645 73.0703 14.7296L73.5284 15.6185C75.3311 14.6897 77.1398 13.8159 78.9512 12.9943L78.5381 12.0836C80.3975 11.2403 82.2596 10.4516 84.121 9.71452L84.4891 10.6443C86.3706 9.89924 88.2515 9.20724 90.1285 8.56506L89.8048 7.61891C91.7339 6.9589 93.6586 6.35121 95.5751 5.79238L95.855 6.7524C97.7994 6.18541 99.7356 5.66904 101.66 5.19965L101.423 4.22814C103.414 3.74233 105.392 3.30655 107.352 2.91681L107.547 3.89761C109.545 3.50029 111.525 3.15111 113.482 2.8458L113.328 1.85775C115.359 1.54097 117.365 1.27113 119.34 1.04352L119.455 2.03695C121.489 1.80269 123.49 1.61343 125.455 1.46396L125.379 0.466844C127.441 0.309957 129.461 0.196663 131.434 0.121003L131.472 1.12027C133.536 1.04112 135.547 1.0034 137.498 1.00022L137.496 0.000222021C139.587 -0.00318751 141.609 0.0328347 143.553 0.0998856L143.519 1.09929C145.611 1.17146 147.613 1.27979 149.512 1.41368L149.582 0.416153C151.745 0.568686 153.776 0.754194 155.658 0.957183L155.55 1.95141C157.747 2.18843 159.739 2.44936 161.497 2.70919L161.643 1.71993C164.124 2.0865 166.146 2.45111 167.633 2.74466L167.44 3.72573C168.378 3.91103 169.1 4.06739 169.585 4.17696C169.828 4.23175 170.011 4.27483 170.133 4.30397C170.194 4.31854 170.24 4.32963 170.269 4.33695L170.302 4.34508L170.31 4.34696L170.311 4.34735L170.356 4.35853L170.401 4.36558L170.402 4.36586L170.41 4.36706L170.443 4.37239C170.473 4.37725 170.518 4.38476 170.579 4.39504C170.701 4.41561 170.884 4.44727 171.125 4.49108C171.608 4.57868 172.323 4.71482 173.246 4.9078L173.45 3.92895C174.915 4.23497 176.893 4.68169 179.291 5.30136L179.041 6.26957C180.75 6.71116 182.675 7.24139 184.78 7.8721L185.067 6.91418C186.854 7.44983 188.771 8.0574 190.796 8.74406L190.474 9.69107C192.26 10.2965 194.129 10.9639 196.069 11.6981L196.423 10.7628C198.229 11.4466 200.096 12.188 202.011 12.9911L201.624 13.9133C203.397 14.6568 205.212 15.4534 207.059 16.3062L207.479 15.3983C209.25 16.2159 211.05 17.085 212.872 18.0082L212.42 18.9002C214.159 19.781 215.917 20.7113 217.687 21.6936L218.172 20.8192C219.892 21.7738 221.624 22.7772 223.362 23.8317L222.843 24.6866C224.516 25.702 226.193 26.7649 227.87 27.8774L228.423 27.0441C230.065 28.1341 231.707 29.2714 233.342 30.4579L232.755 31.2673C234.342 32.4186 235.922 33.6164 237.491 34.8624L238.113 34.0793C239.661 35.3084 241.199 36.5843 242.72 37.9086L242.064 38.663C243.545 39.9515 245.011 41.286 246.457 42.668L247.148 41.945C248.579 43.312 249.991 44.7253 251.381 46.1862L250.656 46.8753C252.009 48.298 253.34 49.7661 254.644 51.281L255.402 50.6283C256.694 52.128 257.96 53.6733 259.198 55.2656L258.408 55.8792C259.613 57.4286 260.789 59.0227 261.934 60.6627L262.754 60.0902C263.887 61.7127 264.99 63.3799 266.059 65.0929L265.21 65.6223C266.248 67.2857 267.254 68.9927 268.225 70.7443L269.1 70.2596C270.056 71.9853 270.979 73.754 271.864 75.5667L270.966 76.0056C271.824 77.762 272.647 79.5601 273.432 81.4009L274.352 81.0084C275.126 82.8212 275.863 84.675 276.561 86.5706L275.623 86.9164C275.966 87.8475 276.3 88.7888 276.624 89.7405C276.934 90.6556 277.233 91.5774 277.521 92.5057L278.476 92.2095C279.054 94.0759 279.588 95.9676 280.077 97.8819L279.108 98.1293C279.588 100.008 280.024 101.91 280.416 103.83L281.396 103.63C281.786 105.542 282.133 107.473 282.436 109.42L281.448 109.574C281.746 111.489 282.001 113.42 282.214 115.365L283.208 115.256C283.421 117.2 283.591 119.158 283.718 121.126L282.72 121.19C282.845 123.129 282.929 125.079 282.97 127.037L283.97 127.016C284.011 128.972 284.01 130.935 283.968 132.905L282.968 132.883C282.926 134.825 282.843 136.772 282.718 138.722L283.716 138.786C283.591 140.74 283.425 142.697 283.217 144.656L282.223 144.55C282.018 146.485 281.772 148.421 281.485 150.356L282.474 150.503C282.187 152.44 281.858 154.376 281.489 156.309L280.507 156.122C280.142 158.032 279.736 159.938 279.29 161.839L280.263 162.068C279.816 163.976 279.327 165.878 278.798 167.773L277.834 167.504C277.311 169.379 276.746 171.247 276.141 173.105L277.092 173.415C276.486 175.278 275.839 177.131 275.151 178.974L274.214 178.624C273.533 180.446 272.813 182.257 272.051 184.054L272.972 184.444C272.208 186.249 271.403 188.041 270.557 189.817L269.654 189.387C268.817 191.145 267.94 192.886 267.023 194.611L267.906 195.081C266.986 196.81 266.026 198.521 265.026 200.214L264.165 199.705C263.176 201.378 262.147 203.032 261.078 204.665L261.914 205.213C260.841 206.852 259.728 208.471 258.574 210.067L257.763 209.481C256.625 211.055 255.447 212.607 254.23 214.134L255.012 214.757C253.793 216.287 252.534 217.792 251.236 219.271L250.484 218.611C249.204 220.07 247.884 221.503 246.525 222.908L247.244 223.603C245.883 225.011 244.484 226.391 243.045 227.743L242.36 227.014C240.95 228.338 239.502 229.635 238.015 230.901L238.664 231.663C237.177 232.929 235.653 234.166 234.09 235.372L233.479 234.58C231.942 235.766 230.368 236.922 228.757 238.045L229.329 238.866C227.733 239.978 226.102 241.059 224.434 242.107L223.902 241.26C222.265 242.289 220.592 243.285 218.884 244.249L219.375 245.12C217.673 246.08 215.935 247.008 214.162 247.901L213.712 247.008C211.994 247.874 210.242 248.707 208.457 249.506L208.866 250.419C207.087 251.215 205.276 251.978 203.432 252.706L203.065 251.776C201.267 252.486 199.437 253.163 197.575 253.806L197.902 254.751C196.07 255.383 194.208 255.982 192.314 256.547L192.028 255.589C190.168 256.144 188.278 256.666 186.358 257.153L186.604 258.122C184.732 258.597 182.832 259.04 180.903 259.449L180.695 258.471C178.803 258.873 176.884 259.242 174.936 259.578L175.106 260.563C173.194 260.893 171.257 261.19 169.292 261.455L169.159 260.464C167.248 260.721 165.312 260.948 163.35 261.142L163.448 262.137C161.512 262.328 159.551 262.489 157.565 262.618L157.501 261.62C155.581 261.744 153.638 261.838 151.671 261.902L151.704 262.901C149.756 262.964 147.785 262.998 145.791 263L145.79 262C143.868 262.002 141.924 261.976 139.959 261.92L139.93 262.92C137.982 262.864 136.013 262.78 134.023 262.667L134.08 261.669C132.158 261.559 130.216 261.423 128.254 261.258L128.171 262.254C126.233 262.091 124.275 261.901 122.299 261.684L122.409 260.69C121.425 260.581 120.436 260.466 119.442 260.344C118.436 260.22 117.438 260.091 116.449 259.958L116.315 260.949C114.329 260.681 112.376 260.394 110.454 260.089L110.611 259.101C108.686 258.795 106.794 258.471 104.935 258.128L104.753 259.111C102.758 258.744 100.8 258.355 98.8783 257.947L99.0861 256.969C97.1731 256.562 95.2963 256.136 93.4551 255.69L93.2198 256.662C91.2569 256.187 89.3338 255.69 87.4498 255.172L87.715 254.208C85.8195 253.687 83.9641 253.144 82.1481 252.581L81.852 253.536C79.9305 252.94 78.0523 252.322 76.2167 251.681L76.5462 250.737C74.6894 250.089 72.8767 249.419 71.1071 248.727L70.743 249.658C68.868 248.925 67.0408 248.168 65.2601 247.387L65.6614 246.472C63.8678 245.686 62.1223 244.877 60.4235 244.046L59.9841 244.944C58.1697 244.057 56.4077 243.144 54.6969 242.208L55.1769 241.331C53.4518 240.387 51.7795 239.419 50.1585 238.429L49.6372 239.282C47.928 238.238 46.275 237.169 44.6764 236.077L45.2405 235.251C43.6058 234.134 42.0288 232.993 40.5077 231.83L39.9002 232.625C38.3288 231.423 36.816 230.197 35.3599 228.95L36.0104 228.191C34.5028 226.899 33.0567 225.585 31.67 224.249L30.9763 224.969C29.5419 223.588 28.1701 222.184 26.8584 220.76L27.5938 220.083C26.2652 218.641 24.999 217.178 23.7926 215.698L23.0175 216.33C21.761 214.789 20.5687 213.228 19.4376 211.651L20.2501 211.068C19.1028 209.469 18.0191 207.853 16.9959 206.223L16.149 206.755C15.0949 205.076 14.1044 203.382 13.1742 201.678L14.0519 201.199C13.1137 199.48 12.2375 197.75 11.4197 196.013L10.5148 196.438C9.67194 194.647 8.89064 192.848 8.16726 191.045L9.09536 190.673C8.36359 188.849 7.69154 187.02 7.07534 185.192L6.12768 185.511C5.49455 183.632 4.91994 181.753 4.39969 179.878L5.36329 179.61C4.83799 177.717 4.36851 175.828 3.95054 173.947L2.97435 174.164C2.54405 172.228 2.16795 170.301 1.84138 168.388L2.82712 168.22C2.49572 166.279 2.21568 164.353 1.98207 162.446L0.989493 162.567C0.747693 160.594 0.5553 158.641 0.406886 156.715L1.40393 156.639C1.25186 154.666 1.14629 152.721 1.08132 150.81L0.0818934 150.844C0.0137625 148.84 -0.0100384 146.875 0.00375479 144.954L1.00373 144.961C1.01808 142.962 1.07344 141.012 1.16213 139.118L0.163222 139.071C0.258318 137.04 0.391465 135.075 0.553291 133.184L1.54965 133.269C1.72423 131.229 1.9324 129.277 2.16226 127.425L1.16987 127.302C1.42795 125.222 1.71318 123.268 2.00891 121.456L2.99584 121.617C3.34064 119.505 3.69974 117.589 4.04632 115.896L3.06664 115.695C3.55701 113.3 4.02281 111.348 4.38942 109.918L5.35813 110.166C5.58591 109.277 5.77458 108.593 5.90575 108.133C5.97134 107.903 6.02254 107.729 6.05706 107.613C6.07432 107.555 6.08741 107.512 6.09604 107.484L6.1056 107.453L6.1078 107.445L6.10826 107.444Z" stroke="currentcolor" stroke-width="2" stroke-dasharray="6 6"></path>
                                        </svg>',
            'description' => 'می‌توانید کد SVG شکل بالای تصویر را وارد کنید یا خالی بگذارید تا نمایش داده نشود.',
        ]);
        
        $this->end_controls_section();

        
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل ها', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('hover_overlay_color', [
            'label' => __('رنگ هاور ماسک تصویر', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-team-area .team-item .team-img .mask-img::before' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_control('shape_color', [
            'label' => __('رنگ Shape', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-team-area .team-item .team-img .team__item-img-shape .shape-1 svg' => 'color: {{VALUE}};',
                '{{WRAPPER}} .ultra-team-area .team-item .team-img .team__item-img-shape .shape-2 svg' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_control('social_hover_color', [
            'label' => __('رنگ هاور آیکون‌های اجتماعی', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-team-area .team-item .team-img .team__social ul li a:hover' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_control('name_color', [
            'label' => __('رنگ نام شخص', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-team-area .team-item .name' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_control('desc_color', [
            'label' => __('رنگ توضیحات کوتاه', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .team-item span:not(.name)' => 'color: {{VALUE}};',
            ],
        ]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (!empty($settings['teamMembers'])): ?>
            <section class="ultra-team-area">
                <?php foreach ($settings['teamMembers'] as $item): ?>
                    <div class="team-item">
                        <div class="team-img">
                            <div class="mask-img">
                                <img src="<?php echo esc_url($item['img_team']['url']); ?>" alt="<?php echo esc_attr($item['name']); ?>">
                            </div>
                                <div class="team__item-img-shape">
                                    <div class="shape-1">
                                        <?php if (!empty($settings['global_shape1_svg'])): ?>
                                            <?php echo $settings['global_shape1_svg']; ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="shape-2">
                                         <?php if (!empty($settings['global_shape2_svg'])): ?>
                                            <?php echo $settings['global_shape2_svg']; ?>
                                        <?php endif; ?>
                                    </div>
                            </div>
                            <div class="team__social">
                                <ul class="list-wrap">
                                    <?php if (!empty($item['facebook']['url'])): ?>
                                        <li><a href="<?php echo esc_url($item['facebook']['url']); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a></li>
                                    <?php endif; ?>
                                    <?php if (!empty($item['twitter']['url'])): ?>
                                        <li><a href="<?php echo esc_url($item['twitter']['url']); ?>" target="_blank"><i class="fab fa-twitter"></i></a></li>
                                    <?php endif; ?>
                                    <?php if (!empty($item['whatsapp']['url'])): ?>
                                        <li><a href="<?php echo esc_url($item['whatsapp']['url']); ?>" target="_blank"><i class="fab fa-whatsapp"></i></a></li>
                                    <?php endif; ?>
                                    <?php if (!empty($item['instagram']['url'])): ?>
                                        <li><a href="<?php echo esc_url($item['instagram']['url']); ?>" target="_blank"><i class="fab fa-instagram"></i></a></li>
                                    <?php endif; ?>
                                    <?php if (!empty($item['youtube']['url'])): ?>
                                        <li><a href="<?php echo esc_url($item['youtube']['url']); ?>" target="_blank"><i class="fab fa-youtube"></i></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>

                        <span class="name"><?php echo esc_html($item['name']); ?></span>
                        <span><?php echo esc_html($item['description']); ?></span>
                    </div>
                <?php endforeach; ?>
            </section>
        <?php endif;
    }
}