<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Elementor_ultra_support_widget extends \Elementor\Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve oEmbed widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     */
    public function get_name(): string
    {
        return 'ultra_support_widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve oEmbed widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     */
    public function get_title(): string
    {
        return esc_html__('پشتیبانی اولترا');
    }

    /**
     * Get widget icon.
     *
     * Retrieve oEmbed widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     */
    public function get_icon(): string
    {
        return 'eicon-headphones';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the oEmbed widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     */
    public function get_categories(): array
    {
        return ['ultra'];
    }

    /**
     * Get widget keywords.
     *
     * Retrieve the list of keywords the oEmbed widget belongs to.
     *
     * @return array Widget keywords.
     * @since 1.0.0
     * @access public
     */
    public function get_keywords(): array
    {
        return ['support', 'contact', 'help'];
    }

    /**
     * Get custom help URL.
     *
     * Retrieve a URL where the user can get more information about the widget.
     *
     * @return string Widget help URL.
     * @since 1.0.0
     * @access public
     */
    public function get_custom_help_url(): string
    {
        return 'https://developers.elementor.com/docs/widgets/';
    }

    /**
     * Whether the widget requires inner wrapper.
     *
     * Determine whether to optimize the DOM size.
     *
     * @return bool Whether to optimize the DOM size.
     * @since 1.0.0
     * @access public
     */
    public function has_widget_inner_wrapper(): bool
    {
        return false;
    }

    /**
     * Whether the element returns dynamic content.
     *
     * Determine whether to cache the element output or not.
     *
     * @return bool Whether to cache the element output.
     * @since 1.0.0
     * @access protected
     */
    protected function is_dynamic_content(): bool
    {
        return false;
    }

    /**
     * Register oEmbed widget controls.
     *
     * Add input fields to allow the user to customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls(): void
    {

        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', 'ultra-market'),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('تصویر', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => ['url' => ''],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('به پشتیبانی نیاز دارید؟', 'ultra-market'),
            ]
        );

        $this->add_control(
            'desc',
            [
                'label' => esc_html__('توضیحات', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('تیم ما در هر ساعت از شبانه روز پاسخگوی مشکلات و سوالات شما هستند.', 'ultra-market'),
            ]
        );

        $this->add_control(
            'phone',
            [
                'label' => esc_html__('شماره تماس', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '۰۲۱-۲۷۶۵۹۸۲۳',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'socials_section',
            [
                'label' => esc_html__('لینک شبکه‌های اجتماعی', 'ultra-market'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'twitter_link',
            [
                'label' => esc_html__( ' شبکه توییتر', 'textdomain' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://twitter.com/yourprofile',
                'default'     => [ 'url' => '' ],
            ]
        );
        $this->add_control(
            'whatsapp_link',
            [
                'label' => esc_html__( ' شبکه واتساپ', 'textdomain' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://wa.me/your-number',
                'default'     => [ 'url' => '' ],
            ]
        );
        $this->add_control(
            'instagram_link',
            [
                'label' => esc_html__( ' شبکه اینستاگرام', 'textdomain' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://instagram.com/yourprofile',
                'default'     => [ 'url' => '' ],
            ]
        );
        $this->add_control(
            'telegram_link',
            [
                'label' => esc_html__( ' شبکه اینستاگرام', 'textdomain' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://t.me/yourchannel',
                'default'     => [ 'url' => '' ],
            ]
        );

        $this->end_controls_section();


        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'ultra-market'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bg_color_widget',
            [
                'label' => esc_html__('رنگ زمینه', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#007AF4',
                'selectors' => [
                    '{{WRAPPER}} .ultra-contactus-widget' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        //  Typography & Description Color
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-contactus-widget .middle-text .title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__('رنگ توضیحات', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-contactus-widget .middle-text .desc' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        // Phone Color
        $this->add_control(
            'phone_title_color',
            [
                'label' => esc_html__('رنگ عنوان شماره تماس', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-contactus-widget .content .number-box .text-number span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'phone_svg_color',
            [
                'label' => esc_html__('رنگ آیکون تماس', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-contactus-widget .content .number-box .text-number svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'phone_num_color',
            [
                'label' => esc_html__('رنگ شماره تماس', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-contactus-widget .content .number-box .number' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'hr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'bg_social_color',
            [
                'label' => esc_html__('رنگ زمینه شبکه اجتماعی', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-contactus-widget .social-box a' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_social_color',
            [
                'label' => esc_html__('رنگ شبکه اجتماعی', 'ultra-market'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-contactus-widget .social-box svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render oEmbed widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="ultra-contactus-widget">

            <div class="content">
                <?php if ($settings['image']['url']) : ?>
                    <img src="<?php echo esc_url($settings['image']['url']); ?>"/>
                <?php endif; ?>
                <div class="middle-text">
                    <p class="title"><?php echo esc_html($settings['title']); ?></p>
                    <p class="desc"><?php echo esc_html($settings['desc']); ?></p>
                </div>

                <div class="number-box">
                    <span class="text-number">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 24 25" fill="none">
              <path d="M17.5244 14.7807L20.1404 16.3405C20.6808 16.6632 20.9598 17.2907 20.8361 17.9083C20.3303 20.4412 17.7867 22.0644 15.2955 21.3805C9.41721 19.7671 4.82555 15.1894 3.20629 9.29831C2.52137 6.80607 4.14271 4.26036 6.67653 3.75359L6.6932 3.75063C7.31181 3.62691 7.94245 3.90702 8.26413 4.4504L9.81113 7.06242C10.3614 7.99181 10.0881 9.18843 9.18841 9.78625L7.54451 10.88C8.70452 13.6582 10.9215 15.8843 13.6919 17.0423L14.7955 15.3943C15.3983 14.4966 16.596 14.2274 17.5244 14.7807Z"
                    fill="#007AF4"/>
            </svg>
                        <span>شماره تلفن</span>
                    </span>
                    <a href="tel:<?php echo esc_html($settings['phone']); ?>" class="number"><?php echo esc_html($settings['phone']); ?></a>
                </div>

            </div>

            <div class="social-box">
                <?php if ( ! empty( $settings['twitter_link']['url'] ) ) : ?>
                    <a href="<?php echo esc_url( $settings['twitter_link']['url'] ); ?>"
                        <?php echo $settings['twitter_link']['is_external'] ? ' target="_blank"' : ''; ?>
                        <?php echo $settings['twitter_link']['nofollow']    ? ' rel="nofollow"' : ''; ?>>
                        <svg xmlns="http://www.w3.org/2000/svg" width="31" height="30" viewBox="0 0 31 30" fill="none">
                            <path d="M25.5305 9.98789C25.543 10.2004 25.543 10.4254 25.543 10.6504C25.543 17.3254 20.393 25.0129 10.968 25.0129C8.06796 25.0129 5.36797 24.1879 3.10547 22.7504C3.51797 22.8004 3.91798 22.8129 4.34298 22.8129C6.74298 22.8129 8.94297 22.0129 10.7055 20.6629C8.45547 20.6129 6.56797 19.1629 5.91797 17.1629C6.23047 17.2129 6.55547 17.2379 6.88047 17.2379C7.34297 17.2379 7.80548 17.1754 8.23048 17.0629C5.88048 16.5879 4.11797 14.5629 4.11797 12.1129V12.0504C4.80547 12.4254 5.59297 12.6629 6.43047 12.6879C5.05547 11.7754 4.14297 10.2379 4.14297 8.48788C4.14297 7.55038 4.39297 6.68789 4.84297 5.93789C7.36797 9.00039 11.1555 11.0004 15.4055 11.2254C15.3305 10.8504 15.2805 10.4629 15.2805 10.0754C15.2805 7.28788 17.568 5.02539 20.4055 5.02539C21.8805 5.02539 23.218 5.63788 24.143 6.61288C25.3055 6.40038 26.4055 5.97539 27.393 5.40039C27.018 6.57539 26.2055 7.56288 25.143 8.17538C26.168 8.06288 27.168 7.78788 28.093 7.40038C27.393 8.40038 26.518 9.28788 25.518 10.0129L25.5305 9.98789Z" fill="#007AF4"></path>
                        </svg>
                    </a>
                <?php endif; ?>

                <?php if ( ! empty( $settings['whatsapp_link']['url'] ) ) : ?>
                    <a href="<?php echo esc_url( $settings['whatsapp_link']['url'] ); ?>"
                        <?php echo $settings['whatsapp_link']['is_external'] ? ' target="_blank"' : ''; ?>
                        <?php echo $settings['whatsapp_link']['nofollow']    ? ' rel="nofollow"' : ''; ?>>
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30" fill="none">
                            <path d="M14.6053 3.75C8.5563 3.75 3.65137 8.7875 3.65137 15C3.65137 17.0875 4.21125 19.05 5.18493 20.7375L3.65137 26.25L9.01877 24.675C10.6619 25.675 12.5727 26.25 14.6053 26.25C20.6543 26.25 25.5593 21.2125 25.5593 15C25.5593 8.7875 20.6543 3.75 14.6053 3.75ZM20.4718 19.3C20.2162 20.0375 18.999 20.7125 18.4513 20.775C17.9036 20.8375 17.3925 21.0375 14.8609 20.0125C11.8182 18.7625 9.88295 15.5375 9.73689 15.3375C9.59084 15.1375 8.51979 13.6625 8.51979 12.1375C8.51979 10.6125 9.28655 9.875 9.56648 9.55C9.84642 9.2375 10.1751 9.1625 10.3698 9.1625C10.5767 9.1625 10.7714 9.1625 10.954 9.175C11.1609 9.175 11.4043 9.17499 11.6234 9.69999C11.8912 10.3125 12.4632 11.8375 12.5362 11.975C12.6092 12.125 12.658 12.3125 12.5606 12.5125C12.451 12.7125 12.4024 12.85 12.2563 13.025C12.1103 13.2 11.9399 13.425 11.806 13.5625C11.6478 13.7125 11.5017 13.875 11.6721 14.1875C11.8547 14.4875 12.4511 15.5125 13.3396 16.325C14.4836 17.3875 15.4451 17.7125 15.7494 17.8625C16.0415 18.0125 16.224 17.9875 16.3944 17.7875C16.577 17.5875 17.1491 16.8875 17.3438 16.575C17.5385 16.275 17.7333 16.325 18.0132 16.425C18.2931 16.525 19.7536 17.2875 20.0579 17.4375C20.35 17.6 20.557 17.675 20.63 17.8C20.703 17.925 20.703 18.55 20.4596 19.275L20.4718 19.3Z" fill="#007AF4"></path>
                        </svg>
                    </a>
                <?php endif; ?>

                <?php if ( ! empty( $settings['instagram_link']['url'] ) ) : ?>
                    <a href="<?php echo esc_url( $settings['instagram_link']['url'] ); ?>"
                        <?php echo $settings['instagram_link']['is_external'] ? ' target="_blank"' : ''; ?>
                        <?php echo $settings['instagram_link']['nofollow']    ? ' rel="nofollow"' : ''; ?>>
                        <svg xmlns="http://www.w3.org/2000/svg" width="31" height="30" viewBox="0 0 31 30" fill="none">
                            <path d="M26.7809 10.3627C26.6934 8.56268 26.2809 6.96269 24.9684 5.65019C23.6559 4.33769 22.0559 3.9252 20.2559 3.8377C18.3934 3.7377 12.8309 3.7377 10.9809 3.8377C9.18086 3.9252 7.59337 4.33769 6.26837 5.65019C4.94337 6.96269 4.54336 8.56268 4.45586 10.3627C4.35586 12.2252 4.35586 17.7877 4.45586 19.6502C4.54336 21.4502 4.95587 23.0502 6.26837 24.3627C7.59337 25.6752 9.18086 26.0877 10.9809 26.1752C12.8434 26.2752 18.4059 26.2752 20.2559 26.1752C22.0559 26.0877 23.6559 25.6752 24.9684 24.3627C26.2809 23.0502 26.6934 21.4502 26.7809 19.6502C26.8809 17.7877 26.8809 12.2252 26.7809 10.3752V10.3627ZM15.6059 20.9377C12.3309 20.9377 9.66838 18.2752 9.66838 15.0002C9.66838 11.7252 12.3309 9.06269 15.6059 9.06269C18.8809 9.06269 21.5434 11.7252 21.5434 15.0002C21.5434 18.2752 18.8809 20.9377 15.6059 20.9377ZM22.5059 9.37519C21.8184 9.37519 21.2559 8.81269 21.2559 8.12519C21.2559 7.43769 21.8059 6.87519 22.5059 6.87519C23.1934 6.87519 23.7559 7.43769 23.7559 8.12519C23.7559 8.81269 23.1934 9.37519 22.5059 9.37519ZM19.6684 15.0002C19.6684 17.2377 17.8434 19.0627 15.6059 19.0627C13.3684 19.0627 11.5434 17.2377 11.5434 15.0002C11.5434 12.7627 13.3684 10.9377 15.6059 10.9377C17.8434 10.9377 19.6684 12.7627 19.6684 15.0002Z" fill="#007AF4"></path>
                        </svg>
                    </a>
                <?php endif; ?>

                <?php if ( ! empty( $settings['telegram_link']['url'] ) ) : ?>
                    <a href="<?php echo esc_url( $settings['telegram_link']['url'] ); ?>"
                        <?php echo $settings['telegram_link']['is_external'] ? ' target="_blank"' : ''; ?>
                        <?php echo $settings['telegram_link']['nofollow']    ? ' rel="nofollow"' : ''; ?>>
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30" fill="none">
                            <path d="M5.1603 14.325C11.0389 11.675 14.958 9.93751 16.9297 9.08751C22.5284 6.67501 23.6968 6.2625 24.4514 6.25C24.6218 6.25 24.987 6.2875 25.2304 6.4875C25.4373 6.6625 25.486 6.8875 25.5225 7.05C25.5468 7.2125 25.5833 7.5875 25.559 7.875C25.2547 11.175 23.9402 19.1625 23.2708 22.85C22.9909 24.4125 22.431 24.9375 21.8955 24.9875C20.7271 25.1 19.8386 24.1875 18.6945 23.425C16.9175 22.225 15.9195 21.475 14.1912 20.3C12.1952 18.95 13.4853 18.2 14.6294 16.9875C14.9215 16.675 20.0942 11.825 20.1916 11.375C20.2037 11.325 20.2159 11.1125 20.0942 11.0125C19.9725 10.9 19.8021 10.9375 19.6804 10.975C19.4978 11.0125 16.6619 12.95 11.1728 16.7875C10.3695 17.3625 9.63926 17.6375 8.98202 17.625C8.26393 17.6125 6.87641 17.2 5.84187 16.8625C4.57608 16.4375 3.57808 16.2125 3.66328 15.4875C3.71196 15.1125 4.21095 14.725 5.1603 14.3375V14.325Z" fill="#007AF4"></path>
                        </svg>
                    </a>
                <?php endif; ?>
            </div>

        </section>
        <?php
    }

}