<?php

class Elementor_ultra_slider_category_product extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_slider_category_product';
    }


    public function get_title()
    {
        return 'اسلایدر محصولات اختصاصی اولترا';
    }

    public function get_icon()
    {
        return 'eicon-product-breadcrumbs';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product'];
    }

    function get_product_cats()
    {
        $cat_list = [];
        $product_cats = get_terms(array(
            'taxonomy' => 'product_cat',
            'hide_empty' => true,
        ));

        if (!empty($product_cats) && !is_wp_error($product_cats)) {
            foreach ($product_cats as $cat) {
                $cat_list[$cat->term_id] = $cat->name;
            }
        }
        return $cat_list;
    }

    function get_product_tags()
    {
        $tag_list = [];
        $product_tags = get_terms('product_tag');

        if (!empty($product_tags) && !is_wp_error($product_tags)) {
            foreach ($product_tags as $tag) {
                $tag_list[$tag->term_id] = $tag->name;
            }
        }
        return $tag_list;
    }

    function get_product_brands()
    {
        $brand_list = [];
        $product_brands = get_terms('product_brand');

        if (!empty($product_brands) && !is_wp_error($product_brands)) {
            foreach ($product_brands as $brand) {
                $brand_list[$brand->term_id] = $brand->name;
            }
        }
        return $brand_list;
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('المان محصولات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('عنوان'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '',
                'default' => 'جدیدترین محصولات اولترا',
            ]
        );
        $this->add_control(
    'title_icon',
    [
        'label' => __('آیکون عنوان'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fas fa-store',
            'library' => 'fa-solid',
        ],
    ]
);
$this->add_control(
    'link_slider_product',
    [
        'label' => __('لینک دکمه مشاهده', 'textdomain'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => 'https://example.com',
        'default' => [
            'url' => '',
            'is_external' => true,
            'nofollow' => true,
        ],
        'show_external' => true,
    ]
);


        $this->add_control(
            'product_filter',
            [
                'label' => 'فیلتر محصولات',
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'all',
                'options' => [
                    'all' => 'همه محصولات',
                    'category' => 'براساس دسته بندی',
                    'tag' => 'براساس برچسب',
                    'brand' => 'براساس برند',
                ],
            ]
        );
        $this->add_control(
            'cat',
            [
                'label' => 'دسته بندی',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_cats(),
                'condition' => [
                    'product_filter' => 'category',
                ],
            ]
        );
        $this->add_control(
            'tag',
            [
                'label' => 'برچسب',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_tags(),
                'condition' => [
                    'product_filter' => 'tag',
                ],
            ]
        );
        $this->add_control(
            'brand',
            [
                'label' => 'برند',
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->get_product_brands(),
                'condition' => [
                    'product_filter' => 'brand',
                ],
            ]
        );
        $this->add_control(
            'product_rand',
            [
                'label' => esc_html__('تصادفی'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال'),
                'label_off' => esc_html__('غیرفعال'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => 'تعداد محصولات',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 40,
                'step' => 1,
                'default' => 6,
            ]
        );
        $this->add_control(
            'item_slide',
            [
                'label' => 'تعداد آیتم های اسلایدر',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 4,
                'max' => 5,
                'step' => 1,
                'default' => 5,
            ]
        );
       
        $this->add_control(
            'stock',
            [
                'label' => 'حذف محصولات ناموجود',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => 'فعال',
                'label_off' => 'غیرفعال',
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section('style_box_section', [
    'label' => __('استایل باکس محصول', 'textdomain'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
]);

$this->add_control('box_bg_color', [
    'label' => __('رنگ زمینه باکس محصول'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .product-items .item.prod-style-11' => 'background-color: {{VALUE}}',
    ],
]);

$this->add_control('before_bg_color', [
    'label' => __('رنگ زمینه Before (در حالت تخفیف)'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .product-items .item.prod-style-11 .image-sec:has(.discount)::before' => 'background-color: {{VALUE}}',
    ],
]);

$this->end_controls_section();
$this->start_controls_section('style_discount_section', [
    'label' => __('استایل تخفیف، آیکون‌ها و دسته‌بندی', 'textdomain'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
]);

$this->add_control('discount_bg_color', [
    'label' => __('رنگ زمینه تخفیف'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .product-items .discount' => 'background-color: {{VALUE}}',
    ],
]);

$this->add_control('discount_text_color', [
    'label' => __('رنگ متن تخفیف'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .product-items .discount' => 'color: {{VALUE}}',
    ],
]);

$this->add_control('icons_color', [
    'label' => __('رنگ آیکون سبد خرید و علاقه‌مندی'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .woosw-btn-has-icon.woosw-added .woosw-btn-icon, 
         {{WRAPPER}} .product-items .item.prod-style-11 .image-sec .btn-sec i' => 'color: {{VALUE}}',
    ],
]);

$this->add_control('cate_bg_color', [
    'label' => __('رنگ زمینه دسته‌بندی'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .product-items .cate-prod' => 'background-color: {{VALUE}}',
    ],
]);

$this->add_control('cate_text_color', [
    'label' => __('رنگ متن دسته‌بندی'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .product-items .cate-prod' => 'color: {{VALUE}}',
    ],
]);

$this->end_controls_section();
$this->start_controls_section('style_price_title_section', [
    'label' => __('استایل قیمت و نام محصول', 'textdomain'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
]);

$this->add_control('price_color', [
    'label' => __('رنگ قیمت'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .product-items .price' => 'color: {{VALUE}}',
    ],
]);

$this->add_control('sale_price_color', [
    'label' => __('رنگ قیمت تخفیف‌خورده'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .product-items .price ins' => 'color: {{VALUE}}',
    ],
]);

$this->add_control('title_color', [
    'label' => __('رنگ عنوان محصول'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .product-items .prod-info h3' => 'color: {{VALUE}}',
    ],
]);

$this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
 			<div class="product-title">
                <?php
        if (!empty($settings['title_icon']['value'])) {
            echo '<i class="' . esc_attr($settings['title_icon']['value']) . '"></i>';
        }
        ?>
                <h2><?php echo $settings['title'];?></h2>
            </div>
        <div class="product-items">

			  <div class="skeleton-slider">
       <div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
		<div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
		<div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
    </div>
			
			
			
            <div class="owl-carousel owl-theme choosen-prod ">
                <?php
                $product_args = array(
                    'post_type' => 'product',
                    'posts_per_page' => $settings['number'],
                );
                if ($settings['product_filter'] == 'category') {
                    $tax_query = array(
                        'relation' => 'OR',
                        array(
                            'taxonomy' => 'product_cat',
                            'field' => 'term_id',
                            'terms' => $settings['cat'],
                        ),
                    );
                    $product_args['tax_query'] = $tax_query;
                }
                if ($settings['product_rand'] == 'yes') {
                    $product_args['orderby'] = 'rand';
                } elseif ($settings['product_filter'] == 'tag') {
                    $tax_query = array(
                        'relation' => 'OR',
                        array(
                            'taxonomy' => 'product_tag',
                            'field' => 'term_id',
                            'terms' => $settings['tag'],
                        ),
                    );
                    $product_args['tax_query'] = $tax_query;
                } elseif ($settings['product_filter'] == 'brand') {
                    $tax_query = array(
                        'relation' => 'OR',
                        array(
                            'taxonomy' => 'product_brand',
                            'field' => 'term_id',
                            'terms' => $settings['brand'],
                        ),
                    );
                    $product_args['tax_query'] = $tax_query;
                }
                if ($settings['stock']) {
                    $meta_query = array(
                        array(
                            'key' => '_stock_status',
                            'value' => 'instock',
                            'compare' => '=',
                        ),
                    );
                    $product_args['meta_query'] = $meta_query;
                }
                $pro = new WP_Query($product_args);
                if ($pro->have_posts()) {
                    while ($pro->have_posts()) : $pro->the_post();
                        ?>
                        <div class="item-owl">
                            <div class="item prod-style-11">
                                <div href="<?php the_permalink(); ?>" class="image-sec">
                                    <a href="<?php the_permalink(); ?>">
                                        <figure>
                                            <?php global $product;
                                            if (has_post_thumbnail()) {
                                                the_post_thumbnail('product');
                                            } else { ?>
                                                <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                            <?php } ?>
                                        </figure>
                                    </a>
                                    <?php if ($product->is_on_sale() && $product->is_type('simple')) { ?>
                                        <span class="discount"><?php echo ultra_woocommerce_discount(get_the_ID()); ?>%</span>
                                    <?php } ?>
                                    <div class="btn-sec">
                                        <?php $id = $product->get_id(); ?>
                                        <?php echo do_shortcode("[woosw id=$id]"); ?>
                                        <div class="addtocart_button">
                                            <?php
                                            if ($product->is_in_stock() && $product->get_price_html()) {
                                                echo sprintf('<a href="%s" data-quantity="1" class="%s add-cart-btn" %s><i class="fa-solid fa-cart-shopping"></i></a>',
                                                    esc_url($product->add_to_cart_url()),
                                                    esc_attr(implode(' ', array_filter(array(
                                                        'button', 'product_type_' . $product->get_type(),
                                                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                        $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                                                    )))),
                                                    wc_implode_html_attributes(array(
                                                        'data-product_id' => $product->get_id(),
                                                        'data-product_sku' => $product->get_sku(),
                                                        'aria-label' => $product->add_to_cart_description(),
                                                        'rel' => 'nofollow',
                                                    )),
                                                    esc_html($product->add_to_cart_text())
                                                );
                                            } ?>
                                        </div>
                                    </div>

                                    <?php
                                    $cats = get_the_terms($product->ID, 'product_cat');
                                    ?>
                                    <a href="<?= get_term_link($cats[0]->term_id); ?> " class="cate-prod"
                                       target="_blank"><?= $cats[0]->name; ?></a>
                                </div>
                                <div class="prod-info">
                                    <a href="<?php the_permalink(); ?>">
                                        <h3><?php the_title(); ?></h3>
                                    </a>

                                    <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                        <div class="price">
                                            <?php echo $product->get_price_html(); ?>
                                        </div>
                                    <?php } elseif (!$product->is_in_stock()) {
                                        echo "<div class='not_stock'><i class='fa-solid fa-multiply'></i> موجود نیست ! </div>";
                                    } else {
                                        echo "<div class='no_price'>تماس بگیرید !</div>";
                                    } ?>

                                </div>
                            </div>
                        </div>
                    <?php
                    endwhile;
                } else {
                    echo "<p>مطلبی پیدا نشد</p>";
                }
                wp_reset_postdata();
                ?>
                <div class="item-owl">
                     <a href="<?php echo ['link_slider_product']['url']; ?>" <?php echo $link_target; ?> <?php echo $link_nofollow; ?>>
                        <i class="fa-solid fa-eye"></i>
                        <span><?php echo $settings['title_slider_product']; ?></span>
                    </a>
                </div>
            </div>


        </div>


      

            <script>
jQuery(function ($) {

    function getItemCountByContainerWidth(containerWidth) {
        if (containerWidth >= 1820) return <?php echo $settings['item_slide']; ?>;
       if (containerWidth >= 1500) return 6;
        if (containerWidth >= 1200) return 5;
        if (containerWidth >= 992) return 4;
        if (containerWidth >= 768) return 3;
        if (containerWidth >= 430) return 2;
        return 1;
    }

    function initSlider($slider) {
        let containerWidth = $slider.closest('.product-items').width();
        let itemCount = getItemCountByContainerWidth(containerWidth);
        let navEnabled = $slider.data('show-nav') === true || $slider.data('show-nav') === "true";

        $slider.owlCarousel({
            loop: true,
            margin: 16,
            rtl: true,
            dots: false,
            nav: navEnabled,
            navText: "",
            items: itemCount
        });

        setTimeout(function () {
            $slider.siblings('.skeleton-slider').fadeOut(200);
            $slider.fadeIn(200);
        }, 100);
    }

    $('.choosen-prod').each(function () {
        const $slider = $(this);
        $slider.hide(); // مخفی‌سازی اولیه اسلایدر
        initSlider($slider);

        let resizeTimer;
        $(window).on('resize', function () {
            clearTimeout(resizeTimer);
            resizeTimer = setTimeout(function () {
                if ($slider.hasClass('owl-loaded')) {
                    $slider.trigger('destroy.owl.carousel');
                    $slider.removeClass('owl-loaded owl-hidden');
                    $slider.find('.owl-stage-outer').children().unwrap();
                }
                initSlider($slider);
            }, 300);
        });
    });

});
</script>

        <?php
    }

}