<?php

class Elementor_ultra_mainSlider_widget extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'ultra_mainSlider';
    }

    public function get_title()
    {
        return 'اسلایدر اولترا';
    }

    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['slider', 'slideshow'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوای اسلایدر', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'mainSlider',
            [
                'label' => 'اسلایدر',
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'img_slider',
                        'label' => 'انتخاب عکس',
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                        'label_block' => true,
                    ],
                    [
                        'name' => 'link_slider',
                        'label' => 'لینک مورد نظر خود را وارد کنید.',
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => 'https://weblabs.ir/',
                            'is_external' => true,
                            'nofollow' => false,
                        ],
                        'label_block' => true,
                    ],
                ],
            ]
        );

        $this->add_control(
            'show_nav_slider',
            [
                'label' => 'نمایش پیکان ها',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_bullet_slider',
            [
                'label' => 'نقطه های زیر اسلایدر',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'slide_border_radius',
            [
                'label' => 'گوشه های گرد',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => 'حرکت خودکار',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'definition_list_styles',
            [
                'label'  => __( 'استایل', 'demo-elementor-widget' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'flesh_nav_color_slider',
            [
                'label' => esc_html__('رنگ پیکان های اسلایدر'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#869791',
                'selectors' => [
                    '{{WRAPPER}} .ultra-main-slider .slider .owl-nav button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'background_nav_color_slider',
            [
                'label' => esc_html__('رنگ زمینه پیکان های اسلایدر'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .ultra-main-slider .slider .owl-nav button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nav_color_slider',
            [
                'label' => esc_html__('رنگ زمینه پیکان های اسلایدر برای هاور'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'بصورت پیش فرض از رنگ اصلی سایت خوانده میشود. ',
                'selectors' => [
                    '{{WRAPPER}} .ultra-main-slider .slider .owl-nav button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bullet_color_slider',
            [
                'label' => esc_html__('رنگ بولت فعال اسلایدر (نقطه های زیر اسلایدر)'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => 'بصورت پیش فرض از رنگ اصلی سایت خوانده میشود. ',
                'selectors' => [
                    '{{WRAPPER}} .ultra-main-slider .slider .owl-dots .owl-dot.active span' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'background_bullet_color_slider',
            [
                'label' => esc_html__('رنگ زمینه پیش فرض بولت'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#D6D6D6',
                'selectors' => [
                    '{{WRAPPER}} .ultra-main-slider .slider .owl-dots .owl-dot span' => 'background-color   : {{VALUE}}',
                ]
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (!empty($settings['mainSlider'])) { ?>
            <section class="ultra-main-slider">
                <div class="owl-carousel owl-theme slider">
                    <?php foreach ($settings['mainSlider'] as $item) {
                        $link_url = !empty($item['link_slider']['url']) ? esc_url($item['link_slider']['url']) : '#';
                        $link_target = !empty($item['link_slider']['is_external']) ? 'target="_blank"' : 'target="_self"';
                        $link_nofollow = !empty($item['link_slider']['nofollow']) ? 'rel="nofollow"' : '';

                        if (!empty($item['img_slider']['url'])) { ?>
                            <div class="item">
                                <a href="<?php echo $link_url; ?>" <?php echo $link_target; ?> <?php echo $link_nofollow; ?>>
                                    <img src="<?php echo esc_url($item['img_slider']['url']); ?>">
                                </a>
                            </div>
                        <?php }
                    } ?>
                </div>
            </section>
            <script>
                jQuery(function () {
                    jQuery('.slider').owlCarousel({
                        loop: true,
                        margin: 0,
                        autoplay: <?php if ($settings['autoplay']) {
                            echo "true";
                        } else {
                            echo "false";
                        } ?>,
                        nav:<?php if ($settings['show_nav_slider']) {
                            echo "true";
                        } else {
                            echo "false";
                        } ?>,
                        dots:<?php if ($settings['show_bullet_slider']) {
                            echo "true";
                        } else {
                            echo "false";
                        } ?>,
                        rtl: true,
                        responsive: {
                            0: {
                                items: 1
                            },
                            600: {
                                items: 1
                            },
                            1000: {
                                items: 1
                            }
                        }
                    })
                });

            </script>
            <?php
            if (!$settings['slide_border_radius']) {
                ?>
                <style>
                    .ultra-main-slider .item img {
                        border-radius: 0 !important;
                    }
                </style>
                <?php
            }
        }
    }
}
