<?php

class Elementor_ultra_insta_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_insta';
    }


    public function get_title()
    {
        return 'اینستاگرام اولترا';
    }

    public function get_icon()
    {
        return 'eicon-instagram-post';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['instagram'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'کنترلر محتوای اینستاگرام اولترا' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'alert_tv',
            [
                'type' => \Elementor\Controls_Manager::ALERT,
                'alert_type' => 'warning',
                'heading' => esc_html__( 'لینک دکمه' ),
                'content' => esc_html__( 'لینک دکمه بصورت داینامیک خوانده میشود. https://yoursite.com/insta' ) . ' <a href="https://weblabs.ir/">' . esc_html__( 'برای اطلاعات بیشتر کلیک کنید.' ) . '</a>',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'definition_list_styles',
            [
                'label'  => __( 'استایل', 'demo-elementor-widget' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'author_text_color',
            [
                'label' => esc_html__('رنگ متن نام'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#515070', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .insta-box .top-info .name span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_text_color',
            [
                'label' => esc_html__('رنگ متن سرتیتر'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .insta-box .frame .img-title h3' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();?>
            <section class="insta-box">
                <?php $insta_post = new WP_Query(array(
                    'post_type' => 'insta',
                    'posts_per_page' => 6,
                    'no_found_rows' => true,
                ));
                if ($insta_post-> have_posts()) :
                    while ($insta_post->have_posts()) : $insta_post->the_post(); ?>
                        <a class="frame" href="<?php the_permalink(); ?>">
                            <div class="top-info">
                                <svg id="More Square" width="24" height="24" viewBox="0 0 25 25" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.25 21.7847C5.313 21.7847 3 19.4717 3 12.5347C3 5.59767 5.313 3.28467 12.25 3.28467C19.187 3.28467 21.5 5.59767 21.5 12.5347C21.5 18.0407 20.043 20.6337 15.974 21.4687"
                                          stroke="black" stroke-width="1.5" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <path d="M16.244 12.5345H16.253" stroke="black" stroke-width="2"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12.245 12.5345H12.254" stroke="black" stroke-width="2"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M8.24501 12.5345H8.25401" stroke="black" stroke-width="2"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <div class="name">
                                    <span><?php the_author(); ?></span>
                                    <?php echo get_avatar(get_the_author_meta('ID')); ?>
                                </div>
                            </div>
                            <div class="img-title">
                                <figure>
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail();
                                    } else { ?>
                                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                    <?php } ?>
                                </figure>
                                <div class="ultra-tv-overlay">
                                    <h3><?php the_title(); ?></h3>
                                </div>
                            </div>
                            <div class="buttom-info">
                                <svg id="Bookmark" width="24" height="24" viewBox="0 0 26 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8.82202 9.21741H15.677" stroke="black" stroke-width="1.5"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M19.699 9.461C19.541 3.307 18.194 2.5 12.25 2.5C5.86303 2.5 4.78403 3.432 4.78403 10.929C4.78403 19.322 4.62703 21.5 6.22303 21.5C7.81803 21.5 10.423 17.816 12.25 17.816C14.077 17.816 16.682 21.5 18.277 21.5C19.633 21.5 19.724 19.928 19.72 14.311"
                                          stroke="black" stroke-width="1.5" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                </svg>
                                <div class="intraction">
                                    <svg id="Send" width="24" height="24" viewBox="0 0 26 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M18.5371 15.8421C17.8811 17.7091 17.2141 19.3221 16.6571 20.2871C14.2551 24.4491 11.7771 12.4731 11.7771 12.4731C11.7771 12.4731 -0.19892 9.99508 3.96308 7.59208C7.47508 5.56508 19.5791 2.08008 21.2701 2.98008C21.7631 3.90708 20.9401 7.95908 19.7611 12.0121"
                                              stroke="black" stroke-width="1.5" stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                        <path d="M11.7773 12.4726L17.8073 6.44263" stroke="black" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                    <svg id="Chat" width="24" height="24" viewBox="0 0 26 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M16.1892 12.413H16.1982" stroke="black" stroke-width="2"
                                              stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M12.1802 12.413H12.1892" stroke="black" stroke-width="2"
                                              stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M8.17116 12.413H8.18016" stroke="black" stroke-width="2"
                                              stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M19.3212 4.92704C23.2302 8.83604 23.2222 15.168 19.3212 19.07C16.2662 22.126 11.7402 22.787 8.03617 21.074C7.49017 20.854 3.95117 21.834 3.18317 21.067C2.41617 20.299 3.39617 16.76 3.17617 16.213C1.46317 12.51 2.12417 7.98304 5.18017 4.92704C8.10617 2.00004 12.4032 1.26804 16.0142 2.73204"
                                              stroke="black" stroke-width="1.5" stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                    <svg id="Heart" width="24" height="24" viewBox="0 0 26 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M3.12319 12.4101C2.05019 9.06006 3.30519 4.89506 6.82219 3.76306C8.67219 3.16606 10.9552 3.66406 12.2522 5.45306C13.4752 3.59806 15.8242 3.17006 17.6722 3.76306C21.1882 4.89506 22.4502 9.06006 21.3782 12.4101C19.7082 17.7201 13.8812 20.4861 12.2522 20.4861C11.0412 20.4861 7.53719 18.9911 5.11119 16.0151"
                                              stroke="black" stroke-width="1.5" stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                        <path d="M15.9902 7.52771C17.1972 7.65171 17.9522 8.60871 17.9072 9.94971"
                                              stroke="black" stroke-width="1.5" stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                            </div>
                        </a>
                    <?php endwhile;
                endif;
                wp_reset_postdata(); ?>
            </section>
        <?php
    }
}