<?php

class Elementor_ultra_insta_grid_widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ultra_insta_grid';
    }

    public function get_title()
    {
        return 'اینستاگرام گرید اولترا';
    }

    public function get_icon()
    {
        return 'eicon-instagram-gallery';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['instagram'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('کنترلر محتوای اینستاگرام اولترا'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'title_box',
            [
                'label' => esc_html__('سرتیر'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('اینستاگرام'),
                'placeholder' => esc_html__('اینستاگرام'),
            ]
        );
        
        $this->add_control(
            'title',
            [
                'label' => esc_html__('نام پیج'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('niloofarvafaei.ir'),
                'placeholder' => esc_html__('niloofarvafaei.ir'),
            ]
        );
        
        $this->add_control(
            'image',
            [
                'label' => esc_html__('انتخاب عکس'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $this->add_control(
            'title_insta',
            [
                'label' => esc_html__('سرتیر باکس'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('همراه ما در اینستاگرام'),
                'placeholder' => esc_html__('همراه ما در اینستاگرام'),
            ]
        );
        
        $this->add_control(
            'title_link',
            [
                'label' => esc_html__('متن دکمه'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده همه'),
                'placeholder' => esc_html__('مشاهده همه'),
            ]
        );
        
        $this->add_control(
            'link_insta',
            [
                'label' => esc_html__('لینک'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'post_count',
            [
                'label' => esc_html__('تعداد پست‌ها'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
    'style_section_header',
    [
        'label' => esc_html__('استایل هدر اینستاگرام', 'textdomain'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'insta_icon_color',
    [
        'label' => esc_html__('رنگ آیکون اینستاگرام'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .insta-head .title i' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'title_box_color',
    [
        'label' => esc_html__('رنگ سرتیتر'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .insta-head .title span' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'profile_name_color',
    [
        'label' => esc_html__('رنگ نام پیج'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .insta-head .profile span' => 'color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();


$this->start_controls_section(
    'style_section_fixed_box',
    [
        'label' => esc_html__('استایل باکس ثابت اینستاگرام', 'textdomain'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'fixed_title_color',
    [
        'label' => esc_html__('رنگ سرتیتر باکس'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .insta-boxes .fixed-side span' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'fixed_button_text_color',
    [
        'label' => esc_html__('رنگ متن دکمه'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .insta-boxes .fixed-side a' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'fixed_button_bg_color',
    [
        'label' => esc_html__('رنگ زمینه دکمه'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .insta-boxes .fixed-side a' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'fixed_button_border_color',
    [
        'label' => esc_html__('رنگ بردر دکمه'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .insta-boxes .fixed-side a' => 'border-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'fixed_button_hover_bg_color',
    [
        'label' => esc_html__('رنگ زمینه دکمه (هاور)'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .insta-boxes .fixed-side a:hover' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="insta-ultra">
            <div class="insta-head">
                <div class="title">
                    <i class="fa-brands fa-instagram"></i>
                    <span><?php echo esc_html($settings['title_box']); ?></span>
                </div>
                <div class="profile">
                    <span><?php echo esc_html($settings['title']); ?></span>
                    <img src="<?php echo esc_url($settings['image']['url']); ?>"/>
                </div>
            </div>
            <div class="insta-boxes">
                <div class="fixed-side">
                    <i class="fa-brands fa-instagram"></i>
                    <span><?php echo esc_html($settings['title_insta']); ?></span>
                    <?php if (!empty($settings['link_insta']['url'])) {
                        $this->add_link_attributes('link_insta', $settings['link_insta']);
                    }
                    ?>
                    <a <?php $this->print_render_attribute_string('link_insta'); ?>><?php echo esc_html($settings['title_link']); ?></a>
                </div>
                <?php 
                $insta_post = new WP_Query([
                    'post_type' => 'insta',
                    'posts_per_page' => (int)$settings['post_count'],
                    'no_found_rows' => true,
                ]);
                if ($insta_post->have_posts()) :
                    while ($insta_post->have_posts()) : $insta_post->the_post(); ?>
                        <a href="<?php the_permalink(); ?>">
                            <figure>
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail();
                                } else { ?>
                                    <img src="<?= esc_url(get_template_directory_uri() . '/assets/image/empty.webp'); ?>"/>
                                <?php } ?>
                            </figure>
                        </a>
                    <?php endwhile;
                endif;
                wp_reset_postdata(); ?>
            </div>
        </section>
        <?php
    }
}