<?php
class Elementor_ultra_commentSlider_widget extends \Elementor\Widget_Base
{
    public function get_name() {
        return 'ultra_commentSlider';
    }

    public function get_title() {
        return 'نظرات مشتریان (اسلایدری)';
    }

    public function get_icon() {
        return 'eicon-testimonial-carousel';
    }

    public function get_categories() {
        return ['ultra'];
    }

    public function get_keywords() {
        return ['testimonial', 'comments', 'feedback'];
    }

    protected function register_controls()
    {
        // تصویر سمت راست
        $this->start_controls_section('right_image_section', [
            'label' => __('تصویر ماسک‌دار سمت راست', 'textdomain'),
        ]);

        $this->add_control('right_image', [
            'label' => __('انتخاب تصویر', 'textdomain'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
        ]);

        $this->end_controls_section();

        // متن سمت چپ و ریپیتر نظرات
        $this->start_controls_section('testimonial_section', [
            'label' => __('محتوای نظرات', 'textdomain'),
        ]);

        $this->add_control('title', [
            'label' => __('تیتر اصلی', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'نظرات مشتریان قالب اولترا مارکت',
        ]);

        $repeater = new \Elementor\Repeater();

        $repeater->add_control('comment_text', [
            'label' => __('متن نظر', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => 'متن نظر مشتری...',
        ]);

        $repeater->add_control('name', [
            'label' => __('نام مشتری', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'اولترا مارکت',
        ]);

        $repeater->add_control('rank', [
            'label' => __('زیرعنوان مشتری', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'مدیر بخش فنی',
        ]);

        $repeater->add_control('avatar', [
            'label' => __('تصویر مشتری', 'textdomain'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
        ]);

        $this->add_control('comments_list', [
            'label' => __('لیست نظرات', 'textdomain'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);

        $this->end_controls_section();

        $this->start_controls_section('slider_section', [
            'label' => __('تنظیمات اسلایدر', 'textdomain'),
        ]);
        $this->add_control(
            'show_nav_slider',
            [
                'label' => 'نمایش پیکان ها',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_bullet_slider',
            [
                'label' => 'نقطه های زیر اسلایدر',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => 'حرکت خودکار',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'textdomain'),
                'label_off' => esc_html__('غیرفعال', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

        // استایل‌ها
        $this->start_controls_section('style_section', [
            'label' => __('استایل‌ها', 'textdomain'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('shape_color', [
            'label' => __('رنگ شکل ماسک', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra_img-shape svg path' => 'stroke: {{VALUE}};',
            ],
        ]);

        $this->add_control('quote_icon_color', [
            'label' => __('رنگ آیکون نقل‌قول', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-comment-widget_slider svg path' => 'stroke: {{VALUE}};',
            ],
        ]);

        $this->add_control('title_color', [
            'label' => __('رنگ تیتر', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-comment-widget_slider h3' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_control('text_color', [
            'label' => __('رنگ متن نظر', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-comment-widget_slider p' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_control('name_color', [
            'label' => __('رنگ نام مشتری', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-comment_body_author .name' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_control('rank_color', [
            'label' => __('رنگ زیرعنوان مشتری', 'textdomain'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-comment_body_author .rank' => 'color: {{VALUE}};',
            ],
        ]);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="ultra-comment-widget">
            <div class="ultra-comment_img">
                <div class="ultra-img-mask">
                    <img src="<?php echo esc_url($settings['right_image']['url']); ?>" alt="img">
                </div>
                <div class="ultra_img-shape">
                    <div class="shape-1">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 565 454" fill="none"
                             x="0px" y="0px" preserveAspectRatio="none"
                             data-inject-url="https://ultra-pet.weblabs.ir/wp-content/uploads/2025/04/testimonial_mask_img.svg"
                             class="injectable">
                            <path class="animation-dashed" fill-rule="evenodd" clip-rule="evenodd"
                                  d="M559.857 170.275C549.245 128.158 514.653 95.3122 476.717 67.7301C440.405 41.3292 395.66 26.4426 348.116 16.3268C297.228 5.49948 244.47 -6.2769 192.068 7.16578C137.19 21.2435 85.074 50.9149 53.4485 91.9172C22.7442 131.725 30.7964 179.924 23.5883 225.599C16.1603 272.667 -12.2223 322.712 10.492 364.115C33.3898 405.854 90.0185 424.99 141.714 440.92C189.396 455.612 241.161 453.589 293.46 451.309C349.395 448.869 410.615 456.23 457.22 427.161C503.984 397.993 517.137 346.023 535.352 300.435C552.553 257.383 570.591 212.877 559.857 170.275Z"
                                  stroke="currentcolor" stroke-width="2"
                                  stroke-dasharray="12 12"></path>
                        </svg>
                    </div>
                </div>
            </div>
            <div class="ultra-comment_body">
                <div class="ultra-comment-widget_slider owl-carousel owl-theme">
                    <?php foreach ($settings['comments_list'] as $item): ?>
                        <div class="item">
                            <svg xmlns="http://www.w3.org/2000/svg" width="59" height="44"
                                 viewBox="0 0 59 44" fill="none"
                                 data-inject-url="https://petpal.torbateno.ir/assets/img/icon/quote.svg"
                                 class="injectable">
                                <path d="M13.4098 18.5471H13.4099C15.7203 18.5469 17.9834 19.2004 19.9376 20.4319C21.8917 21.6634 23.4569 23.4225 24.4523 25.5056C25.4477 27.5887 25.8325 29.9109 25.5623 32.2034C25.2922 34.4959 24.378 36.6652 22.9256 38.4604C21.4732 40.2556 19.5417 41.6032 17.3547 42.3474C15.1677 43.0916 12.8145 43.2018 10.5674 42.6653C8.32025 42.1288 6.27113 40.9676 4.657 39.316C3.04287 37.6644 1.9297 35.59 1.44614 33.3328L1.23338 32.3397L1.22723 32.3411C1.18993 32.0514 1.1541 31.7315 1.13033 31.4085L1.12946 31.3968L1.12833 31.3851C1.01009 30.1698 0.951635 28.4654 1.04932 26.3993C1.167 24.3474 1.47023 21.9586 2.14395 19.4508C2.50055 18.1973 2.93406 16.916 3.46825 15.6689C3.53126 15.536 3.59338 15.4043 3.65494 15.2737C4.20987 14.0971 4.71965 13.0162 5.43343 12.023L5.4594 11.9868L5.48206 11.9485C6.16941 10.7866 7.06724 9.74579 8.03 8.70207L8.05613 8.67374L8.08 8.64349C8.45899 8.16318 8.91835 7.74276 9.43515 7.31588C9.60393 7.17646 9.78968 7.0281 9.98173 6.8747C10.3335 6.59373 10.7064 6.29588 11.0348 6.00527C11.4843 5.63211 11.9752 5.31875 12.5005 5.01038C12.6673 4.91247 12.8454 4.81083 13.028 4.7066C13.3944 4.49743 13.779 4.27788 14.1272 4.0574L14.137 4.0512L14.1466 4.04479C14.567 3.76471 15.0171 3.55643 15.5037 3.36067C15.658 3.29859 15.8303 3.23263 16.0098 3.16395C16.3384 3.0382 16.6908 2.90333 17.0001 2.7664C17.2706 2.66121 17.5168 2.56113 17.7449 2.46846C18.3944 2.20449 18.8962 2.00056 19.3913 1.90927L19.4233 1.90337L19.4549 1.89538C19.9086 1.78075 20.3077 1.68266 20.677 1.59189C20.9566 1.52316 21.2191 1.45863 21.4754 1.39429L22.2631 1.20442L23.2395 5.1032L22.6441 5.35048L22.6412 5.3517L21.0919 5.98936C20.6876 6.125 20.3207 6.32033 19.9975 6.50871C19.8466 6.59669 19.695 6.68937 19.5511 6.77729C19.5352 6.78703 19.5193 6.79671 19.5036 6.80632C19.3422 6.90492 19.1877 6.99869 19.0305 7.08875L19.0012 7.10551L18.9732 7.12422C18.7831 7.25084 18.5962 7.35361 18.3692 7.47841C18.2498 7.54407 18.1193 7.61583 17.9714 7.70036C17.5867 7.92024 17.1409 8.19914 16.7381 8.59284C16.5328 8.7818 16.3157 8.95078 16.0604 9.14949C15.9694 9.22033 15.8736 9.29495 15.7717 9.3756C15.4046 9.6661 14.9878 10.0146 14.6232 10.4534L14.6116 10.4673L14.6005 10.4817C14.425 10.7091 14.2385 10.9061 14.0152 11.1418C13.9251 11.237 13.829 11.3386 13.7252 11.4509C13.4031 11.7997 13.0393 12.2233 12.7607 12.7523C12.7508 12.7673 12.7409 12.7823 12.7309 12.7975C12.2478 13.5306 11.6993 14.3628 11.3316 15.3275C10.9619 16.0337 10.7353 16.7951 10.5433 17.4404L10.5395 17.4529L10.0931 18.953L11.6419 18.7277C11.6843 18.7216 11.7262 18.7154 11.7678 18.7094C12.3637 18.6223 12.8788 18.5471 13.4098 18.5471ZM45.7635 18.5471H45.7636C48.0739 18.5469 50.3371 19.2004 52.2913 20.4319C54.2454 21.6634 55.8106 23.4225 56.806 25.5056C57.8014 27.5887 58.1862 29.9109 57.916 32.2034C57.6459 34.4959 56.7317 36.6652 55.2793 38.4604C53.8269 40.2556 51.8954 41.6032 49.7084 42.3474C47.5214 43.0916 45.1682 43.2018 42.9211 42.6653C40.6739 42.1288 38.6248 40.9676 37.0107 39.316C35.3966 37.6644 34.2834 35.59 33.7998 33.3328L33.5871 32.3397L33.5809 32.3411C33.5436 32.0514 33.5078 31.7315 33.484 31.4085L33.4832 31.3968L33.482 31.3851C33.3638 30.1698 33.3053 28.4654 33.403 26.3995C33.5207 24.3474 33.8239 21.9586 34.4977 19.4506C34.8543 18.1972 35.2878 16.9159 35.8219 15.6689C35.8849 15.536 35.9471 15.4043 36.0086 15.2738C36.5635 14.0971 37.0733 13.0162 37.7871 12.023L37.8131 11.9868L37.8358 11.9485C38.5231 10.7866 39.4209 9.74579 40.3837 8.70207L40.4094 8.67421L40.4329 8.64449C40.812 8.16532 41.2715 7.74544 41.7885 7.31871C41.9566 7.17997 42.1413 7.03251 42.3322 6.88008C42.6849 6.5985 43.0588 6.29998 43.3885 6.00821C43.838 5.63505 44.3289 5.32169 44.8542 5.01332C45.021 4.91541 45.1991 4.81377 45.3817 4.70955C45.7481 4.50037 46.1327 4.28082 46.4809 4.06034L46.4915 4.0536L46.502 4.0466C46.9213 3.76605 47.371 3.55812 47.8582 3.36223C48.0085 3.30182 48.1751 3.23799 48.3486 3.17155C48.6816 3.04403 49.0397 2.90686 49.3555 2.76574C49.6253 2.66078 49.871 2.56094 50.0986 2.46845C50.7481 2.20449 51.2499 2.00056 51.745 1.90927L51.777 1.90337L51.8086 1.89538C52.2623 1.78074 52.6614 1.68265 53.0307 1.59187C53.3103 1.52315 53.5729 1.45862 53.8291 1.39429C53.8306 1.39391 53.8322 1.39352 53.8337 1.39313L54.6168 1.20442L55.5932 5.1032L54.9978 5.35048L54.9949 5.3517L53.4456 5.98936C53.0413 6.125 52.6744 6.32033 52.3512 6.50871C52.2003 6.59672 52.0485 6.68944 51.9046 6.77739L51.8573 6.80632C51.6959 6.90493 51.5414 6.99869 51.3842 7.08875L51.3549 7.10551L51.3269 7.12422C51.1368 7.25084 50.9499 7.35361 50.7229 7.4784C50.6035 7.54406 50.473 7.61582 50.3251 7.70036C49.9404 7.92023 49.4947 8.19912 49.0918 8.59281C48.8865 8.78179 48.6694 8.95078 48.4141 9.14952C48.3231 9.22035 48.2273 9.29496 48.1254 9.3756C47.7583 9.6661 47.3415 10.0146 46.9769 10.4534L46.9653 10.4673L46.9542 10.4817C46.7787 10.7091 46.5922 10.9061 46.3689 11.1418C46.2788 11.237 46.1827 11.3386 46.0789 11.4509C45.7568 11.7997 45.393 12.2233 45.1144 12.7522C45.1045 12.7673 45.0946 12.7824 45.0846 12.7975C44.6014 13.5306 44.053 14.3628 43.6853 15.3275C43.3156 16.0337 43.089 16.7951 42.897 17.4404L42.8932 17.4529L42.4468 18.953L43.9956 18.7277C44.038 18.7216 44.0799 18.7154 44.1215 18.7094C44.7174 18.6223 45.2325 18.5471 45.7635 18.5471Z"
                                      stroke="currentcolor" stroke-width="2"></path>
                            </svg>
                            <h3><?php echo esc_html($settings['title']); ?></h3>
                            <p><?php echo esc_html($item['comment_text']); ?></p>
                            <div class="ultra-comment_body_author">
                                <img src="<?php echo esc_url($item['avatar']['url']); ?>" alt="avatar">
                                <div class="ultra-comment_body_author_info">
                                    <span class="name"><?php echo esc_html($item['name']); ?></span>
                                    <span class="rank"><?php echo esc_html($item['rank']); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <script>
            jQuery(document).ready(function($) {
                $('.ultra-comment-widget_slider').owlCarousel({
                    loop: true,
                    margin: 10,
                   nav: <?php echo $settings['show_nav_slider'] === 'yes' ? 'true' : 'false'; ?>,
                    dots: <?php echo $settings['show_bullet_slider'] === 'yes' ? 'true' : 'false'; ?>,
                   autoplay: <?php echo $settings['autoplay'] === 'yes' ? 'true' : 'false'; ?>,
                    rtl: true,
                    items: 1
                });
            });
        </script>
        <?php
    }
}