<?php

class Elementor_ultra_box_offer_product extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ultra_box_offer_product';
    }

    public function get_title()
    {
        return 'باکس تخفیف محصول';
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['product', 'box'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('المان محصولات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'post_number',
            [
                'label' => 'محصول',
                'description' => 'شناسه های محصول را وارد کنید.',
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '25',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => 'عنوان',
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => 'حراج هفته',
                'default' => 'حراج هفته',
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__( 'توضیحات' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 3,
                'default' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
                'placeholder' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_icon',
            [
                'label' => esc_html__('آیکون', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'icon1',
            [
                'label' => esc_html__('آیکون'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'title1',
            [
                'label' => esc_html__( 'عنوان' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'کالای اصل بخرید' ),
                'placeholder' => esc_html__( 'کالای اصل بخرید' ),
            ]
        );
        $this->add_control(
            'description1',
            [
                'label' => esc_html__( 'توضیحات' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
                'placeholder' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
            ]
        );
        $this->add_control(
            'hr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'icon2',
            [
                'label' => esc_html__('آیکون'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'title2',
            [
                'label' => esc_html__( 'عنوان' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'کالای اصل بخرید' ),
                'placeholder' => esc_html__( 'کالای اصل بخرید' ),
            ]
        );
        $this->add_control(
            'description2',
            [
                'label' => esc_html__( 'توضیحات' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
                'placeholder' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
            ]
        );
        $this->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'icon3',
            [
                'label' => esc_html__('آیکون'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'title3',
            [
                'label' => esc_html__( 'عنوان' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'کالای اصل بخرید' ),
                'placeholder' => esc_html__( 'کالای اصل بخرید' ),
            ]
        );
        $this->add_control(
            'description3',
            [
                'label' => esc_html__( 'توضیحات' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
                'placeholder' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
            ]
        );
        $this->add_control(
            'hr3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'icon4',
            [
                'label' => esc_html__('آیکون'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'title4',
            [
                'label' => esc_html__( 'عنوان' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'کالای اصل بخرید' ),
                'placeholder' => esc_html__( 'کالای اصل بخرید' ),
            ]
        );
        $this->add_control(
            'description4',
            [
                'label' => esc_html__( 'توضیحات' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
                'placeholder' => esc_html__( 'لورم اپیسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ' ),
            ]
        );

        $this->end_controls_section();
        /**
         * Start Style
         */
        $this->start_controls_section(
            'box_styles',
            [
                'label' => __('استایل باکس', 'demo-elementor-widget'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title-sale',
            [
                'label' => esc_html__('رنگ متن سرتیتر'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .sale-widget-ultra .title-sale' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr_article',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'attrs-sale-i',
            [
                'label' => esc_html__('رنگ آیکون'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .sale-widget-ultra .sale-content .attrs-sale .attr i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'attrs-sale-i-bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیکون'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#B7DCE2', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .sale-widget-ultra .sale-content .attrs-sale .attr i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'attr_h5',
            [
                'label' => esc_html__('رنگ متن'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .sale-widget-ultra .sale-content .attrs-sale .attr .txt h5' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'attr_p',
            [
                'label' => esc_html__('رنگ توضیحات کوتاه'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .sale-widget-ultra .sale-content .attrs-sale .attr .txt p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $post_in = explode(',', $settings['post_number']);
        ?>
        <section class="sale-widget-ultra">
            <span class="title-sale"><?php echo $settings['title'];?></span>
            <div class="sale-content">
                <div class="attrs-sale">
                    <div class="attr">
                        <i class="<?php echo $settings['icon1']['value']?>"></i>
                        <div class="txt">
                            <h5><?php echo $settings['title1'];?></h5>
                            <p><?php echo $settings['description1'];?></p>
                        </div>
                    </div>
                    <div class="attr">
                        <i class="<?php echo $settings['icon2']['value']?>"></i>
                        <div class="txt">
                            <h5><?php echo $settings['title2'];?></h5>
                            <p><?php echo $settings['description2'];?></p>
                        </div>
                    </div>
                </div>

                <?php
                global $product;
                $choosen_product = new WP_Query(array(
                    'post_type' => 'product',
                    'posts_per_page' => 1,
                    'no_found_rows' => true,
                    'post__in' => $post_in,
                ));
                if ($choosen_product->have_posts()) {
                    while ($choosen_product->have_posts()) : $choosen_product->the_post(); ?>
                        <div class="image-sec">
                            <a href="<?php the_permalink(); ?>">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail();
                                } else { ?>
                                    <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp' ?>">
                                <?php } ?>
                            </a>
                            <span><?php echo $settings['description']; ?></span>
                        </div>
                    <?php
                    endwhile;
                }
                wp_reset_postdata();
                ?>

                <div class="attrs-sale">
                    <div class="attr">
                        <i class="<?php echo $settings['icon3']['value']?>"></i>
                        <div class="txt">
                            <h5><?php echo $settings['title3'];?></h5>
                            <p><?php echo $settings['description3'];?></p>
                        </div>
                    </div>

                    <div class="attr">
                        <i class="<?php echo $settings['icon4']['value']?>"></i>
                        <div class="txt">
                            <h5><?php echo $settings['title4'];?></h5>
                            <p><?php echo $settings['description4'];?></p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}