<?php

class Elementor_ultra_banner_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_banner';
    }


    public function get_title()
    {
        return 'بنر اولترا';
    }

    public function get_icon()
    {
        return 'eicon-banner';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['banner', 'image'];
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'list_banner',
            [
                'label' => 'بنرهای اولترا مارکت',
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'img_banner',
                        'label' => 'انتخاب عکس',
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                        'label_block' => true,
                    ],
                    [
                        'name' => 'link_banner',
                        'label' => 'لینک مورد نظر خود را وارد کنید.',
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => [ 'url', 'is_external', 'nofollow' ],
                        'default' => [
                            'url' => 'https://weblabs.ir/',
                            'is_external' => true,
                            'nofollow' => false,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'default' => [
                    [
                        'img_banner' => 'بنر',
                        'link_banner' => 'لینک بنر بنر',
                    ],
                    [
                        'img_banner' => 'بنر',
                        'link_banner' => 'لینک بنر بنر',
                    ],
                    [
                        'img_banner' => 'بنر',
                        'link_banner' => 'لینک بنر بنر',
                    ],
                ],
                'title_field' => 'بنر',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display(); // دریافت تنظیمات برای نمایش

        // بررسی اینکه آیا آیتم‌ها وجود دارند
        if (!empty($settings['list_banner'])) { ?>
            <section class="banner"> <!-- بخش بنر -->
                <?php foreach ($settings['list_banner'] as $item) {
                    // دریافت لینک و تنظیمات آن
                    $link_url = esc_url($item['link_banner']['url']);
                    $link_target = !empty($item['link_banner']['is_external']) ? 'target="_blank"' : 'target="_self"';
                    $link_nofollow = !empty($item['link_banner']['nofollow']) ? 'rel="nofollow"' : '';

                    // بررسی اینکه آیا تصویر وجود دارد
                    if (!empty($item['img_banner']['url'])) { ?>
                        <a href="<?php echo $link_url; ?>" <?php echo $link_target; ?> <?php echo $link_nofollow; ?>>
                            <img src="<?php echo esc_url($item['img_banner']['url']); ?>" alt="">
                        </a>
                    <?php }
                } ?>
            </section>
        <?php }
    }


}