<?php

class Elementor_ultra_article_slider_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_article_slider';
    }


    public function get_title()
    {
        return 'اسلایدر مقالات';
    }

    public function get_icon()
    {
        return 'eicon-post-slider';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['article', 'post', 'blog'];
    }

    function get_cats()
    {
        $cats = ['all' => 'همه'];
        $categories = get_categories();
        foreach ($categories as $category) {
            $cats[$category->cat_ID] = $category->name;
        }
        return $cats;
    }

    /**
     *  Function Get Dynamic Category Post wordPress
     */
    function get_post_cat()
    {
        $terms = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options[$term->term_id] = $term->name;
            }
            return $options;
        }
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('اسلایدر مقالات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'مقالات' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'مقالات' ),
                'placeholder' => esc_html__( 'مقالات' ),
            ]
        );
        $this->add_control(
            'title_link',
            [
                'label' => esc_html__( 'مشاهده همه' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'مشاهده همه' ),
                'placeholder' => esc_html__( 'مشاهده همه' ),
            ]
        );
        $this->add_control(
            'link',
            [
                'label' => esc_html__( 'لینک' ),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'number_post_per_page_grid',
            [
                'label' => esc_html__('تعداد مقالات را وارد کنید'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 8,
                'step' => 1,
                'default' => 4,
            ]
        );
        $this->add_control(
            'select_category_article_grid_hover',
            [
                'label' => esc_html__('دسته بندی راانتخاب کنید.'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => $this->get_post_cat(),
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
    'style_section_title',
    [
        'label' => esc_html__('استایل سرتیتر و دکمه مشاهده همه', 'textdomain'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'title_color',
    [
        'label' => esc_html__('رنگ عنوان سرتیتر'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-title-ultra h2' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'more_button_color',
    [
        'label' => esc_html__('رنگ دکمه مشاهده همه'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-title-ultra a' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'more_button_hover_color',
    [
        'label' => esc_html__('رنگ هاور دکمه مشاهده همه'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-title-ultra a:hover' => 'color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'style_section_category',
    [
        'label' => esc_html__('استایل دسته‌بندی مقاله', 'textdomain'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'category_text_color',
    [
        'label' => esc_html__('رنگ متن دسته'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-ultra .blog-slider .item .image-sec .cate-blog' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'category_bg_color',
    [
        'label' => esc_html__('رنگ زمینه دسته'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-ultra .blog-slider .item .image-sec .cate-blog' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'style_section_date',
    [
        'label' => esc_html__('استایل تاریخ مقاله', 'textdomain'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'date_text_color',
    [
        'label' => esc_html__('رنگ متن تاریخ'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-ultra .blog-slider .item .image-sec .date-blog' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'date_bg_color',
    [
        'label' => esc_html__('رنگ زمینه تاریخ'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-ultra .blog-slider .item .image-sec .date-blog' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'style_section_content',
    [
        'label' => esc_html__('استایل محتوای مقاله', 'textdomain'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'post_title_color',
    [
        'label' => esc_html__('رنگ تیتر مقاله'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-content h3' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'excerpt_color',
    [
        'label' => esc_html__('رنگ توضیحات کوتاه'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-content p' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'button_text_color',
    [
        'label' => esc_html__('رنگ متن دکمه'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-ultra .blog-slider .item .blog-content a' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'button_bg_color',
    [
        'label' => esc_html__('رنگ زمینه دکمه'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-ultra .blog-slider .item .blog-content a' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'button_hover_color',
    [
        'label' => esc_html__('رنگ هاور دکمه'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-ultra .blog-slider .item .blog-content a:hover' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'button_bg_hover_color',
    [
        'label' => esc_html__('رنگ زمینه دکمه (هاور)'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .blog-ultra .blog-slider .item .blog-content a:hover' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'style_section_blog_info_gradient',
    [
        'label' => esc_html__('استایل گرادینت اطلاعات مقاله', 'textdomain'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'blog_info_primary_color',
    [
        'label' => esc_html__('رنگ اول گرادینت'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#ff8036',
        'selectors' => [
            '{{WRAPPER}}' => '--color-1: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'blog_info_accent_color',
    [
        'label' => esc_html__('رنگ دوم گرادینت'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#ff5733',
        'selectors' => [
            '{{WRAPPER}}' => '--color-2: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); // دریافت تنظیمات برای نمایش
        ?>
        <section class="blog-ultra">
            <div class="blog-title-ultra">
                <h2><?php echo $settings['title']; ?></h2>
                <?php if ( ! empty( $settings['link']['url'] ) ) {
                    $this->add_link_attributes( 'link', $settings['link'] );
                }
                ?>
                <a <?php $this->print_render_attribute_string( 'link' ); ?>>
                    <span><?php echo $settings['title_link']; ?></span>
                    <i class="fa-solid fa-angles-left"></i>

                </a>
            </div>

            <div class="owl-carousel owl-theme blog-slider ">
                <?php $post_query = new WP_Query(array(
                    'post_type' => 'post',
                    'posts_per_page' => $settings['number_post_per_page_grid'],
                    'cat' => $settings['select_category_article_grid_hover'],
                    'no_found_rows' => true,
                ));
                if ($post_query->have_posts()) :
                    while ($post_query->have_posts()) : $post_query->the_post(); ?>
                        <div class="item">
                            <div class="image-sec">
                                <a href="<?php the_permalink(); ?>">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail();
                                    } else { ?>
                                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                    <?php } ?>
                                </a>
                                <?php
                                $categories = get_the_category();
                                if (!empty($categories)) {
                                    foreach ($categories as $category) {
                                        echo '<a href="' . esc_url(get_category_link($category->term_id)) . '" class="cate-blog">' . esc_html($category->name) . '</a> ';
                                    }
                                }
                                ?>

                                <span class="date-blog">
                                    <span><?php echo get_the_date('j'); ?></span>
								  <span><?php echo get_the_date('F'); ?></span>
                                </span>
                                <div class="blog-info">
                                    <?php // تعداد بازدید پست
                                    // محاسبه زمان مطالعه
                                    $word_count = str_word_count(strip_tags(get_the_content()));
                                    $reading_time = ceil($word_count / 200); // فرض می‌شود 200 کلمه در دقیقه
                                    $reading_time = max($reading_time, 1); // حداقل زمان مطالعه را ۱ دقیقه قرار می‌دهد
                                    ?>
                                    <span>
                                        <i class="fa-solid fa-comments"></i>
                                        <span><?php
                                            // دریافت تعداد دیدگاه‌های پست
                                            $comments_number = get_comments_number();

                                            if ($comments_number > 0) {
                                                echo esc_html($comments_number) . ' دیدگاه';
                                            } else {
                                                echo 'بدون دیدگاه';
                                            }
                                            ?></span>
                                    </span>
                                    <span>
                                        <i class="fa-regular fa-clock"></i>
                                        <span><?php echo esc_html($reading_time); ?></span>
                                        <span>دقیقه مطالعه</span>
                                    </span>
                                </div>
                            </div>

                            <div class="blog-content">
                                <h3><?php the_title(); ?></h3>
                                <?php the_excerpt(); ?>
                                <a href="<?php the_permalink(); ?>">رفتن به مقاله</a>
                            </div>
                        </div>
                    <?php
                    endwhile;
                endif;
                wp_reset_postdata(); ?>
            </div>
        </section>
        <style>
.blog-ultra .blog-slider .item .image-sec .blog-info {
    position: absolute;
    right: 1rem;
    bottom: 1rem;
    inset: 0;
    z-index: 1;
    opacity: 0;
    transition: opacity .3s ease;
    display: flex;
    gap: 1rem;
    align-items: center;
    color: #fff;

    background-image:
        linear-gradient(-10deg, var(--color-1, #ff8036) 10%, rgba(255, 128, 54, 0) 50%),
        linear-gradient(30deg, var(--color-2, #ff5733) 0, rgba(255, 128, 54, 0) 50%);
}

.blog-ultra .blog-slider .item .image-sec:hover .blog-info {
    opacity: 1;
}
</style>

        <script>
    jQuery(function ($) {
        var $carousel = $('.blog-slider');
        var container = $('.blog-ultra')[0]; // کانتینر والد

        // تابع محاسبه تعداد آیتم‌ها بر اساس عرض کانتینر
        function calculateItems(width) {
            if (width > 1500) return 4.5;
            if (width > 1300) return 4;
            if (width > 1000) return 3.5;
            if (width > 800) return 2.9;
            if (width > 600) return 1.5;
            if (width > 400) return 1.2;
            return 1;
        }

        // مقدار اولیه
        let currentItems = calculateItems(container.clientWidth);

        var owl = $carousel.owlCarousel({
            center: false,
            loop: true,
            dots: false,
            nav: false,
            margin: 15,
            rtl: true,
            items: currentItems
        });

        // نظارت بر تغییر سایز کانتینر
        const observer = new ResizeObserver(entries => {
            for (let entry of entries) {
                const newWidth = entry.contentRect.width;
                const newItems = calculateItems(newWidth);

                if (newItems !== currentItems) {
                    currentItems = newItems;
                    owl.trigger('refresh.owl.carousel').data('owl.carousel').options.items = newItems;
                }
            }
        });

        observer.observe(container);
    });
</script>

        <?php
    }
}