<?php

class Elementor_ultra_article_list_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_article_grid_title';
    }


    public function get_title()
    {
        return 'مقالات مدل لیست';
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['article', 'post', 'blog'];
    }

    function get_cats()
    {
        $cats = ['all' => 'همه'];
        $categories = get_categories();
        foreach ($categories as $category) {
            $cats[$category->cat_ID] = $category->name;
        }
        return $cats;
    }

    /**
     *  Function Get Dynamic Category Post wordPress
     */
    function get_post_cat()
    {
        $terms = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options[$term->term_id] = $term->name;
            }
            return $options;
        }
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('کنترلر المان', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title_list_article',
            [
                'label' => esc_html__('سرتیتر مد نظر خود را وارد کنید.'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مقالات آموزشی'),
                'placeholder' => esc_html__('مقالات آموزشی'),
            ]
        );
        $this->add_control(
            'icon_before_title',
            [
                'label' => esc_html__('آیکون'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-blog',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'blog',
                        'blogger',
                        'video-slash',
                    ],
                ],
            ]
        );
        $this->add_control(
            'number_post_per_page_list',
            [
                'label' => esc_html__('تعداد مقالات را وارد کنید'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 10,
                'step' => 1,
                'default' => 4,
            ]
        );
        $this->add_control(
            'select_category_article_list',
            [
                'label' => esc_html__('دسته بندی راانتخاب کنید.'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => $this->get_post_cat(),
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'content_section_blog_list',
            [
                'label' => esc_html__('کنترلر پست', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'excerpt_length',
            [
                'label' => esc_html__('تعداد کاراکترهای خلاصه'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 10,
                'max' => 200,
                'step' => 5,
                'default' => 100,
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__( 'نمایش تاریخ انتشار' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'نمایش' ),
                'label_off' => esc_html__( 'مخفی' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_comment',
            [
                'label' => esc_html__( 'نمایش کامنت ها' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'نمایش' ),
                'label_off' => esc_html__( 'مخفی' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'definition_list_styles',
            [
                'label' => __('استایل سرتیتر', 'demo-elementor-widget'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_text_color',
            [
                'label' => esc_html__('رنگ متن'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog-title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکون'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF8E6E', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog-title i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'blog_list_styles',
            [
                'label' => __('استایل پست ها', 'demo-elementor-widget'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color_title_blog_list',
            [
                'label' => esc_html__('رنگ سرتیتر پست ها'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#515070', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog-list .article .content .title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_excerpt_blog_list',
            [
                'label' => esc_html__('رنگ توضیحات کوتاه پست ها'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#525474', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog-list .article .content .excerpt' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_category_blog_list',
            [
                'label' => esc_html__('رنگ دسته بندی پست ها:'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog-list .article .content .meta .right .category a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bg-color_category_blog_list',
            [
                'label' => esc_html__('رنگ  پس زمینه دسته بندی پست ها:'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF8E6E', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog-list .article .content .meta .right .category a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Custom Excerpt
     */
    public function custom_excerpt($length)
    {
        $excerpt = get_the_excerpt();
        if (strlen($excerpt) > $length) {
            $excerpt = mb_substr($excerpt, 0, $length) . '...';
        }
        return $excerpt;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); // دریافت تنظیمات برای نمایش
        ?>
        <div class="blog-title shadow">
            <?php if (!empty($settings['icon_before_title']['value'])) {
                echo '<i class="' . esc_attr($settings['icon_before_title']['value']) . '"></i>';
            } ?>
            <h3><?php echo esc_html($settings['title_list_article']); ?></h3>
        </div>
        <div class="blog-list">
            <?php $post_query = new WP_Query(array(
                'post_type' => 'post',
                'posts_per_page' => $settings['number_post_per_page_list'],
                'cat' => $settings['select_category_article_list'],
                'no_found_rows' => true,
            ));
            if ($post_query->have_posts()) :
                while ($post_query->have_posts()) : $post_query->the_post(); ?>
                    <div class="article">
                        <a href="<?php the_permalink(); ?>">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail();
                            } else { ?>
                                <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                            <?php } ?>
                        </a>
                        <div class="content">
                            <h3 class="title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h3>
                            <div class="excerpt">
                                <?php echo $this->custom_excerpt($settings['excerpt_length']); ?>
                            </div>
                            <div class="meta">
                                <div class="right">
                                    <div class="category">
                                        <?php the_category(' '); ?>
                                    </div>
                                </div>
                                <div class="left">
                                    <?php if ($settings['show_date']) : ?>
                    <span class="date">
                      <svg id="Calendar" width="24" height="24" viewBox="0 0 25 25" fill="none"
                           xmlns="http://www.w3.org/2000/svg">
                        <path d="M8.4115 4.32167C8.7025 4.24067 8.4085 4.32067 8.7305 4.26067C9.7425 4.07267 10.9105 3.98667 12.2495 3.98667C12.8945 3.98667 13.4995 4.00667 14.0665 4.04767"
                              stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M12.2495 22.5345C5.29446 22.5345 2.97546 20.2165 2.97546 13.2605C2.97546 9.13348 3.79146 6.63848 5.90846 5.29248"
                              stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M16.2706 4.36572C20.1326 5.26572 21.5246 7.87072 21.5246 13.2607C21.5246 19.1167 19.8806 21.6857 15.2096 22.3517"
                              stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                        <path d="M3.25037 9.80884H21.2584" stroke="black" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                        <path d="M16.6533 13.7458H16.6623" stroke="black" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                        <path d="M12.2544 13.7458H12.2634" stroke="black" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                        <path d="M7.84645 13.7458H7.85545" stroke="black" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                        <path d="M16.6533 17.5979H16.6623" stroke="black" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                        <path d="M12.2544 17.5979H12.2634" stroke="black" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                        <path d="M7.84645 17.5979H7.85545" stroke="black" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                        <path d="M16.2584 2.53491V5.79691" stroke="black" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                        <path d="M8.25037 2.53491V5.79691" stroke="black" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                      </svg>
                     <?php echo get_the_date('j F, Y'); ?>
                    </span>
                    <?php endif;
                    if ($settings['show_comment']) :?>
                                    <span class="comments-count">
                       <svg id="Chat" width="24" height="24" viewBox="0 0 26 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
        <path d="M18.798 5.47365C22.404 9.07965 22.397 14.9226 18.798 18.5226C16.943 20.3776 14.501 21.2756 12.075 21.2236C8.779 21.1526 3 21.2036 3 21.2036L5.025 17.9756C5.025 17.9756 3.048 15.0387 3.048 12.0047C3.046 9.64165 3.946 7.27965 5.752 5.47465C8.001 3.22465 11.129 2.38065 14.038 2.94265"
              stroke="black" stroke-width="1.5" stroke-linecap="square"></path>
        <path d="M8.56512 12.3806H8.46613" stroke="black" stroke-width="1.5" stroke-linecap="square"></path>
        <path d="M12.2995 12.3806H12.2005" stroke="black" stroke-width="1.5" stroke-linecap="square"></path>
        <path d="M16.0334 12.3806H15.9354" stroke="black" stroke-width="1.5" stroke-linecap="square"></path>
    </svg>
                        <?php
                        // دریافت تعداد دیدگاه‌های پست
                        $comments_number = get_comments_number();

                        if ($comments_number > 0) {
                            echo esc_html($comments_number) . ' دیدگاه';
                        } else {
                            echo 'بدون دیدگاه';
                        }
                        ?>
                   </span>
                    <?php endif; ?>


                                </div>
                            </div>
                            <!-- end meta -->
                        </div>
                        <!-- end content -->
                    </div>
                <?php
                endwhile;
            endif;
            wp_reset_postdata();
            ?>
        </div>
        <?php
    }
}