<?php

class Elementor_ultra_article_grid_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_article_grid';
    }


    public function get_title()
    {
        return 'مقالات شبکه ای';
    }

    public function get_icon()
    {
        return 'eicon-form-vertical';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['article', 'post', 'blog'];
    }

    function get_cats()
    {
        $cats = ['all' => 'همه'];
        $categories = get_categories();
        foreach ($categories as $category) {
            $cats[$category->cat_ID] = $category->name;
        }
        return $cats;
    }

    /**
     *  Function Get Dynamic Category Post wordPress
     */
    function get_post_cat()
    {
        $terms = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options[$term->term_id] = $term->name;
            }
            return $options;
        }
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('کنترلر المان', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title_article_grid',
            [
                'label' => esc_html__('مقالات و آموزش ها'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مقالات و آموزش ها'),
                'placeholder' => esc_html__('مقالات و آموزش ها'),
            ]
        );
        $this->add_control(
            'icon_before_title',
            [
                'label' => esc_html__( 'آیکون' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-blog',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'blog',
                        'blogger',
                        'video-slash',
                    ],
                ],
            ]
        );
        $this->add_control(
            'select_category_article_grid',
            [
                'label' => esc_html__('دسته بندی را انتخاب کنید.'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => $this->get_post_cat(),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'definition_list_styles',
            [
                'label'  => __( 'استایل سرتیتر', 'demo-elementor-widget' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_text_color',
            [
                'label' => esc_html__('رنگ متن'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blogs .title-blog h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکون'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF8E6E', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blogs .title-blog i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'article_grid_styles',
            [
                'label'  => __( 'استایل پست ها', 'demo-elementor-widget' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_article_color',
            [
                'label' => esc_html__('رنگ متن'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blogs .the-blog .blog-item .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_see_article',
            [
                'label' => esc_html__('رنگ زمینه دکمه مشاهده'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blogs .the-blog .blog-item .view' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_title_see_article',
            [
                'label' => esc_html__('رنگ دکمه مشاهده'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#515070', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blogs .the-blog .blog-item .view span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_bg_category_article',
            [
                'label' => esc_html__('رنگ زمینه دسته بندی پست'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(255, 255, 255, 0.25)', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blogs .the-blog .blog-item .cate-blog a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_title_category_article',
            [
                'label' => esc_html__('رنگ متن دسته بندی پست'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blogs .the-blog .blog-item .cate-blog a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'show_gravatar',
            [
                'label' => esc_html__( 'نمایش گرواتار' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'نمایش' ),
                'label_off' => esc_html__( 'مخفی' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'color_author_article',
            [
                'label' => esc_html__('رنگ نویسنده پست'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .the-blog .blog-item .author span.author-article' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_date_article',
            [
                'label' => esc_html__('رنگ تاریخ انتشار پست'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .the-blog .blog-item .author span.date-article' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); // دریافت تنظیمات برای نمایش
        ?>
            <section class="blogs">
                <div class="title-blog">
                    <?php if ( ! empty( $settings['icon_before_title']['value'] ) ) {
                        echo '<i class="' . esc_attr( $settings['icon_before_title']['value'] ) . '"></i>';
                    } ?>
                    <h2><?php echo esc_html($settings['title_article_grid']); ?></h2>
                </div>


                <div class="the-blog">
                    <?php $post_query = new WP_Query(array(
                        'post_type' => 'post',
                        'posts_per_page' => 3,
                        'cat' =>$settings['select_category_article_grid'],
                        'no_found_rows' => true,
                    ));
                    if ($post_query->have_posts()) :
                        while ($post_query->have_posts()) : $post_query->the_post(); ?>
                            <div class="blog-item">
                                <div class="image-overlay ov98"></div>
                                <figure>
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('article');
                                    } else { ?>
                                        <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                    <?php } ?>
                                </figure>
                                <div class="cate-blog">
                                    <span><?php the_category(' . '); ?></span>
                                </div>
                                <a href="<?php the_permalink(); ?>"><h3 class="title"><?php the_title(); ?></h3></a>
                                <div class="author">
                                    <?php if ($settings['show_gravatar'] === 'yes') :
                                    echo get_avatar(get_the_author_meta('ID'));
                                    endif;?>
                                    <span class="author-article"><?php the_author(); ?></span>
                                    <span class="date-article"><?php echo get_the_date('j F, Y'); ?></span>
                                </div>

                                <a href="<?php the_permalink(); ?>" class="view">
                                    <svg class="svg-icon" id="Show" width="24" height="24" viewBox="0 0 25 25"
                                         fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M12.0022 10.0361C10.6703 10.0361 9.59021 11.1155 9.59021 12.4481C9.59021 13.7799 10.6704 14.8601 12.0022 14.8601C13.334 14.8601 14.4142 13.7799 14.4142 12.4481C14.4142 11.1155 13.3342 10.0361 12.0022 10.0361ZM8.09021 12.4481C8.09021 10.2867 9.84215 8.5361 12.0022 8.5361C14.1623 8.5361 15.9142 10.2867 15.9142 12.4481C15.9142 14.6083 14.1624 16.3601 12.0022 16.3601C9.842 16.3601 8.09021 14.6083 8.09021 12.4481Z"
                                              fill="black"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M4.97577 6.99435C6.77017 5.47727 9.25098 4.39609 12.0022 4.39609C14.7529 4.39609 17.2337 5.47642 19.0282 6.99314C20.8033 8.49335 22.0042 10.5101 22.0042 12.4481C22.0042 14.3861 20.8033 16.4028 19.0282 17.903C17.2337 19.4198 14.7529 20.5001 12.0022 20.5001C9.25098 20.5001 6.77017 19.4189 4.97577 17.9018C3.20099 16.4013 2.00024 14.3846 2.00024 12.4481C2.00024 10.5116 3.20099 8.49485 4.97577 6.99435ZM5.94422 8.13983C4.3705 9.47033 3.50024 11.1046 3.50024 12.4481C3.50024 13.7916 4.3705 15.4258 5.94422 16.7564C7.49832 18.0703 9.64351 19.0001 12.0022 19.0001C14.3606 19.0001 16.5058 18.0709 18.06 16.7574C19.6337 15.4273 20.5042 13.7931 20.5042 12.4481C20.5042 11.1031 19.6337 9.46883 18.06 8.13878C16.5058 6.82525 14.3606 5.89609 12.0022 5.89609C9.64351 5.89609 7.49832 6.82591 5.94422 8.13983Z"
                                              fill="black"/>
                                    </svg>
                                    <span>مشاهده</span>
                                </a>
                            </div>
                        <?php
                        endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>

                </div>
            </section>
        <?php
    }
}