<?php

class Elementor_ultra_article_grid_hover_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_article_grid_hover';
    }


    public function get_title()
    {
        return 'مقالات شبکه ای با هاور';
    }

    public function get_icon()
    {
        return 'eicon-info-box';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['article', 'post', 'blog'];
    }

    function get_cats()
    {
        $cats = ['all' => 'همه'];
        $categories = get_categories();
        foreach ($categories as $category) {
            $cats[$category->cat_ID] = $category->name;
        }
        return $cats;
    }

    /**
     *  Function Get Dynamic Category Post wordPress
     */
    function get_post_cat()
    {
        $terms = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options[$term->term_id] = $term->name;
            }
            return $options;
        }
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('کنترلر المان', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'number_post_per_page_grid',
            [
                'label' => esc_html__( 'تعداد مقالات را وارد کنید' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 8,
                'step' => 1,
                'default' => 4,
            ]
        );
        $this->add_control(
            'select_category_article_grid_hover',
            [
                'label' => esc_html__('دسته بندی راانتخاب کنید.'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => $this->get_post_cat(),
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'blog_1_styles',
            [
                'label'  => __( 'استایل پست ها', 'demo-elementor-widget' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_blog_color',
            [
                'label' => esc_html__('رنگ متن سرتیتر'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog1 .blog-item .article .content .title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'excerpt_blog_color',
            [
                'label' => esc_html__('رنگ متن توضیحات کوتاه مقاله'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog1 .blog-item .article .content .excerpt p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr_article',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'color_bg_category_blog1',
            [
                'label' => esc_html__('رنگ زمینه دسته بندی مقاله'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF8E6E', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog1 .blog-item .article .content .meta .category a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_title_category_blog1',
            [
                'label' => esc_html__('رنگ متن دسته بندی مقاله'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog1 .blog-item .article .content .meta .category a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hr_article1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'color_bg_date_blog1',
            [
                'label' => esc_html__('رنگ زمینه تاریخ انتشار مقاله'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0000008f', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog1 .blog-item .article .content .meta .date' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_title_date_blog1',
            [
                'label' => esc_html__('رنگ متن تاریخ انتشار مقاله'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff', // رنگ پیش‌فرض
                'selectors' => [
                    '{{WRAPPER}} .blog1 .blog-item .article .content .meta .date' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); // دریافت تنظیمات برای نمایش
        ?>
        <div class="blog1">
            <div class="blog-item">
                <?php $post_query = new WP_Query(array(
                    'post_type' => 'post',
                    'posts_per_page' => $settings['number_post_per_page_grid'],
                    'cat' => $settings['select_category_article_grid_hover'],
                    'no_found_rows' => true,
                ));
                if ($post_query-> have_posts()) :
                    while ($post_query->have_posts()) : $post_query->the_post(); ?>
                        <div class="article">
                            <a href="<?php the_permalink(); ?>">
                                    <?php if (has_post_thumbnail()){
                                        the_post_thumbnail();
                                    }
                                    else{ ?>
                                        <img src="<?= get_template_directory_uri().'/assets/image/empty.webp' ?>"
                                    <?php } ?>
                                </a>
                            <div class="content">
                                <div class="meta">
                                    <div class="category">
                                        <?php the_category(' .'); ?>
                                    </div>
                                    <span class="date"><?php echo get_the_date('j F, Y'); ?></span>
                                </div>
                                <!-- end meta -->
                                <h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                <div class="excerpt">
                                    <?php the_excerpt(); ?>
                                </div>
                            </div>
                        </div>
                    <?php
                    endwhile;
                endif;
                wp_reset_postdata();
                ?>
            </div>
        </div>
        <?php
    }
}