<?php

class Elementor_ultra_article_details_slider_widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'ultra_article_details_slider';
    }


    public function get_title()
    {
        return 'اسلایدر مقالات طرح استاندارد';
    }

    public function get_icon()
    {
        return 'eicon-single-page';
    }


    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['article', 'post', 'blog'];
    }

    function get_cats()
    {
        $cats = ['all' => 'همه'];
        $categories = get_categories();
        foreach ($categories as $category) {
            $cats[$category->cat_ID] = $category->name;
        }
        return $cats;
    }

    /**
     *  Function Get Dynamic Category Post wordPress
     */
    function get_post_cat()
    {
        $terms = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options[$term->term_id] = $term->name;
            }
            return $options;
        }
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('اسلایدر مقالات', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('مقالات'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مقالات'),
                'placeholder' => esc_html__('مقالات'),
            ]
        );
        $this->add_control(
            'title_link',
            [
                'label' => esc_html__('مشاهده همه'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشاهده همه'),
                'placeholder' => esc_html__('مشاهده همه'),
            ]
        );
        $this->add_control(
            'link',
            [
                'label' => esc_html__('لینک'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'number_post_per_page_grid',
            [
                'label' => esc_html__('تعداد مقالات را وارد کنید'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 8,
                'step' => 1,
                'default' => 4,
            ]
        );
        $this->add_control(
            'select_category_article_grid_hover',
            [
                'label' => esc_html__('دسته بندی راانتخاب کنید.'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => $this->get_post_cat(),
            ]
        );
        $this->add_control(
            'nav_slider',
            [
                'label' => 'نمایش پیکان ها',
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'textdomain'),
                'label_off' => esc_html__('مخفی', 'textdomain'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

        //─────────────────────────────
        //         STYLE TAB
        //─────────────────────────────
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل کلی ویجت', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('تایپوگرافی عنوان', 'textdomain'),
                'selector' => '{{WRAPPER}} .ultra-header-widgets .title h3',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-header-widgets .title h3' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکون', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-header-widgets .title svg path' => 'stroke: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'button_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-header-widgets .view-all' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_hover_color',
            [
                'label' => esc_html__('رنگ متن دکمه (Hover)', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-header-widgets .view-all:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_hover_bg',
            [
                'label' => esc_html__('رنگ پس‌زمینه دکمه (Hover)', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ultra-header-widgets .view-all:hover' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="readingShowcase ultra-slider-nav-style">
            <div class="ultra-header-widgets">
                <div class="title">
                    <figure>
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                             viewBox="0 0 20 21" fill="none">
                            <path d="M10 5.34391V17.2182M4.16667 7.1783C5.22148 7.34166 6.39815 7.61325 7.5 8.03933M4.16667 10.5116C4.69957 10.5942 5.26358 10.7043 5.83333 10.8481M3.32861 2.80883C5.17726 3.01773 7.66094 3.5797 9.43069 4.81981C9.77082 5.05815 10.2292 5.05815 10.5693 4.81981C12.3391 3.5797 14.8227 3.01773 16.6714 2.80883C17.5863 2.70545 18.3333 3.46946 18.3333 4.41209V13.7994C18.3333 14.742 17.5863 15.5063 16.6714 15.6097C14.8227 15.8186 12.3391 16.3806 10.5693 17.6207C10.2292 17.859 9.77082 17.859 9.43069 17.6207C7.66094 16.3806 5.17726 15.8186 3.32861 15.6097C2.41369 15.5063 1.66667 14.742 1.66667 13.7994V4.41209C1.66667 3.46946 2.41369 2.70545 3.32861 2.80883Z"
                                  stroke="#007AF4" stroke-width="1.5" stroke-linecap="round"/>
                        </svg>
                    </figure>
                    <?php if (!empty($settings['title'])): ?>
                        <h3><?php echo esc_html($settings['title']); ?></h3>
                    <?php endif; ?>
                </div>
                <?php
                $url         = $settings['link']['url'] ?? '';
                $is_external = $settings['link']['is_external'] ? ' target="_blank"' : '';
                $nofollow    = $settings['link']['nofollow']    ? ' rel="nofollow"'  : '';
                ?>
                <a href="<?php echo esc_url( $url ); ?>" <?php echo $is_external . $nofollow; ?> class="view-all"><?php echo esc_html($settings['title_link']); ?></a>
            </div>

			
					    <div class="skeleton-slider">
       <div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
						     <div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
		<div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
		<div class="skeleton-item">
    <div class="skeleton-image"></div>
    <div class="skeleton-title"></div>
    <div class="skeleton-price"></div>
</div>
    </div>
				
			
			
			
            <div class="owl-carousel owl-theme readingShowcase_slider ">
                <?php $post_query = new WP_Query(array(
                    'post_type' => 'post',
                    'posts_per_page' => $settings['number_post_per_page_grid'],
                    'cat' => $settings['select_category_article_grid_hover'],
                    'no_found_rows' => true,
                ));
                if ($post_query->have_posts()) :
                    while ($post_query->have_posts()) : $post_query->the_post(); ?>
                        <div class="item">
                            <a href="<?php the_permalink();?>">
                                <figure>
                               <span class="date-of-publish">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                         viewBox="0 0 20 21" fill="none">
                              <g clip-path="url(#clip0_337_2048)">
                                <path d="M2.5 7.85987C2.5 5.65073 4.29086 3.85986 6.5 3.85986H13.5C15.7091 3.85986 17.5 5.65072 17.5 7.85986V15.2765C17.5 17.4857 15.7091 19.2765 13.5 19.2765H6.5C4.29086 19.2765 2.5 17.4857 2.5 15.2765V7.85987Z"
                                      stroke="#242424" stroke-width="1.5"/>
                                <path d="M2.5 8.44385H17.5" stroke="#242424" stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M6.66699 2.60986L6.66699 5.10986" stroke="#242424" stroke-width="1.5"
                                      stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <path d="M13.333 2.60986V5.10986" stroke="#242424" stroke-width="1.5"
                                      stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <circle cx="10.0003" cy="13.4432" r="0.833333" fill="#242424"/>
                                <circle cx="13.3333" cy="13.4432" r="0.833333" fill="#242424"/>
                                <circle cx="6.66634" cy="13.4432" r="0.833333" fill="#242424"/>
                              </g>
                              <defs>
                                <clipPath id="clip0_337_2048">
                                  <rect width="20" height="20" fill="white" transform="translate(0 0.943848)"/>
                                </clipPath>
                              </defs>
                            </svg>
                                    <?php
                                    $published_timestamp = get_the_time( 'U' );
                                    $current_timestamp   = current_time( 'timestamp' );
                                    $time_diff = human_time_diff( $published_timestamp, $current_timestamp );
                                    echo '<span>' . esc_html( $time_diff ) . ' پیش</span>';
                                    ?>
                                </span>
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail();
                                    } else { ?>
                                        <img src="<?= get_template_directory_uri() . '/assets/image/empty.webp' ?>"
                                    <?php } ?>
                                </figure>
                            </a>
                            <a href="<?php the_permalink();?>"><h4><?php the_title(); ?></h4></a>
                            <?php the_excerpt(); ?>
                            <div class="info">
                                            <span class="author">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                                     viewBox="0 0 20 21" fill="none">
                              <path d="M13.3334 6.63265H12.5834C12.5834 8.05939 11.4268 9.21598 10 9.21598V9.96598V10.716C12.2552 10.716 14.0834 8.88781 14.0834 6.63265H13.3334ZM10 9.96598V9.21598C8.57328 9.21598 7.41669 8.05939 7.41669 6.63265H6.66669H5.91669C5.91669 8.88781 7.74486 10.716 10 10.716V9.96598ZM6.66669 6.63265H7.41669C7.41669 5.20591 8.57328 4.04932 10 4.04932V3.29932V2.54932C7.74486 2.54932 5.91669 4.37749 5.91669 6.63265H6.66669ZM10 3.29932V4.04932C11.4268 4.04932 12.5834 5.20591 12.5834 6.63265H13.3334H14.0834C14.0834 4.37749 12.2552 2.54932 10 2.54932V3.29932ZM15.8334 15.3826H15.0834C15.0834 15.7509 14.7653 16.2863 13.7894 16.7742C12.8584 17.2397 11.5197 17.5493 10 17.5493V18.2993V19.0493C11.702 19.0493 13.28 18.706 14.4602 18.1159C15.5956 17.5482 16.5834 16.6252 16.5834 15.3826H15.8334ZM10 18.2993V17.5493C8.48038 17.5493 7.14168 17.2397 6.21064 16.7742C5.23474 16.2863 4.91669 15.7509 4.91669 15.3826H4.16669H3.41669C3.41669 16.6252 4.40447 17.5482 5.53982 18.1159C6.72004 18.706 8.298 19.0493 10 19.0493V18.2993ZM4.16669 15.3826H4.91669C4.91669 15.0144 5.23474 14.479 6.21064 13.9911C7.14168 13.5256 8.48038 13.216 10 13.216V12.466V11.716C8.298 11.716 6.72004 12.0593 5.53982 12.6494C4.40447 13.2171 3.41669 14.1401 3.41669 15.3826H4.16669ZM10 12.466V13.216C11.5197 13.216 12.8584 13.5256 13.7894 13.9911C14.7653 14.479 15.0834 15.0144 15.0834 15.3826H15.8334H16.5834C16.5834 14.1401 15.5956 13.2171 14.4602 12.6494C13.28 12.0593 11.702 11.716 10 11.716V12.466Z"
                                    fill="#C2C5C6"/>
                            </svg>
                                                <span><?php echo esc_html( get_the_author()); ?></span>
                                            </span>
                                <span class="reach">
                                                <span><?php echo ultra_get_post_views( get_the_ID() ); ?></span>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                                     viewBox="0 0 20 21" fill="none">
                                                  <path d="M17.6086 9.01019C18.5749 10.0269 18.5749 11.5716 17.6086 12.5884C15.9787 14.3032 13.1796 16.6326 9.99999 16.6326C6.82039 16.6326 4.02123 14.3032 2.39141 12.5884C1.42507 11.5716 1.42507 10.0269 2.39141 9.01019C4.02123 7.29539 6.82039 4.96594 9.99999 4.96594C13.1796 4.96594 15.9787 7.29539 17.6086 9.01019Z"
                                                        stroke="#C2C5C6" stroke-width="1.5"/>
                                                  <path d="M12.5 10.7993C12.5 12.18 11.3807 13.2993 9.99999 13.2993C8.61928 13.2993 7.49999 12.18 7.49999 10.7993C7.49999 9.41856 8.61928 8.29928 9.99999 8.29928C11.3807 8.29928 12.5 9.41856 12.5 10.7993Z"
                                                        stroke="#C2C5C6" stroke-width="1.5"/>
                                                </svg>
                                            </span>
                            </div>
                            <div class="bottom-info">
                                <div class="time-of-read">
                                    <?php
                                    $content = wp_strip_all_tags( get_the_content() );
                                    $word_count = str_word_count( $content );
                                    $words_per_minute = 200;
                                    $reading_time = max( 1, ceil( $word_count / $words_per_minute ) );
                                    ?>
                                    <span>زمان مطالعه</span>
                                    <span> <?php echo esc_html( $reading_time ); ?> دقیقه</span>
                                </div>
                                <a href="<?php the_permalink(); ?>">
                                    <span>مطالعه</span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                         viewBox="0 0 20 21" fill="none">
                                        <path d="M10 5.34391V17.2182M4.16667 7.1783C5.22148 7.34166 6.39815 7.61325 7.5 8.03933M4.16667 10.5116C4.69957 10.5942 5.26358 10.7043 5.83333 10.8481M3.32861 2.80883C5.17726 3.01773 7.66094 3.5797 9.43069 4.81981C9.77082 5.05815 10.2292 5.05815 10.5693 4.81981C12.3391 3.5797 14.8227 3.01773 16.6714 2.80883C17.5863 2.70545 18.3333 3.46946 18.3333 4.41209V13.7994C18.3333 14.742 17.5863 15.5063 16.6714 15.6097C14.8227 15.8186 12.3391 16.3806 10.5693 17.6207C10.2292 17.859 9.77082 17.859 9.43069 17.6207C7.66094 16.3806 5.17726 15.8186 3.32861 15.6097C2.41369 15.5063 1.66667 14.742 1.66667 13.7994V4.41209C1.66667 3.46946 2.41369 2.70545 3.32861 2.80883Z"
                                              stroke="#007AF4" stroke-width="1.5" stroke-linecap="round"/>
                                    </svg>
                                </a>
                            </div>


                        </div>
                    <?php
                    endwhile;
                endif;
                wp_reset_postdata(); ?>
            </div>
        </section>
        <script>
    jQuery(function ($) {

  function initSlider($slider) {
    const $skeleton = $slider.siblings('.skeleton-slider');

    $slider
      .css({ visibility: 'hidden', display: 'block' })
      .owlCarousel({
        loop: true,
        margin: 20,
        rtl: true,
        dots: false,
        nav: $slider.data('nav-slider') === true || $slider.data('nav-slider') === "true",
        autoWidth: true
      });

    setTimeout(function () {
      $skeleton.fadeOut(200);
      $slider
        .css('visibility', 'visible')
        .fadeIn(200);
    }, 150);
  }

  $('.readingShowcase_slider').each(function () {
    const $slider = $(this);
    const $skeleton = $slider.siblings('.skeleton-slider');

    $slider.hide();
    $skeleton.show();
    initSlider($slider);

    let resizeTimer;
    $(window).on('resize', function () {
      clearTimeout(resizeTimer);
      resizeTimer = setTimeout(function () {

        if ($slider.hasClass('owl-loaded')) {
          $slider.trigger('destroy.owl.carousel');
          $slider.removeClass('owl-loaded owl-hidden');
          $slider.find('.owl-stage-outer').children().unwrap();
        }

        $slider.hide().css('visibility', 'hidden');
        $skeleton.show();

        initSlider($slider);
      }, 300);
    });
  });

});

        </script>
        <?php
    }
}