<?php

class Elementor_ultra_cute_blog extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ultra_cute_blog';
    }

    public function get_title()
    {
        return 'مقالات فانتزی اولترا';
    }

    public function get_icon()
    {
        return 'eicon-info-box';
    }

    public function get_categories()
    {
        return ['ultra'];
    }

    public function get_keywords()
    {
        return ['blog', 'article', 'cute'];
    }

    private function get_post_cat()
    {
        $terms = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));
        $options = [];
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options[$term->term_id] = $term->name;
            }
        }
        return $options;
    }

    protected function register_controls()
    {
        $this->start_controls_section('content_section', [
            'label' => __('محتوا', 'textdomain'),
        ]);

        $this->add_control('title', [
            'label' => __('عنوان', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'مقالات اخیر',
        ]);

        $this->add_control('button_text', [
            'label' => __('متن دکمه', 'textdomain'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'مشاهده همه مقاله ها',
        ]);

        $this->add_control('button_link', [
            'label' => __('لینک دکمه', 'textdomain'),
            'type' => \Elementor\Controls_Manager::URL,
            'default' => [
                'url' => '#',
                'is_external' => false,
            ],
        ]);

        $this->add_control('button_icon', [
            'label' => __('آیکون دکمه', 'textdomain'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fas fa-paw',
                'library' => 'fa-solid',
            ],
        ]);

        $this->add_control('select_category', [
            'label' => __('انتخاب دسته‌بندی', 'textdomain'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'multiple' => true,
            'label_block' => true,
            'options' => $this->get_post_cat(),
        ]);

        $this->add_control('post_count', [
            'label' => __('تعداد مقالات', 'textdomain'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 3,
            'min' => 1,
            'max' => 20,
        ]);

        $this->end_controls_section();

        $this->start_controls_section('style_header', [
            'label' => __('استایل عنوان و دکمه'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('title_color', [
            'label' => __('رنگ عنوان'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-cute-blog header h3' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_control('title_font_size', [
            'label' => __('اندازه فونت عنوان'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'selectors' => [
                '{{WRAPPER}} .ultra-cute-blog header h3' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]);

        $this->add_control('button_color', [
            'label' => __('رنگ متن دکمه'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-cute-blog header a' => 'color: {{VALUE}}',
            ],
        ]);

        $this->add_control('button_bg', [
            'label' => __('رنگ پس‌زمینه دکمه'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-cute-blog header a' => 'background-color: {{VALUE}}',
            ],
        ]);

        $this->add_control('button_bg_hover', [
            'label' => __('رنگ پس‌زمینه هاور دکمه'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .ultra-cute-blog header a:hover' => 'background-color: {{VALUE}}',
            ],
        ]);
        $this->end_controls_section();

$this->start_controls_section('style_blog_cards', [
    'label' => __('استایل کارت‌های مقاله', 'textdomain'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
]);

$this->add_control('card_bg_color', [
    'label' => __('رنگ پس‌زمینه کارت'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .ultra-cute-blog .blog-body' => 'background-color: {{VALUE}}',
    ],
]);

$this->add_control('cate_bg_color', [
    'label' => __('رنگ پس‌زمینه دسته‌بندی'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .ultra-cute-blog .cate-blog span' => 'background-color: {{VALUE}}',
    ],
]);

$this->add_control('cate_text_color', [
    'label' => __('رنگ متن دسته‌بندی'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .ultra-cute-blog .cate-blog span' => 'color: {{VALUE}}',
    ],
]);

$this->add_control('author_color', [
    'label' => __('رنگ نویسنده'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .ultra-cute-blog .blog-body .info span:first-child' => 'color: {{VALUE}}',
    ],
]);

$this->add_control('date_color', [
    'label' => __('رنگ تاریخ'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .ultra-cute-blog .blog-body .info span:last-child' => 'color: {{VALUE}}',
    ],
]);

$this->add_control('title_color_blog', [
    'label' => __('رنگ عنوان مقاله'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .ultra-cute-blog .blog-body h4' => 'color: {{VALUE}}',
    ],
]);

$this->end_controls_section();

$this->start_controls_section('style_section_bg', [
    'label' => __('پس‌زمینه سکشن', 'textdomain'),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
]);

 $this->add_control('card_bg_image', [
    'label' => __('تصویر پس‌زمینه کارت', 'textdomain'),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'default' => [
        'url' => get_template_directory_uri() . '/assets/image/product-grid-bg-pattern.png',
    ],
    'selectors' => [
        '{{WRAPPER}} .ultra-cute-blog .cute-blog-items .blog-body' => 'background-image: url("{{URL}}");',
    ],
]);

$this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $query_args = [
            'post_type' => 'post',
            'posts_per_page' => $settings['post_count'],
        ];

        if (!empty($settings['select_category'])) {
            $query_args['category__in'] = $settings['select_category'];
        }

        $query = new WP_Query($query_args);

        echo '<section class="ultra-cute-blog">';
        echo '<header>';
        echo '<h3>' . esc_html($settings['title']) . '</h3>';

        if (!empty($settings['button_link']['url'])) {
            $this->add_render_attribute('button_link', 'href', esc_url($settings['button_link']['url']));
            if (!empty($settings['button_link']['is_external'])) {
                $this->add_render_attribute('button_link', 'target', '_blank');
            }
            echo '<a ' . $this->get_render_attribute_string('button_link') . '>';
            echo '<i class="' . esc_attr($settings['button_icon']['value']) . '"></i> ';
            echo esc_html($settings['button_text']) . '</a>';
        }

        echo '</header>';

        echo '<article class="cute-blog-items">';

        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $categories = get_the_category();
                $cats = array_slice($categories, 0, 2);
                 echo '<a href="' . esc_url(get_permalink()) . '" class="blog-body">';
                echo '<figure class="img-sec">';
                if (has_post_thumbnail()) {
                    the_post_thumbnail('medium');
                } else {
                    echo '<img src="' . get_template_directory_uri() . '/assets/image/empty.webp" alt="' . esc_attr(get_the_title()) . '">';
                }
                echo '<div class="cate-blog">';
                foreach ($cats as $cat) {
                    echo '<span>' . esc_html($cat->name) . '</span>';
                }
                echo '</div></figure>';
                echo '<div class="info">';
                echo '<span><i class="fa-solid fa-user"></i> ' . get_the_author() . '</span>';
                echo '<span><i class="fa-solid fa-calendar-days"></i> ' . get_the_date('j F Y') . '</span>';
                echo '</div>';
                echo '<h4>' . get_the_title() . '</h4>';
                echo '</a>';
            }
            wp_reset_postdata();
        }

        echo '</article></section>';
    }
}