<?php
// add_action('elementor/elements/categories_registered', function($elements_manager) {
//     $elements_manager->add_category(
//         'ultra',
//         [
//             'title' => 'اختصاصی اولترا مارکت',
//             'icon' => 'fa fa-plug',
//         ]
//     );
// }, 1); 

add_action('elementor/elements/categories_registered', function($elements_manager) {
    // اول دسته ultra رو ثبت می‌کنیم
    $elements_manager->add_category(
        'ultra',
        [
            'title' => 'اختصاصی اولترا مارکت',
            'icon' => 'fa fa-plug',
        ]
    );
}, 99); // عمداً می‌زنیم آخر اجرا بشه، چون بعدش دستی می‌بریمش بالا

// هک برای بردن ultra به اول لیست
add_filter('elementor/elements/categories', function($categories) {
    if (isset($categories['ultra'])) {
        $ultra = $categories['ultra'];
        unset($categories['ultra']);
        // ultra رو می‌ذاریم اول آرایه
        $categories = array_merge(['ultra' => $ultra], $categories);
    }
    return $categories;
});


function register_oembed_widget($widgets_manager)
{
    require_once(__DIR__ . '/widget/tv-slider-widget.php');
    $widgets_manager->register(new \Elementor_ultra_tv_slider_widget());

    require_once(__DIR__ . '/widget/support-widget.php');
    $widgets_manager->register(new \Elementor_ultra_support_widget());

    require_once(__DIR__ . '/widget/article-details-slider.php');
    $widgets_manager->register(new \Elementor_ultra_article_details_slider_widget());

    require_once(__DIR__ . '/widget/ultra-product-soptlight.php');
    $widgets_manager->register(new \Elementor_ultra_product_soptlight_widget_el());

    require_once(__DIR__ . '/widget/ultra-product-base-card.php');
    $widgets_manager->register(new \Elementor_ultra_product_base_card_widget());

    require_once(__DIR__ . '/widget/title-classic.php');
    $widgets_manager->register(new \Elementor_ultra_product_showcase_widget());

    require_once(__DIR__ . '/widget/ultra-main-slider2-widget.php');
    $widgets_manager->register(new \Elementor_ultra_slider2_widget());

    require_once(__DIR__ . '/widget/ultra-category-product-thumbnail2.php');
    $widgets_manager->register(new \Elementor_ultra_category_grid_widget());

    require_once(__DIR__ . '/widget/ultra-product-amazing2.php');
    $widgets_manager->register(new \Elementor_ultra_product_amazing2());


    require_once(__DIR__ . '/widget/mainSlider-widget.php');
    $widgets_manager->register(new \Elementor_ultra_mainSlider_widget());

    require_once(__DIR__ . '/widget/ultra-basic-product.php');
    $widgets_manager->register(new \Elementor_ultra_basic_product_widget());

    require_once(__DIR__ . '/widget/ultra-minimal-product.php');
    $widgets_manager->register(new \Elementor_ultra_minimal_product_widget());

    require_once(__DIR__ . '/widget/slider-product-category.php');
    $widgets_manager->register(new \Elementor_ultra_slider_category_product());

    require_once(__DIR__ . '/widget/ultra-grid-fixed-button-product.php');
    $widgets_manager->register(new \Elementor_ultra_grid_fixed_button_product_widget());

    require_once(__DIR__ . '/widget/ultra-fixed-tile-layout-product.php');
    $widgets_manager->register(new \Elementor_ultra_fixed_tile_layout_product_widget());

    require_once(__DIR__ . '/widget/ultra-classic-grid-product.php');
    $widgets_manager->register(new \Elementor_ultra_classic_grid_product_widget());

    require_once(__DIR__ . '/widget/ultra-hover-effect-grid.php');
    $widgets_manager->register(new \Elementor_ultra_hover_effect_grid_product_widget());

    require_once(__DIR__ . '/widget/ultra-product-amazing.php');
    $widgets_manager->register(new \Elementor_ultra_product_amazing());

    require_once(__DIR__ . '/widget/ultra-best-sell-widget.php');
    $widgets_manager->register(new \Elementor_ultra_product_best_sell());

    require_once(__DIR__ . '/widget/ultra-suggest-product-widget.php');
    $widgets_manager->register(new \Elementor_ultra_suggest_product_sell());

    require_once(__DIR__ . '/widget/ultra-cutie-products.php');
    $widgets_manager->register(new \Elementor_ultra_cutie_products());

    require_once(__DIR__ . '/widget/ultra-category-product-thumbnail.php');
    $widgets_manager->register(new \Elementor_ultra_category_product_thumbnail());

    require_once(__DIR__ . '/widget/ultra-category-widget.php');
    $widgets_manager->register(new \Elementor_ultra_category_widget());

    require_once(__DIR__ . '/widget/ultra-brand-widget.php');
    $widgets_manager->register(new \Elementor_ultra_brand_widget());

    require_once(__DIR__ . '/widget/ultra-brand-showcase-widget.php');
    $widgets_manager->register(new \Elementor_ultra_brand_showcase_widget());

    require_once(__DIR__ . '/widget/box-offer-product.php');
    $widgets_manager->register(new \Elementor_ultra_box_offer_product());

    require_once(__DIR__ . '/widget/tv-widget.php');
    $widgets_manager->register(new \Elementor_ultra_tv_widget());

    require_once(__DIR__ . '/widget/tv-grid-widget.php');
    $widgets_manager->register(new \Elementor_ultra_tv_grid_widget());

    require_once(__DIR__ . '/widget/insta-widget.php');
    $widgets_manager->register(new \Elementor_ultra_insta_widget());

    require_once(__DIR__ . '/widget/insta-grid-widget.php');
    $widgets_manager->register(new \Elementor_ultra_insta_grid_widget());

    require_once(__DIR__ . '/widget/article-grid-widget.php');
    $widgets_manager->register(new \Elementor_ultra_article_grid_widget());

    require_once(__DIR__ . '/widget/article-grid-hover-widget.php');
    $widgets_manager->register(new \Elementor_ultra_article_grid_hover_widget());

    require_once(__DIR__ . '/widget/article-list-widget.php');
    $widgets_manager->register(new \Elementor_ultra_article_list_widget());

    require_once(__DIR__ . '/widget/article-slider.php');
    $widgets_manager->register(new \Elementor_ultra_article_slider_widget());

    require_once(__DIR__ . '/widget/article-cute-widget.php');
    $widgets_manager->register(new \Elementor_ultra_cute_blog());

    require_once(__DIR__ . '/widget/ultra-story-widget.php');
    $widgets_manager->register(new \Elementor_ultra_story_widget());

    require_once(__DIR__ . '/widget/ultra-guarantee-widget.php');
    $widgets_manager->register(new \Elementor_ultra_guarantee_widget());

    require_once(__DIR__ . '/widget/banner-widget.php');
    $widgets_manager->register(new \Elementor_ultra_banner_widget());

    require_once(__DIR__ . '/widget/teamMembers-widget.php');
    $widgets_manager->register(new \Elementor_ultra_teamMembers_widget());

    require_once(__DIR__ . '/widget/comment-slider-widget.php');
    $widgets_manager->register(new \Elementor_ultra_commentSlider_widget());

    require_once(__DIR__ . '/widget/ultra-why-us-widget.php');
    $widgets_manager->register(new \Elementor_ultra_why_us());
    
    require_once(__DIR__ . '/widget/ultra-last-viewed-widget.php');
    $widgets_manager->register(new \Elementor_ultra_last_viewed());
}

add_action('elementor/widgets/register', 'register_oembed_widget');


//Disable Elementor Google Fonts
add_filter( 'elementor/frontend/print_google_fonts', '__return_false' );

//Register Elementor Panel styles
add_action('elementor/editor/before_enqueue_scripts', function() {
    wp_register_style('ultra-elementor', get_template_directory_uri() . '/assets/css/elementor.css', array(), 01);
    wp_enqueue_style('ultra-elementor');
});