<?php
if (!function_exists('better_comments')):
    function better_comments($comment, $args, $depth)
    {
        ?>
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
        <div class="comment_meta">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/image/gravatar.png" width="60" height="60" alt="User Avatar">


            <p class="user_meta">
                <span class="review_author"><?php echo get_comment_author() ?></span>
                <span class="comment-date"><?php printf(esc_html__('%1$s at %2$s'), get_comment_date(), get_comment_time()) ?></span>
                <span class="reply">
                        <a href="#" rel="nofollow" class="comment-reply-link">
                            <i class="fa fa-reply"></i>
                            <?php comment_reply_link(array_merge($args,
                                array('depth' => $depth,
                                    'max_depth' => $args['max_depth']
                                ))) ?></a>
                    </span>
            </p>
        </div>
        <div class="description">
            <?php comment_text() ?>
        </div>
        <?php if ($comment->comment_approved == '0') : ?>
        <em><?php esc_html_e('دیدگاه شما در حال بررسی می باشد.','5balloons_theme') ?></em>
        <br />
    <?php endif; ?>
        <?php
    }
endif;