<?php
// افزودن منوی "اولترا مارکت" به نوار ادمین
add_action('admin_bar_menu', 'add_ultra_menu_to_admin_bar', 100);
function add_ultra_menu_to_admin_bar($wp_admin_bar) {
    if (!is_admin_bar_showing() || !current_user_can('manage_options')) {
        return;
    }

    // منوی اصلی
    $wp_admin_bar->add_node(array(
        'id'    => 'ultra_settings_admin_bar',
        'title' => '<span class="ab-icon dashicons-admin-generic"></span><span class="ab-label">اولترا مارکت</span>',
        'href'  => admin_url('admin.php?page=ultra_options'),
        'meta'  => array('title' => 'تنظیمات اولترا مارکت'),
    ));

    // افزودن زیرمنوها (در صورتی که تعریف شده باشند)
    global $submenu;

    if (!empty($submenu['ultra-theme-settings']) && is_array($submenu['ultra-theme-settings'])) {
        foreach ($submenu['ultra-theme-settings'] as $item) {
            if (!empty($item[0]) && !empty($item[2])) {
                $menu_title = strip_tags($item[0]);
                $menu_slug  = $item[2];

                $wp_admin_bar->add_node(array(
                    'id'     => 'ultra_sub_' . sanitize_title($menu_slug),
                    'title'  => $menu_title,
                    'href'   => (strpos($menu_slug, '.php') !== false) ? admin_url($menu_slug) : admin_url('admin.php?page=' . $menu_slug),
                    'parent' => 'ultra_settings_admin_bar',
                ));
            }
        }
    }
}


add_action('admin_menu', 'ultraSetting');
function ultraSetting() {
    add_menu_page(
        'تنظیمات اولترا مارکت',
        'اولترا مارکت',
        'manage_options',
        'ultra-theme-settings',
        'render_ultra_settings_page',
        get_template_directory_uri() . '/assets/image/ultra-admin.png',
        3
    );
}

add_action('admin_head', function () {
    echo '
    <style>
        #toplevel_page_ultra-theme-settings .wp-menu-image img {
            width: 20px;
            height: 20px;
            object-fit: contain;
        }
        #toplevel_page_ultra-theme-settings .wp-menu-image.dashicons-before:before {
            content: none !important;
        }
    </style>
    ';
});

add_action('admin_menu', function () {
    remove_menu_page('ultra_options');

    add_submenu_page(
        'ultra-theme-settings',        
        'تنظیمات قالب',
        'تنظیمات قالب',
        'manage_options',
        'ultra_options'
    );
}, 999);
