<?php global $ultra_options ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta <?php bloginfo('charset'); ?> />
    <link rel="icon" type="image/png" href="<?php echo $ultra_options['ultra-favicon']['url']; ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <?php
    echo $ultra_options['header_custom_code'];
    wp_head(); ?>
    <script> var $ = jQuery</script>

</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>


<?php
$custom_headers = get_posts(array(
    'post_type' => 'ultra_header',
    'post_status' => 'publish',
    'posts_per_page' => 1,
    'orderby' => 'date',
    'order' => 'DESC'
));

if (!is_singular('ultra_header') && !empty($custom_headers)) {
    // اگر هدر سفارشی داریم، فقط همونو لود کن
    echo '<div class="custom-header-wrapper">';
    echo \Elementor\Plugin::instance()->frontend->get_builder_content($custom_headers[0]->ID);
    echo '</div>';
    return; // بعد از نمایش هدر سفارشی، کل بقیه header.php رو متوقف می‌کنیم
}
?>


<?php if ($ultra_options['active_message_header'] == true) : ?>
    <div class="top-head-cus" style="text-align:center;">
        <span class="ultra-info-closebtn" onclick="this.parentElement.style.display='none';">&times;</span>
        <p><?php echo $ultra_options['text_custom_message_header']; ?></p>
        <?php if (isset($ultra_options['text_custom_btn_message_header'])): ?>
            <a href="<?php echo $ultra_options['link_custom_message_header']; ?>"><?php echo $ultra_options['text_custom_btn_message_header']; ?></a>
        <?php endif; ?>
    </div>
<?php endif; ?>
<div class="search-mobile">
    <header>
        <h4>جستجوی محصولات</h4>
        <span class="close_search"><i class="fas fa-multiply"></i> بازگشت </span>
    </header>
    <form method="get" action="<?php echo home_url('/'); ?>">
        <input type="search" name="s" id="mobile-keyword"
               onkeyup="if (this.value.length > 2) fetch('#mobile-keyword', '#mobile-datafetch')"
               class="search-input" placeholder="جستجو در محصولات..."/>
        <button type="submit">
            <svg width="25" height="25" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M9.16666 16.6666C13.3088 16.6666 16.6667 13.3088 16.6667 9.16663C16.6667 5.02449 13.3088 1.66663 9.16666 1.66663C5.02453 1.66663 1.66666 5.02449 1.66666 9.16663C1.66666 13.3088 5.02453 16.6666 9.16666 16.6666Z"
                      stroke="#7E7E7E" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M15.7749 17.2415C16.2166 18.5748 17.2249 18.7081 17.9999 17.5415C18.7083 16.4748 18.2416 15.5998 16.9583 15.5998C16.0083 15.5915 15.4749 16.3331 15.7749 17.2415Z"
                      stroke="#7E7E7E" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
        </button>
    </form>
    <div id="mobile-datafetch" class="content-ajax-search"></div>
    <div class="search-note">
        <svg width="70px" height="70px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                  d="M1 5C1 3.34315 2.34315 2 4 2H8.43845C9.81505 2 11.015 2.93689 11.3489 4.27239L11.7808 6H13.5H20C21.6569 6 23 7.34315 23 9V11C23 11.5523 22.5523 12 22 12C21.4477 12 21 11.5523 21 11V9C21 8.44772 20.5523 8 20 8H13.5H11.7808H4C3.44772 8 3 8.44772 3 9V10V19C3 19.5523 3.44772 20 4 20H9C9.55228 20 10 20.4477 10 21C10 21.5523 9.55228 22 9 22H4C2.34315 22 1 20.6569 1 19V10V9V5ZM3 6.17071C3.31278 6.06015 3.64936 6 4 6H9.71922L9.40859 4.75746C9.2973 4.3123 8.89732 4 8.43845 4H4C3.44772 4 3 4.44772 3 5V6.17071ZM20.1716 18.7574C20.6951 17.967 21 17.0191 21 16C21 13.2386 18.7614 11 16 11C13.2386 11 11 13.2386 11 16C11 18.7614 13.2386 21 16 21C17.0191 21 17.967 20.6951 18.7574 20.1716L21.2929 22.7071C21.6834 23.0976 22.3166 23.0976 22.7071 22.7071C23.0976 22.3166 23.0976 21.6834 22.7071 21.2929L20.1716 18.7574ZM13 16C13 14.3431 14.3431 13 16 13C17.6569 13 19 14.3431 19 16C19 17.6569 17.6569 19 16 19C14.3431 19 13 17.6569 13 16Z"
                  fill="#000000"/>
        </svg>
        <span>محصول مورد نظر خود را جستجو کنید</span>
    </div>
</div>

<div id="modal_add_to_cart" class="modal">
    <!-- Modal content -->
    <div class="modal-content modal-add-to-cart">
        <i class="fa-solid fa-check"></i>
        محصول به سبد خرید اضافه شد
    </div>
</div>

<div id="modal_display_cart" class="modal">
    <!-- Modal content -->
    <div class="modal-content modal-cart">
        <i class="fa-solid fa-check"></i>
        محصول به سبد خرید اضافه شد
        <div class="btn-modal">
            <?php
            if (class_exists('WooCommerce')) {
                $cart_url = wc_get_cart_url();
            } else {
                $cart_url = '#';
            }
            ?>

            <a href="<?php echo $cart_url ?>" class="view-cart">مشاهده سبد خرید</a>
            <a href="javascript:void(0);" class="close-modal">بستن</a>
        </div>
    </div>
</div>


<header class="main-header-mob">

    <div class="top-header">
        <div class="right-side">
            <div id="myBtn" class=" bar-menu">
                <span class="bar"></span>
                <span class="bar"></span>
                <span class="bar"></span>
            </div>
            <div id="myModal" class="modal-pup">
                <div class="modal-item">
                    <div class="modal-header">

                        <div class="logo-header">
                            <?php if ($ultra_options['ultra-logo-img']['url']) { ?>
                                <img src="<?php echo $ultra_options['ultra-logo-img']['url'] ?>" alt=""/>
                            <?php }
                            if ($ultra_options['ultra-logo-check'] == 1) { ?>
                                <span><?php echo $ultra_options['ultra-logo-name'] ?></span>
                            <?php } ?>
                        </div>
                        <span class="close">&times;</span>
                    </div>


                    <div class="modal-content_ultra">
                        <nav class="hum-menu">
                            <?php if (has_nav_menu('mobileMenu')) {
                                wp_nav_menu(array('theme_location' => 'mobileMenu', 'container' => ''));
                            } else {
                                echo "<p>جایگاه فهرست موبایل سایت (در بخش فهرست ها، یک فهرست ایجاد کنید و به منو موبایل متصل کنید).</p>";
                            }
                            ?>
                        </nav>
                    </div>
                </div>

            </div>


            <div class="logo-header">

                <a href="<?php echo home_url(); ?>">
                    <?php if ($ultra_options['ultra-logo-img']['url']) { ?>
                        <img src="<?php echo $ultra_options['ultra-logo-img']['url'] ?>" alt=""/>
                    <?php }
                    if ($ultra_options['ultra-logo-check'] == 1) { ?>
                        <span><?php echo $ultra_options['ultra-logo-name'] ?></span>
                    <?php } ?>
                </a>
            </div>


            <div class="search-btn-menu-mobile">
                <svg width="22px" height="22px" viewBox="0 0 24 24" fill="none"
                     xmlns="http://www.w3.org/2000/svg">
                    <path d="M16.6725 16.6412L21 21M19 11C19 15.4183 15.4183 19 11 19C6.58172 19 3 15.4183 3 11C3 6.58172 6.58172 3 11 3C15.4183 3 19 6.58172 19 11Z"
                          stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>

        </div>
    </div>

</header>


<?php if ($ultra_options['choose_header'] == 1) { ?>
    <header class="main-header">
        <div class="container">
            <div class="head-content">


                <?php if ($ultra_options['on_off_up_menu_header1']) : ?>
                    <div class="up-header">
                        <div class="right-side">
                            <?php if ($ultra_options['bullet_switch']) { ?>
                                <div class="bullet-sec">
                                    <span class="bullet"></span>
                                </div>
                            <?php } ?>
                            <nav><?php echo $ultra_options['top_menu_right_header1']; ?></nav>
                        </div>
                        <div class="left-side">
                            <span><?php echo $ultra_options['top_menu_left_header1']; ?></span>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="top-header">
                    <div class="right-side">


                        <div class="logo-header">

                            <a href="<?php echo home_url(); ?>">
                                <?php if ($ultra_options['ultra-logo-img']['url']) { ?>
                                    <img src="<?php echo $ultra_options['ultra-logo-img']['url'] ?>" alt=""/>
                                <?php }
                                if ($ultra_options['ultra-logo-check'] == 1) { ?>
                                    <span><?php echo $ultra_options['ultra-logo-name'] ?></span>
                                <?php } ?>
                            </a>
                        </div>


                        <div class="search-form">
                            <form method="get" action="<?php echo home_url('/'); ?>">
                                <input name="s" id="desktop-keyword"
                                       onkeyup="if (this.value.length > 3) fetch('#desktop-keyword', '#desktop-datafetch')"
                                       value="<?php the_search_query(); ?>" type="search" placeholder="جستجو"/>
                                <button type="submit">
                                    <svg
                                            class="svg-icon"
                                            id="Search"
                                            width="24"
                                            height="24"
                                            viewBox="0 0 26 24"
                                            fill="none"
                                            xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                                fill-rule="evenodd"
                                                clip-rule="evenodd"
                                                d="M11.5254 3.46429C7.21107 3.46429 3.71448 6.96089 3.71448 11.2752C3.71448 15.5896 7.21107 19.0862 11.5254 19.0862C15.8389 19.0862 19.3364 15.5896 19.3364 11.2752C19.3364 6.96094 15.8389 3.46429 11.5254 3.46429ZM2.21448 11.2752C2.21448 6.13246 6.38264 1.96429 11.5254 1.96429C16.6672 1.96429 20.8364 6.13241 20.8364 11.2752C20.8364 16.4181 16.6672 20.5862 11.5254 20.5862C6.38264 20.5862 2.21448 16.418 2.21448 11.2752Z"
                                                fill="black"
                                        />
                                        <path
                                                fill-rule="evenodd"
                                                clip-rule="evenodd"
                                                d="M20.149 19.2376C19.7838 19.2376 19.4875 19.5346 19.4875 19.8981C19.4875 20.2636 19.7838 20.5595 20.149 20.5595C20.5135 20.5595 20.8095 20.2642 20.8095 19.8981C20.8095 19.5339 20.5135 19.2376 20.149 19.2376ZM17.9875 19.8981C17.9875 18.7055 18.956 17.7376 20.149 17.7376C21.3426 17.7376 22.3095 18.7061 22.3095 19.8981C22.3095 21.092 21.3426 22.0595 20.149 22.0595C18.956 22.0595 17.9875 21.0927 17.9875 19.8981Z"
                                                fill="black"
                                        />
                                    </svg>
                                </button>
                            </form>
                            <div class="loader-ajax-search">
                                <span class="loader"></span>
                            </div>
                            <div id="desktop-datafetch" class="content-ajax-search"></div>
                        </div>
                    </div>


                    <?php if ($ultra_options['text_tel_header']) : ?>
                        <div class="support-side">
                            <div class="support-text">
                                <span><?php echo $ultra_options['text_tel_header']; ?></span>
                                <!--    Delete Space For Phone                -->
                                <a href="tel:<?php echo preg_replace('/\s+/', '', $ultra_options['number_tel_header']); ?>">
                                    <?php echo $ultra_options['number_tel_header']; ?>
                                </a>
                            </div>
                            <div class="supprot-icon">
                                <svg
                                        class="svg-icon"
                                        id="Call"
                                        width="24"
                                        height="24"
                                        viewBox="0 0 26 24"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                            d="M8.44994 15.7988C1.55294 8.89982 2.53294 5.74082 3.26094 4.72282C3.35394 4.55882 5.65594 1.11182 8.12494 3.13382C14.2509 8.17982 6.49494 7.46582 11.6389 12.6108C16.7849 17.7558 16.0709 9.99982 21.1159 16.1248C23.1379 18.5938 19.6909 20.8968 19.5279 20.9888C18.6369 21.6258 16.1059 22.4568 10.8649 18.0328"
                                            stroke="black"
                                            stroke-width="1.5"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                    />
                                </svg>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="middle-header">
                    <div class="menu-side">
                        <?php if ($ultra_options['active_mega_menu_header'] == 1): ?>
                            <nav class="ultra-megamenu">
                                <div class="title-megamenu">
                                    <?php if ($ultra_options['choose_icon_mega_menu_header'] == true) {
                                        echo '<i class="' . $ultra_options['icon_select_mega_menu'] . '"></i>';
                                    } else { ?>
                                        <svg
                                                class="svg-icon"
                                                id="Category"
                                                width="24"
                                                height="24"
                                                viewBox="0 0 24 24"
                                                fill="none"
                                                xmlns="http://www.w3.org/2000/svg"
                                        >
                                            <path
                                                    fill-rule="evenodd"
                                                    clip-rule="evenodd"
                                                    d="M3 6.5C3 3.87479 3.02811 3 6.5 3C9.97189 3 10 3.87479 10 6.5C10 9.12521 10.0111 10 6.5 10C2.98893 10 3 9.12521 3 6.5Z"
                                                    stroke="black"
                                                    stroke-width="1.5"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round"
                                            />
                                            <path
                                                    d="M17.5 10C21.0111 10 21 9.12521 21 6.5C21 3.87479 20.9719 3 17.5 3C14.0281 3 14 3.87479 14 6.5C14 7.83097 13.9972 8.712 14.4519 9.25721"
                                                    stroke="black"
                                                    stroke-width="1.5"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round"
                                            />
                                            <path
                                                    d="M6.5 14C3.02811 14 3 14.8748 3 17.5C3 20.1252 2.98893 21 6.5 21C10.0111 21 10 20.1252 10 17.5C10 16.361 9.99471 15.5515 9.70516 15"
                                                    stroke="black"
                                                    stroke-width="1.5"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round"
                                            />
                                            <path
                                                    fill-rule="evenodd"
                                                    clip-rule="evenodd"
                                                    d="M14 17.5C14 14.8748 14.0281 14 17.5 14C20.9719 14 21 14.8748 21 17.5C21 20.1252 21.0111 21 17.5 21C13.9889 21 14 20.1252 14 17.5Z"
                                                    stroke="black"
                                                    stroke-width="1.5"
                                                    stroke-linecap="round"
                                                    stroke-linejoin="round"
                                            />
                                        </svg>
                                    <?php } ?>
                                    <span><?php echo $ultra_options['title_mega_menu_header']; ?></span>
                                </div>

                                <div class="menu-section">
                                    <?php if (has_nav_menu('megaMenu')) {
                                        wp_nav_menu(array('theme_location' => 'megaMenu', 'container' => ''));
                                    } else {
                                        echo "<p>جایگاه فهرست مگامنو سایت (در بخش فهرست ها، یک فهرست ایجاد کنید و به مگامنو متصل کنید).</p>";
                                    }
                                    ?>
                                </div>
                            </nav>
                        <?php endif;
                        if ($ultra_options['active_main_menu_header']):?>
                            <nav class="main-menu">
                                <?php if (has_nav_menu('mainMenu')) {
                                    wp_nav_menu(array('theme_location' => 'mainMenu', 'container' => ''));
                                } else {
                                    echo "<p>جایگاه فهرست اصلی سایت (در بخش فهرست ها، یک فهرست ایجاد کنید و به منو موبایل متصل کنید).</p>";
                                }
                                ?>
                            </nav>
                        <?php endif; ?>
                    </div>


                    <div class="left-side">
                        <?php if ($ultra_options['active_wishlist_header'] && class_exists('WPCleverWoosw')) { ?>
                            <a href="<?php echo home_url('wishlist/'); ?>">
                                <svg
                                        class="svg-icon"
                                        id="Heart"
                                        width="24"
                                        height="24"
                                        viewBox="0 0 26 24"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                            d="M3.12319 12.4101C2.05019 9.06006 3.30519 4.89506 6.82219 3.76306C8.67219 3.16606 10.9552 3.66406 12.2522 5.45306C13.4752 3.59806 15.8242 3.17006 17.6722 3.76306C21.1882 4.89506 22.4502 9.06006 21.3782 12.4101C19.7082 17.7201 13.8812 20.4861 12.2522 20.4861C11.0412 20.4861 7.53719 18.9911 5.11119 16.0151"
                                            stroke="black"
                                            stroke-width="1.5"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                    />
                                    <path
                                            d="M15.9902 7.52771C17.1972 7.65171 17.9522 8.60871 17.9072 9.94971"
                                            stroke="black"
                                            stroke-width="1.5"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                    />
                                </svg>
                                <span>علاقه‌مندی‌ها</span>
                            </a>
                        <?php } else { ?>
                            <a href="<?php echo $ultra_options['link_custom_btn_header']; ?>">
                                <i class="<?php echo $ultra_options['icon_custom_btn_header']; ?>"></i>
                                <span><?php echo $ultra_options['title_custom_btn_header']; ?></span>
                            </a>
                        <?php } ?>

                        <div class="btn-sec">
                            <?php if ($ultra_options['active_cart_header'] == 1): ?>
                                <div class="cart-content-box">
                                    <?php if (class_exists('WooCommerce')) { ?>
                                        <a href="<?php echo wc_get_cart_url(); ?>" class="mini-cart">
                                            <svg
                                                    class="svg-icon"
                                                    id="Buy"
                                                    width="24"
                                                    height="24"
                                                    viewBox="0 0 25 25"
                                                    fill="none"
                                                    xmlns="http://www.w3.org/2000/svg"
                                            >
                                                <path
                                                        d="M9.25701 7.17664C11.567 7.06764 14.735 6.80164 15.808 6.78764C16.833 6.77464 17.943 6.64064 18.906 7.07364C22.209 8.56064 20.816 14.5356 18.533 16.3096C16.942 17.5456 14.398 17.6376 12.467 17.5876C10.675 17.5426 8.51301 17.3376 7.00501 16.2636C4.40601 14.4126 5.76401 9.36864 5.67901 5.91964C5.73001 3.98964 3.63501 3.67664 3.63501 3.67664"
                                                        stroke="black"
                                                        stroke-width="1.5"
                                                        stroke-linecap="round"
                                                        stroke-linejoin="round"
                                                />
                                                <path
                                                        d="M13.135 10.6766H15.908"
                                                        stroke="black"
                                                        stroke-width="1.5"
                                                        stroke-linecap="round"
                                                        stroke-linejoin="round"
                                                />
                                                <path
                                                        fill-rule="evenodd"
                                                        clip-rule="evenodd"
                                                        d="M7.39876 20.3036C7.69876 20.3036 7.94276 20.5476 7.94276 20.8476C7.94276 21.1486 7.69876 21.3926 7.39876 21.3926C7.09776 21.3926 6.85376 21.1486 6.85376 20.8476C6.85376 20.5476 7.09776 20.3036 7.39876 20.3036"
                                                        fill="black"
                                                />
                                                <path
                                                        fill-rule="evenodd"
                                                        clip-rule="evenodd"
                                                        d="M7.39876 20.3036C7.69876 20.3036 7.94276 20.5476 7.94276 20.8476C7.94276 21.1486 7.69876 21.3926 7.39876 21.3926C7.09776 21.3926 6.85376 21.1486 6.85376 20.8476C6.85376 20.5476 7.09776 20.3036 7.39876 20.3036Z"
                                                        stroke="black"
                                                        stroke-width="1.5"
                                                        stroke-linecap="round"
                                                        stroke-linejoin="round"
                                                />
                                                <path
                                                        fill-rule="evenodd"
                                                        clip-rule="evenodd"
                                                        d="M17.7298 20.3036C18.0308 20.3036 18.2748 20.5476 18.2748 20.8476C18.2748 21.1486 18.0308 21.3926 17.7298 21.3926C17.4298 21.3926 17.1858 21.1486 17.1858 20.8476C17.1858 20.5476 17.4298 20.3036 17.7298 20.3036"
                                                        fill="black"
                                                />
                                                <path
                                                        fill-rule="evenodd"
                                                        clip-rule="evenodd"
                                                        d="M17.7298 20.3036C18.0308 20.3036 18.2748 20.5476 18.2748 20.8476C18.2748 21.1486 18.0308 21.3926 17.7298 21.3926C17.4298 21.3926 17.1858 21.1486 17.1858 20.8476C17.1858 20.5476 17.4298 20.3036 17.7298 20.3036Z"
                                                        stroke="black"
                                                        stroke-width="1.5"
                                                        stroke-linecap="round"
                                                        stroke-linejoin="round"
                                                />
                                            </svg>
                                            <span>سبد خرید</span>
                                            <span class="number-cart"><?php echo wc()->cart->get_cart_contents_count(); ?></span>
                                            <div class="cart-content">
                                                <?php woocommerce_mini_cart(); ?>
                                            </div>
                                        </a>
                                    <?php } else {
                                        echo 'برای نمایش سبد خرید افزونه ووکامرس را نصب کنید.';
                                    } ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php
                        global $current_user;
                        if (is_user_logged_in()) :
                            ?>
                            <a href="<?php echo home_url('my-account/') ?>">
                                <svg
                                        class="svg-icon"
                                        id="Profile"
                                        width="24"
                                        height="24"
                                        viewBox="0 0 26 24"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                            d="M12.25 21.829C8.43598 21.829 5.17798 21.252 5.17798 18.942C5.17798 16.632 8.41498 14.531 12.25 14.531C16.064 14.531 19.322 16.612 19.322 18.921C19.322 20.547 17.716 21.325 15.427 21.643"
                                            stroke="black"
                                            stroke-width="1.5"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                    />
                                    <path
                                            d="M12.2496 2.17102C9.74658 2.17102 7.71658 4.20002 7.71658 6.70402C7.70758 9.19802 9.72358 11.228 12.2176 11.237H12.2496C14.7526 11.237 16.7826 9.20702 16.7826 6.70402C16.7826 5.20602 16.0566 3.87802 14.9366 3.05302"
                                            stroke="black"
                                            stroke-width="1.5"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                    />
                                </svg>
                                <span class="user-act"><?php echo $current_user->display_name; ?></span>
                            </a>
                        <?php else: ?>
                            <a href="<?php echo home_url('my-account/') ?>">
                                <svg
                                        class="svg-icon"
                                        id="Profile"
                                        width="24"
                                        height="24"
                                        viewBox="0 0 26 24"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                            d="M12.25 21.829C8.43598 21.829 5.17798 21.252 5.17798 18.942C5.17798 16.632 8.41498 14.531 12.25 14.531C16.064 14.531 19.322 16.612 19.322 18.921C19.322 20.547 17.716 21.325 15.427 21.643"
                                            stroke="black"
                                            stroke-width="1.5"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                    />
                                    <path
                                            d="M12.2496 2.17102C9.74658 2.17102 7.71658 4.20002 7.71658 6.70402C7.70758 9.19802 9.72358 11.228 12.2176 11.237H12.2496C14.7526 11.237 16.7826 9.20702 16.7826 6.70402C16.7826 5.20602 16.0566 3.87802 14.9366 3.05302"
                                            stroke="black"
                                            stroke-width="1.5"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                    />
                                </svg>
                                <span class="user-act">ورود | ثبت نام</span>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </header>
<?php }
if ($ultra_options['choose_header'] == 2) { ?>
    <header class="main-header-2">
        <div class="container">

            <?php if ($ultra_options['on_off_up_menu_header_two']) : ?>
                <div class="top-header">
                    <div class="num-sec">
                        <i class="fa-solid fa-headset"></i>
                        <a href="tel:<?php echo $ultra_options['top_menu_right_header2']; ?>">
                            <?php echo $ultra_options['top_menu_right_header2']; ?>
                        </a>
                    </div>

                    <div class="social-sec">
                        <?php if (isset($ultra_options['contact_instagram_header2'])) { ?>
                            <a href="<?php echo $ultra_options['contact_instagram_header2']; ?>">
                                <i class="fa-brands fa-instagram"></i>
                            </a>
                        <?php }
                        if ($ultra_options['contact_whatsup_header2']) { ?>
                            <a href="<?php echo $ultra_options['contact_whatsup_header2']; ?>">
                                <i class="fa-brands fa-whatsapp"></i>
                            </a>
                        <?php }
                        if ($ultra_options['contact_telegram_header2']) { ?>
                            <a href="<?php echo $ultra_options['contact_telegram_header2']; ?>">
                                <i class="fa-brands fa-telegram"></i>
                            </a>
                        <?php } ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="mid-header">
                <div class="logo-sec">
                    <a href="<?php echo home_url(); ?>">
                        <?php if ($ultra_options['ultra-logo-img']['url']) { ?>
                            <img src="<?php echo $ultra_options['ultra-logo-img']['url'] ?>" alt=""/>
                        <?php }
                        if ($ultra_options['ultra-logo-check'] == 1) { ?>
                            <span><?php echo $ultra_options['ultra-logo-name'] ?></span>
                        <?php } ?>
                    </a>
                </div>

                <div class="menu-sec">
                    <?php if (isset($ultra_options['choose_mega_menu']) && (int)$ultra_options['choose_mega_menu'] === 1) : ?>
                        <nav class="main-ultra-menu">
                            <?php if (has_nav_menu('megaMenu')) {
                                wp_nav_menu(array('theme_location' => 'megaMenu', 'container' => ''));
                            } else {
                                echo "<p>جایگاه فهرست مگامنو سایت (در بخش فهرست ها، یک فهرست ایجاد کنید و به مگامنو متصل کنید).</p>";
                            } ?>
                        </nav>
                    <?php else : ?>
                        <nav class="usual-menu-ultra">
                            <?php if (has_nav_menu('mainMenu')) {
                                wp_nav_menu(array('theme_location' => 'mainMenu', 'container' => ''));
                            } else {
                                echo "<p>جایگاه فهرست اصلی سایت (در بخش فهرست ها، یک فهرست ایجاد کنید و به منو موبایل متصل کنید).</p>";
                            } ?>
                        </nav>
                    <?php endif; ?>

                </div>

                <div class="btn-sec">
                    <?php if ($ultra_options['active_cart_header'] == 1): ?>
                        <div class="cart-content-box">
                            <?php if (class_exists('WooCommerce')) { ?>
                                <a href="<?php echo wc_get_cart_url(); ?>" class="mini-cart">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px"
                                         viewBox="0 0 512 512">
                                        <title>سبد خرید شما</title>
                                        <path d="M68.4,192A20.38,20.38,0,0,0,48,212.2a17.87,17.87,0,0,0,.8,5.5L100.5,400a40.46,40.46,0,0,0,39.1,29.5H372.4A40.88,40.88,0,0,0,411.7,400l51.7-182.3.6-5.5A20.38,20.38,0,0,0,443.6,192H68.4ZM261.72,352.07A42.07,42.07,0,1,1,304,310,42.27,42.27,0,0,1,261.72,352.07Z"
                                              style="fill:none;stroke:#000000;stroke-linejoin:round;stroke-width:32px"/>
                                        <polyline points="160 192 256 64 352 192"
                                                  style="fill:none;stroke:#000000;stroke-linejoin:round;stroke-width:32px"/>
                                    </svg>
                                    <span class="number-cart"><?php echo wc()->cart->get_cart_contents_count(); ?></span>
                                    <div class="cart-content">
                                        <?php woocommerce_mini_cart(); ?>
                                    </div>
                                </a>
                            <?php } else {
                                echo 'برای نمایش سبد خرید افزونه ووکامرس را نصب کنید.';
                            } ?>
                        </div>
                    <?php endif; ?>
                    <!--                    <a class="ultra-cart" href="#">-->
                    <!--                        <span class="cart-num">2</span>-->
                    <!--                    </a>-->
                    <?php if (isset($ultra_options['active_wishlist_header2']) && $ultra_options['active_wishlist_header2'] && class_exists('WPCleverWoosw')) { ?>
                        <a href="<?php echo home_url('wishlist/'); ?>">
                            <svg id="Heart" width="24" height="24" viewBox="0 0 26 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path d="M3.12319 12.4101C2.05019 9.06006 3.30519 4.89506 6.82219 3.76306C8.67219 3.16606 10.9552 3.66406 12.2522 5.45306C13.4752 3.59806 15.8242 3.17006 17.6722 3.76306C21.1882 4.89506 22.4502 9.06006 21.3782 12.4101C19.7082 17.7201 13.8812 20.4861 12.2522 20.4861C11.0412 20.4861 7.53719 18.9911 5.11119 16.0151"
                                      stroke="black" stroke-width="1.5" stroke-linecap="round"
                                      stroke-linejoin="round"></path>
                                <path d="M15.9902 7.52771C17.1972 7.65171 17.9522 8.60871 17.9072 9.94971"
                                      stroke="black"
                                      stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                        </a>
                    <?php } ?>
                    <a id="searchbtn">
                        <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24"
                             fill="none">
                            <path d="M11 6C13.7614 6 16 8.23858 16 11M16.6588 16.6549L21 21M19 11C19 15.4183 15.4183 19 11 19C6.58172 19 3 15.4183 3 11C3 6.58172 6.58172 3 11 3C15.4183 3 19 6.58172 19 11Z"
                                  stroke="#000000" stroke-width="2" stroke-linecap="round"
                                  stroke-linejoin="round"/>
                        </svg>
                    </a>
                    <form id="headersearch" method="get" action="<?php echo home_url('/'); ?>">
                        <span class="searchclose">&#10006;</span>
                        <input name="s" id="desktop-keyword"
                               onkeyup="if (this.value.length > 3) fetch('#desktop-keyword', '#desktop-datafetch')"
                               value="<?php the_search_query(); ?>" type="search" placeholder="جستجو"/>
                        <button type="submit">
                            <svg
                                    class="svg-icon"
                                    id="Search"
                                    width="24"
                                    height="24"
                                    viewBox="0 0 26 24"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                        fill-rule="evenodd"
                                        clip-rule="evenodd"
                                        d="M11.5254 3.46429C7.21107 3.46429 3.71448 6.96089 3.71448 11.2752C3.71448 15.5896 7.21107 19.0862 11.5254 19.0862C15.8389 19.0862 19.3364 15.5896 19.3364 11.2752C19.3364 6.96094 15.8389 3.46429 11.5254 3.46429ZM2.21448 11.2752C2.21448 6.13246 6.38264 1.96429 11.5254 1.96429C16.6672 1.96429 20.8364 6.13241 20.8364 11.2752C20.8364 16.4181 16.6672 20.5862 11.5254 20.5862C6.38264 20.5862 2.21448 16.418 2.21448 11.2752Z"
                                        fill="black"
                                />
                                <path
                                        fill-rule="evenodd"
                                        clip-rule="evenodd"
                                        d="M20.149 19.2376C19.7838 19.2376 19.4875 19.5346 19.4875 19.8981C19.4875 20.2636 19.7838 20.5595 20.149 20.5595C20.5135 20.5595 20.8095 20.2642 20.8095 19.8981C20.8095 19.5339 20.5135 19.2376 20.149 19.2376ZM17.9875 19.8981C17.9875 18.7055 18.956 17.7376 20.149 17.7376C21.3426 17.7376 22.3095 18.7061 22.3095 19.8981C22.3095 21.092 21.3426 22.0595 20.149 22.0595C18.956 22.0595 17.9875 21.0927 17.9875 19.8981Z"
                                        fill="black"
                                />
                            </svg>
                        </button>
                    </form>
                    <div class="loader-ajax-search">
                        <span class="loader"></span>
                    </div>
                    <div id="desktop-datafetch" class="content-ajax-search"></div>

                    <div class="user logined">
                        <?php global $current_user;
                        if (is_user_logged_in()) :
                            ?>
                            <a href="<?php echo home_url('my-account/') ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24"
                                     fill="none">
                                    <path d="M14 19.2857L15.8 21L20 17M16.5 14.4018C16.2052 14.2315 15.8784 14.1098 15.5303 14.0472C15.4548 14.0337 15.3748 14.024 15.2842 14.0171C15.059 14 14.9464 13.9915 14.7961 14.0027C14.6399 14.0143 14.5527 14.0297 14.4019 14.0723C14.2569 14.1132 13.9957 14.2315 13.4732 14.4682C12.7191 14.8098 11.8817 15 11 15C10.1183 15 9.28093 14.8098 8.52682 14.4682C8.00429 14.2315 7.74302 14.1131 7.59797 14.0722C7.4472 14.0297 7.35983 14.0143 7.20361 14.0026C7.05331 13.9914 6.94079 14 6.71575 14.0172C6.6237 14.0242 6.5425 14.0341 6.46558 14.048C5.23442 14.2709 4.27087 15.2344 4.04798 16.4656C4 16.7306 4 17.0485 4 17.6841V19.4C4 19.9601 4 20.2401 4.10899 20.454C4.20487 20.6422 4.35785 20.7951 4.54601 20.891C4.75992 21 5.03995 21 5.6 21H10.5M15 7C15 9.20914 13.2091 11 11 11C8.79086 11 7 9.20914 7 7C7 4.79086 8.79086 3 11 3C13.2091 3 15 4.79086 15 7Z"
                                          stroke="#000000" stroke-width="2" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                </svg>
                            </a>
                            <?php
                            $current_user = wp_get_current_user();
                            $user_name = $current_user->display_name; // نام کاربر
                            $user_panel_url = get_permalink(get_option('woocommerce_myaccount_page_id')); // لینک پنل کاربری
                            $logout_url = wp_logout_url(home_url()); // لینک خروج
                            $orders_url = wc_get_endpoint_url('orders', '', $user_panel_url); // لینک سفارشات
                            ?>
                            <ul class="user-login-info">
                                <li>
                                    <a href="#">
                                        <span><?php echo esc_html($user_name); ?></span>
                                        <i class="fa-solid fa-user"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo esc_url($user_panel_url); ?>">
                                        <span>مشاهده پنل کاربری</span>
                                        <i class="fa-solid fa-arrow-left-long"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo esc_url($orders_url); ?>">
                                        <span>سفارشات من</span>
                                        <i class="fa-solid fa-cart-shopping"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo esc_url($logout_url); ?>">
                                        <span>خروج</span>
                                        <i class="fa-solid fa-right-from-bracket"></i>
                                    </a>
                                </li>
                            </ul>
                        <?php else: ?>
                            <a href="<?php echo home_url('my-account/') ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24"
                                     fill="none">
                                    <path d="M19 18.0039V17C19 15.8954 18.1046 15 17 15C15.8954 15 15 15.8954 15 17V18.0039M4 21C4 17.134 7.13401 14 11 14C11.3395 14 11.6734 14.0242 12 14.0709M15.5 21H18.5C18.9659 21 19.1989 21 19.3827 20.9239C19.6277 20.8224 19.8224 20.6277 19.9239 20.3827C20 20.1989 20 19.9659 20 19.5C20 19.0341 20 18.8011 19.9239 18.6173C19.8224 18.3723 19.6277 18.1776 19.3827 18.0761C19.1989 18 18.9659 18 18.5 18H15.5C15.0341 18 14.8011 18 14.6173 18.0761C14.3723 18.1776 14.1776 18.3723 14.0761 18.6173C14 18.8011 14 19.0341 14 19.5C14 19.9659 14 20.1989 14.0761 20.3827C14.1776 20.6277 14.3723 20.8224 14.6173 20.9239C14.8011 21 15.0341 21 15.5 21ZM15 7C15 9.20914 13.2091 11 11 11C8.79086 11 7 9.20914 7 7C7 4.79086 8.79086 3 11 3C13.2091 3 15 4.79086 15 7Z"
                                          stroke="#000000" stroke-width="2" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

        </div>
    </header>
    <?php
}
if ($ultra_options['choose_header'] == 3) { ?>
    <div class="container">
        <header class="main-header-3">


            <div class="right-side">
                <div class="logo-sec">
                    <a href="<?php echo home_url(); ?>">
                        <?php if ($ultra_options['ultra-logo-img']['url']) { ?>
                            <img src="<?php echo $ultra_options['ultra-logo-img']['url'] ?>" alt=""/>
                        <?php }
                        if ($ultra_options['ultra-logo-check'] == 1) { ?>
                            <span><?php echo $ultra_options['ultra-logo-name'] ?></span>
                        <?php } ?>
                    </a>
                </div>
                <nav class="menu-sec">
                    <?php if (has_nav_menu('mainMenu')) {
                        wp_nav_menu(array('theme_location' => 'mainMenu', 'container' => ''));
                    } else {
                        echo "<p>جایگاه فهرست اصلی سایت (در بخش فهرست ها، یک فهرست ایجاد کنید و به منو موبایل متصل کنید).</p>";
                    }
                    ?>
                </nav>
            </div>

            <div class="left-side">
                <div class="btn-sec">
                    <a id="searchbtn">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink"
                             width="512" height="512" x="0" y="0" viewBox="0 0 24 24"
                             style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g>
                                <path d="M11.568 21.853c-5.652 0-10.25-4.598-10.25-10.25s4.598-10.25 10.25-10.25 10.25 4.598 10.25 10.25-4.598 10.25-10.25 10.25zm0-19c-4.825 0-8.75 3.924-8.75 8.75s3.925 8.75 8.75 8.75 8.75-3.925 8.75-8.75-3.924-8.75-8.75-8.75z"
                                      fill="#484848" opacity="1" data-original="#000000"></path>
                                <path d="M22.068 22.853a.744.744 0 0 1-.53-.22l-2-2a.75.75 0 1 1 1.061-1.061l2 2a.75.75 0 0 1-.53 1.281z"
                                      fill="#484848" opacity="1" data-original="#000000"></path>
                            </g></svg>
                    </a>
                    <form id="headersearch" method="get" action="<?php echo home_url('/'); ?>">
                        <span class="searchclose">&#10006;</span>
                        <input name="s" id="desktop-keyword"
                               onkeyup="if (this.value.length > 3) fetch('#desktop-keyword', '#desktop-datafetch')"
                               value="<?php the_search_query(); ?>" type="search" placeholder="جستجو"/>
                        <button type="submit">
                            <svg
                                    class="svg-icon"
                                    id="Search"
                                    width="24"
                                    height="24"
                                    viewBox="0 0 26 24"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                        fill-rule="evenodd"
                                        clip-rule="evenodd"
                                        d="M11.5254 3.46429C7.21107 3.46429 3.71448 6.96089 3.71448 11.2752C3.71448 15.5896 7.21107 19.0862 11.5254 19.0862C15.8389 19.0862 19.3364 15.5896 19.3364 11.2752C19.3364 6.96094 15.8389 3.46429 11.5254 3.46429ZM2.21448 11.2752C2.21448 6.13246 6.38264 1.96429 11.5254 1.96429C16.6672 1.96429 20.8364 6.13241 20.8364 11.2752C20.8364 16.4181 16.6672 20.5862 11.5254 20.5862C6.38264 20.5862 2.21448 16.418 2.21448 11.2752Z"
                                        fill="black"
                                />
                                <path
                                        fill-rule="evenodd"
                                        clip-rule="evenodd"
                                        d="M20.149 19.2376C19.7838 19.2376 19.4875 19.5346 19.4875 19.8981C19.4875 20.2636 19.7838 20.5595 20.149 20.5595C20.5135 20.5595 20.8095 20.2642 20.8095 19.8981C20.8095 19.5339 20.5135 19.2376 20.149 19.2376ZM17.9875 19.8981C17.9875 18.7055 18.956 17.7376 20.149 17.7376C21.3426 17.7376 22.3095 18.7061 22.3095 19.8981C22.3095 21.092 21.3426 22.0595 20.149 22.0595C18.956 22.0595 17.9875 21.0927 17.9875 19.8981Z"
                                        fill="black"
                                />
                            </svg>
                        </button>
                    </form>
                    <div class="loader-ajax-search">
                        <span class="loader"></span>
                    </div>
                    <div id="desktop-datafetch" class="content-ajax-search"></div>
                    <?php if ($ultra_options['active_cart_header'] == 1): ?>
                        <div class="cart-content-box">
                            <?php if (class_exists('WooCommerce')) { ?>
                                <a href="<?php echo wc_get_cart_url(); ?>" class="mini-cart">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                         width="100"
                                         height="100" x="0" y="0" viewBox="0 0 128 128"
                                         style="enable-background:new 0 0 512 512"
                                         xml:space="preserve" class="">  <g>
                                            <path d="m87.7 33.1-.8-10.8C86 10.4 76 1 64 1s-22.1 9.4-22.9 21.3l-.8 10.8H28.8c-4.7 0-8.6 3.7-9 8.4l-5.4 75.9c-.2 2.5.7 5 2.4 6.8s4.1 2.9 6.6 2.9h81.3c2.5 0 4.9-1 6.6-2.9 1.7-1.8 2.6-4.3 2.4-6.8l-5.4-75.2c-.4-5.1-4.6-9-9.7-9H87.7zM47.1 22.7C47.7 13.9 55.1 7 64 7s16.3 6.9 16.9 15.7l.7 10.4H46.3zm55.2 19.9 5.4 75.2c.1.8-.2 1.6-.8 2.3-.6.6-1.4 1-2.2 1H23.4c-.8 0-1.6-.3-2.2-1s-.9-1.4-.8-2.3l5.4-75.9c.1-1.6 1.4-2.8 3-2.8h11.1l-.6 8c-.1 1.7 1.1 3.1 2.8 3.2h.2c1.6 0 2.9-1.2 3-2.8l.6-8.4h36.2l.6 8.4c.1 1.7 1.5 2.9 3.2 2.8s2.9-1.5 2.8-3.2l-.6-8h10.5c1.9 0 3.5 1.5 3.7 3.5z"
                                                  fill="#484848" opacity="1" data-original="#000000" class=""></path>
                                        </g></svg>
                                    <span class="number-cart"><?php echo wc()->cart->get_cart_contents_count(); ?></span>
                                    <div class="cart-content">
                                        <?php woocommerce_mini_cart(); ?>
                                    </div>
                                </a>
                            <?php } else {
                                echo 'برای نمایش سبد خرید افزونه ووکامرس را نصب کنید.';
                            } ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="reg-login">
                    <?php global $current_user;
                    if (is_user_logged_in()) :
                        ?>
                        <a href="<?php echo home_url('my-account/') ?>">
                            <?php $current_user = wp_get_current_user();
                            $user_name = $current_user->display_name; ?>
                            <span><?php echo esc_html($user_name); ?></span>
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                 id="Layer_1"
                                 x="0px" y="0px" viewBox="0 0 500 500" style="enable-background:new 0 0 500 500;"
                                 xml:space="preserve"><style type="text/css">    .st0 {
                                        fill: #fff;
                                    }</style>
                                <g>
                                    <g>
                                        <path class="st0"
                                              d="M188.7,474c28.5,0,51.5,0,69.5-2.4c18.8-2.5,34.5-7.9,47.1-20.4c10.9-10.9,16.5-24.4,19.4-40.2    c2.8-15.4,3.4-34.1,3.5-56.7c0-8.6-6.9-15.7-15.5-15.7c-8.6,0-15.7,6.9-15.7,15.5c-0.1,22.8-0.7,38.9-3,51.2    c-2.2,11.8-5.7,18.6-10.7,23.7c-5.8,5.8-13.9,9.5-29.2,11.6c-15.7,2.1-36.6,2.1-66.5,2.1h-20.8c-29.9,0-50.8,0-66.5-2.1    c-15.3-2.1-23.4-5.8-29.2-11.6s-9.5-13.9-11.6-29.2c-2.1-15.7-2.1-36.6-2.1-66.5V166.7c0-29.9,0-50.8,2.1-66.5    C61.5,84.9,65.3,76.8,71,71c5.8-5.8,13.9-9.5,29.1-11.6c15.7-2.1,36.6-2.1,66.5-2.1h20.8c29.9,0,50.8,0,66.5,2.1    c15.3,2.1,23.4,5.8,29.1,11.6c5.1,5.1,8.5,11.9,10.7,23.7c2.2,12.3,2.8,28.4,3,51.2c0,8.6,7.1,15.6,15.7,15.5    c8.6,0,15.6-7.1,15.5-15.7c-0.1-22.5-0.7-41.3-3.5-56.7c-2.9-15.8-8.4-29.2-19.4-40.2c-12.5-12.5-28.3-17.9-47.1-20.5    c-18-2.4-41-2.4-69.5-2.4h-23.1c-28.5,0-51.5,0-69.5,2.4C77.3,31,61.5,36.4,48.9,48.9C36.4,61.5,31,77.2,28.5,96    c-2.4,18.1-2.4,41-2.4,69.5v169c0,28.5,0,51.5,2.4,69.5c2.5,18.8,7.9,34.5,20.5,47.1C61.5,463.6,77.3,469,96,471.5    c18.1,2.4,41,2.4,69.5,2.4L188.7,474z"></path>
                                        <path class="st0"
                                              d="M458.3,265.6c8.6,0,15.6-7,15.6-15.6c0-8.6-7-15.6-15.6-15.6H208.9l40.9-35c6.6-5.6,7.3-15.5,1.7-22    c-5.6-6.6-15.5-7.3-22-1.7l0,0l-72.9,62.5c-6.6,5.6-7.3,15.5-1.7,22c0.5,0.6,1.1,1.2,1.7,1.7l72.9,62.5c6.6,5.6,16.4,4.9,22-1.7    c5.6-6.6,4.9-16.4-1.7-22l0,0l-40.8-35H458.3z"></path>
                                    </g>
                                </g></svg>
                        </a>
                    <?php else: ?>
                        <a href="<?php echo home_url('my-account/') ?>">
                            <span>ورود | ثبت نام</span>
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                 id="Layer_1"
                                 x="0px" y="0px" viewBox="0 0 500 500" style="enable-background:new 0 0 500 500;"
                                 xml:space="preserve"><style type="text/css">    .st0 {
                                        fill: #fff;
                                    }</style>
                                <g>
                                    <g>
                                        <path class="st0"
                                              d="M188.7,474c28.5,0,51.5,0,69.5-2.4c18.8-2.5,34.5-7.9,47.1-20.4c10.9-10.9,16.5-24.4,19.4-40.2    c2.8-15.4,3.4-34.1,3.5-56.7c0-8.6-6.9-15.7-15.5-15.7c-8.6,0-15.7,6.9-15.7,15.5c-0.1,22.8-0.7,38.9-3,51.2    c-2.2,11.8-5.7,18.6-10.7,23.7c-5.8,5.8-13.9,9.5-29.2,11.6c-15.7,2.1-36.6,2.1-66.5,2.1h-20.8c-29.9,0-50.8,0-66.5-2.1    c-15.3-2.1-23.4-5.8-29.2-11.6s-9.5-13.9-11.6-29.2c-2.1-15.7-2.1-36.6-2.1-66.5V166.7c0-29.9,0-50.8,2.1-66.5    C61.5,84.9,65.3,76.8,71,71c5.8-5.8,13.9-9.5,29.1-11.6c15.7-2.1,36.6-2.1,66.5-2.1h20.8c29.9,0,50.8,0,66.5,2.1    c15.3,2.1,23.4,5.8,29.1,11.6c5.1,5.1,8.5,11.9,10.7,23.7c2.2,12.3,2.8,28.4,3,51.2c0,8.6,7.1,15.6,15.7,15.5    c8.6,0,15.6-7.1,15.5-15.7c-0.1-22.5-0.7-41.3-3.5-56.7c-2.9-15.8-8.4-29.2-19.4-40.2c-12.5-12.5-28.3-17.9-47.1-20.5    c-18-2.4-41-2.4-69.5-2.4h-23.1c-28.5,0-51.5,0-69.5,2.4C77.3,31,61.5,36.4,48.9,48.9C36.4,61.5,31,77.2,28.5,96    c-2.4,18.1-2.4,41-2.4,69.5v169c0,28.5,0,51.5,2.4,69.5c2.5,18.8,7.9,34.5,20.5,47.1C61.5,463.6,77.3,469,96,471.5    c18.1,2.4,41,2.4,69.5,2.4L188.7,474z"></path>
                                        <path class="st0"
                                              d="M458.3,265.6c8.6,0,15.6-7,15.6-15.6c0-8.6-7-15.6-15.6-15.6H208.9l40.9-35c6.6-5.6,7.3-15.5,1.7-22    c-5.6-6.6-15.5-7.3-22-1.7l0,0l-72.9,62.5c-6.6,5.6-7.3,15.5-1.7,22c0.5,0.6,1.1,1.2,1.7,1.7l72.9,62.5c6.6,5.6,16.4,4.9,22-1.7    c5.6-6.6,4.9-16.4-1.7-22l0,0l-40.8-35H458.3z"></path>
                                    </g>
                                </g></svg>
                        </a>
                    <?php endif; ?>
                </div>
            </div>


        </header>
    </div>
<?php } ?>

<?php if ($ultra_options['choose_header'] == 4) { ?>

    <header class="ultra-header-type-4">

        <div class="top-header">

            <div class="container">

                <div class="right-side">
                
                        <?php if ($ultra_options['ultra-logo-img']['url']) { ?>
                            <a href="<?php echo home_url(); ?>" class="logo">
                                <figure>
                                    <img src="<?php echo $ultra_options['ultra-logo-img']['url'] ?>" alt=""/>
                                </figure>
                                <?php if ($ultra_options['ultra-logo-check'] == 1) { ?>
                                    <span><?php echo $ultra_options['ultra-logo-name'] ?></span>
                                <?php } ?>
                            </a>
                        <?php } ?>
              

                    <div class="search-box">
                        <form method="get" action="<?php echo home_url('/'); ?>">
                            <input name="s" id="desktop-keyword"
                                   onkeyup="if (this.value.length > 3) fetch('#desktop-keyword', '#desktop-datafetch')"
                                   value="<?php the_search_query(); ?>" type="search"
                                   placeholder="جستجوی نام کالا، برند ویا ..."/>
                            <button type="submit">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                     fill="none">
                                    <path d="M22 22L20 20M2 11.5C2 6.25329 6.25329 2 11.5 2C16.7467 2 21 6.25329 21 11.5C21 16.7467 16.7467 21 11.5 21C6.25329 21 2 16.7467 2 11.5Z"
                                          stroke="#28303F" stroke-width="1.5" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                </svg>
                            </button>
                        </form>
                        <div class="loader-ajax-search">
                            <span class="loader"></span>
                        </div>
                        <div id="desktop-datafetch" class="content-ajax-search"></div>
                    </div>
                </div>
                <div class="left-side">
                    <?php if ($ultra_options['active_cart_header'] == 1): ?>
                        
                            <?php if (class_exists('WooCommerce')) { ?>
                            <a class="cart-btn" href="<?php echo wc_get_cart_url(); ?>" >
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M11 20.5C11 21.3284 10.3284 22 9.5 22C8.67157 22 8 21.3284 8 20.5C8 19.6716 8.67157 19 9.5 19C10.3284 19 11 19.6716 11 20.5Z"
                                      stroke="#007AF4" stroke-width="1.5"/>
                                <path d="M20 20.5C20 21.3284 19.3284 22 18.5 22C17.6716 22 17 21.3284 17 20.5C17 19.6716 17.6716 19 18.5 19C19.3284 19 20 19.6716 20 20.5Z"
                                      stroke="#007AF4" stroke-width="1.5"/>
                                <path d="M6 4H18C20.2091 4 22 5.79086 22 8V13C22 15.2091 20.2091 17 18 17H10C7.79086 17 6 15.2091 6 13V4ZM6 4C6 2.89543 5.10457 2 4 2H2M6 8H21.5"
                                      stroke="#007AF4" stroke-width="1.5" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                            </svg>
                            </a>
                            <?php } else {
                                echo 'برای نمایش سبد خرید افزونه ووکامرس را نصب کنید.';
                            } 
                    
                    endif;
                    ?>
                    <?php
                    global $current_user;
                    if (is_user_logged_in()) :
                        ?>
                        <a class="login-btn" href="<?php echo home_url('my-account/') ?>">
                            <span class="user-act"><?php echo $current_user->display_name; ?></span>
                            <svg
                                    class="svg-icon"
                                    id="Profile"
                                    width="24"
                                    height="24"
                                    viewBox="0 0 26 24"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                        d="M12.25 21.829C8.43598 21.829 5.17798 21.252 5.17798 18.942C5.17798 16.632 8.41498 14.531 12.25 14.531C16.064 14.531 19.322 16.612 19.322 18.921C19.322 20.547 17.716 21.325 15.427 21.643"
                                        stroke="black"
                                        stroke-width="1.5"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                />
                                <path
                                        d="M12.2496 2.17102C9.74658 2.17102 7.71658 4.20002 7.71658 6.70402C7.70758 9.19802 9.72358 11.228 12.2176 11.237H12.2496C14.7526 11.237 16.7826 9.20702 16.7826 6.70402C16.7826 5.20602 16.0566 3.87802 14.9366 3.05302"
                                        stroke="black"
                                        stroke-width="1.5"
                                        stroke-linecap="round"
                                        stroke-linejoin="round"
                                />
                            </svg>
                        </a>
                    <?php else: ?>
                        <a href="<?php echo home_url('my-account/') ?>" class="login-btn">
                            <span>ورود / ثبت نام</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path d="M15 10L13.7071 11.2929C13.3166 11.6834 13.3166 12.3166 13.7071 12.7071L15 14M14 12L22 12M6 20C3.79086 20 2 18.2091 2 16V8C2 5.79086 3.79086 4 6 4M6 20C8.20914 20 10 18.2091 10 16V8C10 5.79086 8.20914 4 6 4M6 20H14C16.2091 20 18 18.2091 18 16M6 4H14C16.2091 4 18 5.79086 18 8"
                                      stroke="#343434" stroke-width="1.5" stroke-linecap="round"/>
                            </svg>
                        </a>
                    <?php endif; ?>
                </div>

            </div>

        </div>
        <div class="bottom-header container">

            <div class="menu-side">

                <div class="category-menu">
                    <div class="menu-name">
                        <?php if ($ultra_options['choose_icon_mega_menu_header'] == true) {
                            echo '<i class="' . $ultra_options['icon_select_mega_menu'] . '"></i>';
                        } else { ?>
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                <path d="M9.33317 4.00045C9.33317 3.26407 9.93012 2.66711 10.6665 2.66711H11.9998C12.7362 2.66711 13.3332 3.26407 13.3332 4.00045V5.33378C13.3332 6.07016 12.7362 6.66711 11.9998 6.66711H10.6665C9.93012 6.66711 9.33317 6.07016 9.33317 5.33378V4.00045Z"
                                      stroke="#343434" stroke-width="1.5"/>
                                <path d="M2.6665 10.6671C2.6665 9.93073 3.26346 9.33378 3.99984 9.33378H5.33317C6.06955 9.33378 6.6665 9.93073 6.6665 10.6671V12.0004C6.6665 12.7368 6.06955 13.3338 5.33317 13.3338H3.99984C3.26346 13.3338 2.6665 12.7368 2.6665 12.0004V10.6671Z"
                                      stroke="#343434" stroke-width="1.5"/>
                                <path d="M2.6665 4.00045C2.6665 3.26407 3.26346 2.66711 3.99984 2.66711H5.33317C6.06955 2.66711 6.6665 3.26407 6.6665 4.00045V5.33378C6.6665 6.07016 6.06955 6.66711 5.33317 6.66711H3.99984C3.26346 6.66711 2.6665 6.07016 2.6665 5.33378V4.00045Z"
                                      stroke="#343434" stroke-width="1.5"/>
                                <path d="M9.33317 10.6671C9.33317 9.93073 9.93012 9.33378 10.6665 9.33378H11.9998C12.7362 9.33378 13.3332 9.93073 13.3332 10.6671V12.0004C13.3332 12.7368 12.7362 13.3338 11.9998 13.3338H10.6665C9.93012 13.3338 9.33317 12.7368 9.33317 12.0004V10.6671Z"
                                      stroke="#343434" stroke-width="1.5"/>
                            </svg>
                        <?php } ?>
                        <span><?php echo $ultra_options['title_mega_menu_header']; ?></span>
                    </div>

                    <nav>
                        <?php if (has_nav_menu('megaMenu')) {
                            wp_nav_menu(array('theme_location' => 'megaMenu', 'container' => ''));
                        } else {
                            echo "<p>جایگاه فهرست مگامنو سایت (در بخش فهرست ها، یک فهرست ایجاد کنید و به مگامنو متصل کنید).</p>";
                        }
                        ?>
                    </nav>

                </div>

                <nav class="main-menu">
                    <?php if (has_nav_menu('mainMenu')) {
                        wp_nav_menu(array('theme_location' => 'mainMenu', 'container' => ''));
                    } else {
                        echo "<p>جایگاه فهرست اصلی سایت (در بخش فهرست ها، یک فهرست ایجاد کنید و به منو موبایل متصل کنید).</p>";
                    }
                    ?>
                </nav>

            </div>
            <?php if ( ! empty( $ultra_options['tel_header4'] ) || ! empty( $ultra_options['text_tel_header4'] ) ) :  ?>
            <div class="support-side">
                <a href="tel:<?php echo $ultra_options['tel_header4'];?>" class="support-text">
                    <span><?php echo $ultra_options['tel_header4'];?></span>
                    <span><?php echo $ultra_options['text_tel_header4'];?></span>
                </a>
                <figure>
                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
                        <path d="M13.75 14.6668L13.6029 15.4022C13.9346 15.4686 14.2696 15.3047 14.4208 15.0022L13.75 14.6668ZM7.33333 8.25012L6.99792 7.5793C6.69542 7.73056 6.53157 8.06556 6.5979 8.39721L7.33333 8.25012ZM7.65785 8.08786L7.99326 8.75869H7.99326L7.65785 8.08786ZM8.54016 5.7672L9.23652 5.48866L8.54016 5.7672ZM7.79431 3.90257L7.09796 4.18112L7.79431 3.90257ZM18.0975 14.2058L17.819 14.9022L18.0975 14.2058ZM16.2329 13.46L16.5115 12.7636H16.5115L16.2329 13.46ZM13.9123 14.3423L14.5831 14.6777V14.6777L13.9123 14.3423ZM14.8333 10.0835C14.8333 10.4977 15.1691 10.8335 15.5833 10.8335C15.9975 10.8335 16.3333 10.4977 16.3333 10.0835H14.8333ZM15.3042 8.68028L15.9971 8.39327L15.3042 8.68028ZM13.3198 6.6959L13.6069 6.00299L13.3198 6.6959ZM11.9167 5.66679C11.5025 5.66679 11.1667 6.00258 11.1667 6.41679C11.1667 6.831 11.5025 7.16679 11.9167 7.16679V5.66679ZM18.5 10.0835C18.5 10.4977 18.8358 10.8335 19.25 10.8335C19.6642 10.8335 20 10.4977 20 10.0835H18.5ZM18.6918 7.27711L19.3847 6.9901L18.6918 7.27711ZM14.723 3.30834L15.01 2.61543V2.61543L14.723 3.30834ZM11.9167 2.00012C11.5025 2.00012 11.1667 2.33591 11.1667 2.75012C11.1667 3.16434 11.5025 3.50012 11.9167 3.50012V2.00012ZM19.25 15.908H18.5V17.4168H19.25H20V15.908H19.25ZM4.58333 2.75012V3.50012H6.09211V2.75012V2.00012H4.58333V2.75012ZM13.75 14.6668C13.8971 13.9314 13.8973 13.9314 13.8975 13.9314C13.8976 13.9314 13.8978 13.9315 13.8979 13.9315C13.8981 13.9316 13.8983 13.9316 13.8984 13.9316C13.8988 13.9317 13.8989 13.9317 13.899 13.9317C13.8991 13.9318 13.8986 13.9317 13.8976 13.9315C13.8957 13.931 13.8916 13.9302 13.8855 13.9288C13.8733 13.9261 13.853 13.9215 13.8252 13.9148C13.7697 13.9012 13.6845 13.8792 13.5749 13.847C13.3554 13.7825 13.0402 13.6776 12.6704 13.5191C11.9275 13.2007 10.9856 12.675 10.1553 11.8448L9.625 12.3751L9.09467 12.9055C10.0978 13.9085 11.2183 14.5287 12.0796 14.8978C12.5119 15.0831 12.8841 15.2074 13.1517 15.2861C13.2856 15.3254 13.3938 15.3536 13.4707 15.3723C13.5092 15.3816 13.5399 15.3886 13.5621 15.3936C13.5733 15.396 13.5823 15.3979 13.5891 15.3994C13.5925 15.4001 13.5954 15.4007 13.5977 15.4012C13.5988 15.4014 13.5998 15.4016 13.6007 15.4018C13.6012 15.4019 13.6016 15.402 13.6019 15.402C13.6021 15.4021 13.6024 15.4021 13.6024 15.4021C13.6027 15.4022 13.6029 15.4022 13.75 14.6668ZM9.625 12.3751L10.1553 11.8448C9.32508 11.0145 8.79943 10.0726 8.48103 9.32968C8.32256 8.95994 8.21766 8.64468 8.15312 8.42522C8.12089 8.31565 8.09887 8.23047 8.08536 8.17491C8.07861 8.14714 8.07399 8.12683 8.07129 8.11462C8.06994 8.10851 8.06908 8.10444 8.06867 8.10248C8.06846 8.1015 8.06837 8.10105 8.06839 8.10114C8.0684 8.10118 8.06843 8.10136 8.0685 8.10168C8.06853 8.10184 8.06857 8.10203 8.06861 8.10225C8.06863 8.10237 8.06867 8.10256 8.06869 8.10262C8.06873 8.10282 8.06877 8.10303 7.33333 8.25012C6.5979 8.39721 6.59794 8.39744 6.59799 8.39768C6.59801 8.39777 6.59806 8.39802 6.5981 8.3982C6.59817 8.39857 6.59825 8.39897 6.59834 8.3994C6.59852 8.40027 6.59872 8.40129 6.59896 8.40244C6.59943 8.40475 6.60002 8.40761 6.60074 8.41102C6.60218 8.41785 6.60411 8.42687 6.60656 8.438C6.61148 8.46025 6.6185 8.49096 6.62786 8.52944C6.64657 8.60636 6.67468 8.71454 6.71407 8.84847C6.79275 9.11599 6.91702 9.48822 7.10231 9.92056C7.47141 10.7818 8.09159 11.9024 9.09467 12.9055L9.625 12.3751ZM7.33333 8.25012L7.66874 8.92094L7.99326 8.75869L7.65785 8.08786L7.32244 7.41704L6.99792 7.5793L7.33333 8.25012ZM8.54016 5.7672L9.23652 5.48866L8.49067 3.62403L7.79431 3.90257L7.09796 4.18112L7.84381 6.04574L8.54016 5.7672ZM18.0975 14.2058L18.3761 13.5095L16.5115 12.7636L16.2329 13.46L15.9544 14.1563L17.819 14.9022L18.0975 14.2058ZM13.9123 14.3423L13.2414 14.0069L13.0792 14.3314L13.75 14.6668L14.4208 15.0022L14.5831 14.6777L13.9123 14.3423ZM16.2329 13.46L16.5115 12.7636C15.264 12.2646 13.8423 12.8051 13.2414 14.0069L13.9123 14.3423L14.5831 14.6777C14.8351 14.1737 15.4313 13.9471 15.9544 14.1563L16.2329 13.46ZM7.65785 8.08786L7.99326 8.75869C9.19498 8.15783 9.73551 6.73612 9.23652 5.48866L8.54016 5.7672L7.84381 6.04574C8.05306 6.56887 7.82639 7.16507 7.32244 7.41704L7.65785 8.08786ZM6.09211 2.75012V3.50012C6.53509 3.50012 6.93344 3.76982 7.09796 4.18112L7.79431 3.90257L8.49067 3.62403C8.09836 2.64325 7.14844 2.00012 6.09211 2.00012V2.75012ZM19.25 15.908H20C20 14.8517 19.3569 13.9018 18.3761 13.5095L18.0975 14.2058L17.819 14.9022C18.2303 15.0667 18.5 15.465 18.5 15.908H19.25ZM17.4167 19.2501V18.5001C9.7307 18.5001 3.5 12.2694 3.5 4.58346H2.75H2C2 13.0978 8.90228 20.0001 17.4167 20.0001V19.2501ZM17.4167 19.2501V20.0001C18.8434 20.0001 20 18.8435 20 17.4168H19.25H18.5C18.5 18.0151 18.015 18.5001 17.4167 18.5001V19.2501ZM2.75 4.58346H3.5C3.5 3.98515 3.98502 3.50012 4.58333 3.50012V2.75012V2.00012C3.1566 2.00012 2 3.15672 2 4.58346H2.75ZM15.5833 10.0835H16.3333C16.3333 9.50345 16.2191 8.92913 15.9971 8.39327L15.3042 8.68028L14.6113 8.9673C14.7579 9.32116 14.8333 9.70043 14.8333 10.0835H15.5833ZM15.3042 8.68028L15.9971 8.39327C15.7752 7.85742 15.4498 7.37053 15.0397 6.9604L14.5094 7.49073L13.9791 8.02106C14.2499 8.2919 14.4647 8.61343 14.6113 8.9673L15.3042 8.68028ZM14.5094 7.49073L15.0397 6.9604C14.6296 6.55027 14.1427 6.22495 13.6069 6.00299L13.3198 6.6959L13.0328 7.38881C13.3867 7.53538 13.7082 7.75022 13.9791 8.02106L14.5094 7.49073ZM13.3198 6.6959L13.6069 6.00299C13.071 5.78103 12.4967 5.66679 11.9167 5.66679V6.41679V7.16679C12.2997 7.16679 12.679 7.24223 13.0328 7.38881L13.3198 6.6959ZM19.25 10.0835H20C20 9.02194 19.7909 7.97081 19.3847 6.9901L18.6918 7.27711L17.9989 7.56412C18.3297 8.36285 18.5 9.21892 18.5 10.0835H19.25ZM18.6918 7.27711L19.3847 6.9901C18.9785 6.00938 18.3831 5.11828 17.6324 4.36768L17.1021 4.89801L16.5718 5.42834C17.1831 6.03965 17.668 6.7654 17.9989 7.56412L18.6918 7.27711ZM17.1021 4.89801L17.6324 4.36768C16.8818 3.61707 15.9907 3.02165 15.01 2.61543L14.723 3.30834L14.436 4.00125C15.2347 4.33209 15.9605 4.81702 16.5718 5.42834L17.1021 4.89801ZM14.723 3.30834L15.01 2.61543C14.0293 2.2092 12.9782 2.00012 11.9167 2.00012V2.75012V3.50012C12.7812 3.50012 13.6373 3.6704 14.436 4.00125L14.723 3.30834Z"
                              fill="#343434"/>
                    </svg>
                </figure>
            </div>
            <?php endif; ?>
        </div>

    </header>

<?php }

?>
