<?php


$custom_footers = get_posts(array(
    'post_type' => 'ultra_footer',
    'post_status' => 'publish',
    'posts_per_page' => 1,
    'orderby' => 'date',
    'order' => 'DESC'
));

if (!is_singular('ultra_footer') && !empty($custom_footers)) {
    // اگر فوتر سفارشی وجود داره، فقط همونو نشون بده
    echo '<div class="custom-footer-wrapper">';
    echo \Elementor\Plugin::instance()->frontend->get_builder_content($custom_footers[0]->ID);
    echo '</div>';
} else {
    ?>


    <footer>
        <div class="container footer-section">
            <div class="footer-content">

                <?php if (is_active_sidebar('ultra_footer1')) { ?>
                    <div class="col-ultra">
                        <?php dynamic_sidebar('ultra_footer1'); ?>
                    </div>

                <?php }
                if (is_active_sidebar('ultra_footer2')) {
                    ?>
                    <div class="col-ultra"> <?php
                        dynamic_sidebar('ultra_footer2'); ?> </div> <?php
                } ?>


                <?php
                if (is_active_sidebar('ultra_footer3')) {
                    ?>
                    <div class="col-ultra"> <?php
                        dynamic_sidebar('ultra_footer3');
                        ?>      </div> <?php
                }
                ?>


                <?php
                if (is_active_sidebar('ultra_footer4')) { ?>
                    <div class="col-ultra"> <?php
                        dynamic_sidebar('ultra_footer4'); ?>   </div> <?php
                }
                ?>


            </div>
            <?php global $ultra_options;
            if ($ultra_options['display_copyright']) { ?>
                <div class="footer-copyright">
                    <span><?php echo $ultra_options['copyright_text']; ?></span>
                </div>
            <?php } ?>
        </div>
    </footer>

<?php } ?>

<?php if (class_exists('WooCommerce') && !is_product() && !is_checkout() && !is_cart()) { ?>

    <div class="nav-mob-bottom">
        <ul>

            <?php if (is_shop() || is_category() || is_product_category()) { ?>

                <li class="list ">
                    <a href="#" onclick="openNav()" id="filter-ultra">
        <span class="icon ">
     <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path
                 d="M35.4 87.12l168.65 196.44A16.07 16.07 0 01208 294v119.32a7.93 7.93 0 005.39 7.59l80.15 26.67A7.94 7.94 0 00304 440V294a16.07 16.07 0 014-10.44L476.6 87.12A14 14 0 00466 64H46.05A14 14 0 0035.4 87.12z"
                 fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                 stroke-width="32"/></svg>

        </span>
                        <span class="text">فیلتر</span>
                        <span class="circle"></span>
                    </a>
                </li>
            <?php } else { ?>


                <li class="list">
                    <a href="<?php echo home_url('shop/'); ?>" id="shop">
        <span class="icon">
          <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path fill="none"
                                                                                              stroke="currentColor"
                                                                                              stroke-linecap="round"
                                                                                              stroke-linejoin="round"
                                                                                              stroke-width="32"
                                                                                              d="M448 448V240M64 240v208M382.47 48H129.53c-21.79 0-41.47 12-49.93 30.46L36.3 173c-14.58 31.81 9.63 67.85 47.19 69h2c31.4 0 56.85-25.18 56.85-52.23 0 27 25.46 52.23 56.86 52.23s56.8-23.38 56.8-52.23c0 27 25.45 52.23 56.85 52.23s56.86-23.38 56.86-52.23c0 28.85 25.45 52.23 56.85 52.23h1.95c37.56-1.17 61.77-37.21 47.19-69l-43.3-94.54C423.94 60 404.26 48 382.47 48zM32 464h448M136 288h80a24 24 0 0124 24v88h0-128 0v-88a24 24 0 0124-24zM288 464V312a24 24 0 0124-24h64a24 24 0 0124 24v152"/></svg>        </span>
                        <span class="text">فروشگاه</span>
                        <span class="circle"></span>
                    </a>
                </li>

            <?php } ?>

            <?php if (class_exists('WPCleverWoosw')) { ?>
                <li class="list">
                    <a id="wishlist" href="<?php echo home_url('wishlist/'); ?>">
        <span class="icon ">
          <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path
                      d="M352.92 80C288 80 256 144 256 144s-32-64-96.92-64c-52.76 0-94.54 44.14-95.08 96.81-1.1 109.33 86.73 187.08 183 252.42a16 16 0 0018 0c96.26-65.34 184.09-143.09 183-252.42-.54-52.67-42.32-96.81-95.08-96.81z"
                      fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                      stroke-width="32"/></svg>
        </span>
                        <span class="text">علاقه مندی</span>
                        <span class="circle"></span>
                    </a>
                </li>

            <?php } ?>


            <li class="list">
                <a href="<?php echo home_url(); ?>" id="home">
        <span class="icon">
          <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path
                      d="M80 212v236a16 16 0 0016 16h96V328a24 24 0 0124-24h80a24 24 0 0124 24v136h96a16 16 0 0016-16V212"
                      fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                      stroke-width="32"/><path
                      d="M480 256L266.89 52c-5-5.28-16.69-5.34-21.78 0L32 256M400 179V64h-48v69" fill="none"
                      stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"/></svg>        </span>
                    <span class="text">خانه</span>
                    <span class="circle"></span>
                </a>
            </li>


            <li class="list">
                <a href="<?php echo wc_get_cart_url(); ?>" id="cart">
        <span class="icon">
         <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path
                     d="M68.4 192A20.38 20.38 0 0048 212.2a17.87 17.87 0 00.8 5.5L100.5 400a40.46 40.46 0 0039.1 29.5h232.8a40.88 40.88 0 0039.3-29.5l51.7-182.3.6-5.5a20.38 20.38 0 00-20.4-20.2H68.4zm193.32 160.07A42.07 42.07 0 11304 310a42.27 42.27 0 01-42.28 42.07z"
                     fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="32"/><path fill="none"
                                                                                                        stroke="currentColor"
                                                                                                        stroke-linejoin="round"
                                                                                                        stroke-width="32"
                                                                                                        d="M160 192l96-128 96 128"/></svg>       </span>
                    <span class="text">سبد خرید</span>
                    <span class="circle"></span>
                </a>
            </li>


            <?php
            global $current_user;
            if (is_user_logged_in()) {
                ?>


                <li class="list">
                    <a href="<?php echo home_url('my-account/') ?>" id="user">
        <span class="icon">
          <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path
                      d="M344 144c-3.92 52.87-44 96-88 96s-84.15-43.12-88-96c-4-55 35-96 88-96s92 42 88 96z" fill="none"
                      stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"/><path
                      d="M256 304c-87 0-175.3 48-191.64 138.6C62.39 453.52 68.57 464 80 464h352c11.44 0 17.62-10.48 15.65-21.4C431.3 352 343 304 256 304z"
                      fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="32"/></svg>
		  </span>
                        <span class="text"><?php echo $current_user->display_name; ?></span>
                        <span class="circle"></span>

                    </a>
                </li>

            <?php } else { ?>

                <li class="list">
                    <a href="<?php echo home_url('my-account/') ?>" id="user">
		   <span class="icon">
          <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path
                      d="M344 144c-3.92 52.87-44 96-88 96s-84.15-43.12-88-96c-4-55 35-96 88-96s92 42 88 96z" fill="none"
                      stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"/><path
                      d="M256 304c-87 0-175.3 48-191.64 138.6C62.39 453.52 68.57 464 80 464h352c11.44 0 17.62-10.48 15.65-21.4C431.3 352 343 304 256 304z"
                      fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="32"/></svg>
		  </span>
                        <span class="text">ورود | ثبت نام</span>
                        <span class="circle"></span>
                    </a>
                </li>
            <?php } ?>
            <div class="choosen"></div>

        </ul>
    </div>


    <?php global $ultra_options;
    if ($ultra_options['active_contact_us']) { ?>
        <div class="floatting-contact">
            <div class="contact-list">
                <?php global $ultra_options;
                if ($ultra_options['contact_tell']) { ?>
                    <a href="tel:<?php echo $ultra_options['contact_tell']; ?>" target="_blank">
                        <span>ارتباط از طریق تماس</span>
                        <img src="<?php echo get_template_directory_uri() . "/assets/image/contact/contact.svg"; ?>">
                    </a>
                <?php } ?>
                <?php if ($ultra_options['contact_telegram']) { ?>
                    <a href="https://t.me/<?php echo $ultra_options['contact_telegram']; ?>" target="_blank">
                        <span>ارتباط از طریق تلگرام</span>
                        <img src="<?php echo get_template_directory_uri() . "/assets/image/contact/telegram.svg"; ?>">
                    </a>
                <?php } ?>

                <?php if ($ultra_options['contact_instagram']) { ?>
                    <a href="https://www.instagram.com/<?php echo $ultra_options['contact_instagram']; ?>"
                       target="_blank">
                        <span>ارتباط از طریق اینستاگرام</span>
                        <img src="<?php echo get_template_directory_uri() . "/assets/image/contact/instagram.svg"; ?>">
                    </a>
                <?php } ?>

                <?php if ($ultra_options['contact_whatsup']) { ?>
                    <a href="https://wa.me/<?php echo $ultra_options['contact_whatsup']; ?>" target="_blank">
                        <span>ارتباط از طریق واتساپ</span>
                        <img src="<?php echo get_template_directory_uri() . "/assets/image/contact/whatsup.svg"; ?>">
                    </a>
                <?php } ?>

                <?php if ($ultra_options['contact_bale']) { ?>
                    <a href="https://ble.ir/<?php echo $ultra_options['contact_bale']; ?>" target="_blank">
                        <span>ارتباط از طریق بله</span>
                        <img src="<?php echo get_template_directory_uri() . "/assets/image/contact/bale.svg"; ?>">
                    </a>
                <?php } ?>

                <?php if ($ultra_options['contact_rubika']) { ?>
                    <a href="https://rubika.ir/<?php echo $ultra_options['contact_rubika']; ?>" target="_blank">
                        <span>ارتباط از طریق روبیکا</span>
                        <img src="<?php echo get_template_directory_uri() . "/assets/image/contact/rubika.svg"; ?>">
                    </a>
                <?php } ?>

                <?php if ($ultra_options['contact_soroush']) { ?>
                    <a href="https://splus.ir/<?php echo $ultra_options['contact_soroush']; ?>" target="_blank">
                        <span>ارتباط از طریق سروش</span>
                        <img src="<?php echo get_template_directory_uri() . "/assets/image/contact/soroush.svg"; ?>">
                    </a>
                <?php } ?>

                <?php if ($ultra_options['contact_email']) { ?>
                    <a href="mailto:<?php echo $ultra_options['contact_email']; ?>">
                        <span>ارتباط از طریق ایمیل</span>
                        <img src="<?php echo get_template_directory_uri() . "/assets/image/contact/email.svg"; ?>">
                    </a>
                <?php } ?>
                <!--                --><?php //if ($ultra_options['switch_custom']) { ?>
                <!--                    <a href="--><?php //echo $ultra_options['contact_custom_link']; ?><!--">-->
                <!--                        <span>-->
                <?php //echo $ultra_options['contact_custom_name']; ?><!--</span>-->
                <!--                        <img src="-->
                <?php //echo get_template_directory_uri() . "/assets/image/contact/email.svg"; ?><!--">-->
                <!--                    </a>-->
                <!--                --><?php //} ?>
                <?php if ($ultra_options['switch_custom']) { ?>
                    <a href="<?php echo esc_url($ultra_options['contact_custom_link']); ?>">
                        <span><?php echo esc_html($ultra_options['contact_custom_name']); ?></span>

                        <?php if ($ultra_options['switch_img_icon']) { ?>
                            <!-- اگر تصویر انتخاب شده باشد -->
                            <img src="<?php echo esc_url($ultra_options['contact_custom_img']['url']); ?>"
                                 alt="Custom Image">
                        <?php } else { ?>
                            <!-- اگر آیکون انتخاب شده باشد -->
                            <i class="<?php echo esc_attr($ultra_options['contact_custom_icon']); ?>"></i>
                        <?php } ?>
                    </a>
                <?php } ?>
            </div>
            <div class="floatting-btn">
                <i class="fas fa-comment-dots"></i>
            </div>

        </div>
    <?php } ?>
<?php } ?>


<!-- 	Code for show product in loop time -->
<?php
if (isset($ultra_options['enable_product_display']) && $ultra_options['enable_product_display']) {
    $product_ids = explode(',', isset($ultra_options['product_display_ids']) ? $ultra_options['product_display_ids'] : '');
    shuffle($product_ids); // Shuffle product IDs randomly
    $args = array(
        'post_type' => 'product',
        'no_found_rows' => true,
        'post__in' => $product_ids,
    );
    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) : $query->the_post(); ?>
            <div class="message-box-ultra">
                <a href="<?php the_permalink(); ?>">
                    <?php if (has_post_thumbnail()) {
                        the_post_thumbnail();
                    } else { ?>
                        <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp'; ?>">
                    <?php } ?>
                    <svg class="message-icon" xmlns="http://www.w3.org/2000/svg"
                         xmlns:xlink="http://www.w3.org/1999/xlink"
                         fill="#000000" height="800px" width="800px" version="1.1" id="Capa_1"
                         viewBox="0 0 97.623 97.623"
                         xml:space="preserve">
		<g>
            <g>
                <path d="M78.617,65.562H44.543c-4.919,0-10.185-3.585-11.987-8.163l-13.77-34.953c-0.727-1.846-3.289-3.59-5.273-3.59H3.609    C1.616,18.857,0,17.241,0,15.248c0-1.993,1.616-3.609,3.609-3.609h9.905c4.92,0,10.185,3.585,11.987,8.163l13.77,34.953    c0.727,1.846,3.289,3.59,5.272,3.59h34.074c1.935,0,4.375-1.725,5.02-3.548l6.638-18.758c0.186-0.525,0.139-0.845,0.088-0.918    c-0.052-0.073-0.338-0.223-0.895-0.223H42.474c-1.993,0-3.609-1.616-3.609-3.609c0-1.993,1.616-3.609,3.609-3.609h46.994    c2.843,0,5.317,1.194,6.789,3.275c1.471,2.081,1.771,4.811,0.822,7.491l-6.638,18.758C88.783,61.89,83.589,65.562,78.617,65.562z"/>
            </g>
            <g>
                <circle cx="35.267" cy="77.964" r="8.02"/>
            </g>
            <g>
                <circle cx="86.689" cy="77.964" r="8.02"/>
            </g>
            <g>
                <path d="M78.489,43.552H46.612c-0.997,0-1.804-0.808-1.804-1.804c0-0.997,0.808-1.804,1.804-1.804h31.877    c0.997,0,1.804,0.808,1.804,1.804C80.293,42.744,79.486,43.552,78.489,43.552z"/>
            </g>
            <g>
                <path d="M76.051,52.574H49.864c-0.996,0-1.804-0.808-1.804-1.804c0-0.997,0.808-1.804,1.804-1.804h26.188    c0.997,0,1.804,0.808,1.804,1.804C77.855,51.766,77.048,52.574,76.051,52.574z"/>
            </g>
        </g>
	</svg>

                    <div class="prod-info">
                        <h3><?php the_title(); ?></h3>
                        <span class="price"><?php global $product;
                            echo $product->get_price_html(); ?></span>
                    </div>
                </a>
                <button class="close-btn-ultra" onclick="closeMessage()">✖</button>
            </div>
        <?php
        endwhile;
    }
    wp_reset_postdata();
}
?>


<!-- 	Code for popup in load site  -->
<?php if (isset($ultra_options['enable_popup']) && $ultra_options['enable_popup']) { ?>
    <div class="popup-ultra" id="popup-ultra">
        <div class="popup-content-ultra">
            <span class="close-btn-popultra" id="closeBtn-popultra">&times;</span>
            <h5><?php echo $ultra_options['popup_title']; ?></h5>
            <p><?php echo $ultra_options['popup_content']; ?></p>
        </div>
    </div>
    <script>


        document.addEventListener("DOMContentLoaded", function () {
            const popupUltra = document.getElementById("popup-ultra");
            const closeBtnUltra = document.getElementById("closeBtn-popultra");
            const popupKey = "popupShown";
            const popupTimestamp = localStorage.getItem(popupKey);
            const now = new Date().getTime();
            const twentyFourHours = 24 * 60 * 60 * 1000;

            // اگر 24 ساعت از نمایش قبلی گذشته باشد، پاپ‌آپ دوباره نمایش داده شود
            if (!popupTimestamp || now - popupTimestamp > twentyFourHours) {
                setTimeout(() => {
                    popupUltra.style.display = "flex";
                    localStorage.setItem(popupKey, now); // ذخیره زمان نمایش پاپ‌آپ
                }, <?php echo $ultra_options['time_show_popup'];?>000);
            }

            // بستن پاپ‌آپ
            closeBtnUltra.addEventListener("click", function () {
                popupUltra.style.display = "none";
            });
        });


    </script>
<?php } ?>

<script>
    <?php if ($ultra_options['choose_header'] == 3) : ?>
    // js Header sticky 3
    const header3 = document.querySelector('.main-header-3');
    const sticky3 = header3.offsetTop;

    function makeSticky3() {
        if (window.pageYOffset > sticky3) {
            header3.classList.add("sticky-head");
        } else {
            header3.classList.remove("sticky-head");
        }
    }

    window.onscroll = makeSticky3;
    <?php elseif ($ultra_options['choose_header'] == 2) : ?>
    // js Header sticky 2
    const midHeader2 = document.querySelector('.mid-header');
    const sticky2 = midHeader2.offsetTop;

    function makeSticky2() {
        if (window.pageYOffset > sticky2) {
            midHeader2.classList.add("sticky-head");
        } else {
            midHeader2.classList.remove("sticky-head");
        }
    }

    window.onscroll = makeSticky2;
    <?php elseif ($ultra_options['choose_header'] == 1) : ?>
    // js Header sticky 1
    const midHeader1 = document.querySelector('.middle-header');
    const sticky1 = midHeader1.offsetTop;

    function makeSticky1() {
        if (window.pageYOffset > sticky1) {
            midHeader1.classList.add("sticky-head");
        } else {
            midHeader1.classList.remove("sticky-head");
        }
    }

    window.onscroll = makeSticky1;
    <?php endif; ?>
</script>


<?php
echo isset($ultra_options['footer_custom_code']) ? $ultra_options['footer_custom_code'] : '';
wp_footer(); ?>

<?php wp_footer(); ?>
</body>
</html>
