<?php
if (post_password_required()) {
    return;
}

if (have_comments()) : ?>
    <h4 class="comments-title">
        <?php
        printf(_nx('یک دیدگاه برای "%2$s"', '%1$s دیدگاه برای "%2$s"', get_comments_number(), 'comments title'),
            number_format_i18n(get_comments_number()), '<span>' . get_the_title() . '</span>');
        ?>
    </h4>
    <ul class="comment_list comments">
        <?php
        wp_list_comments(array(
            'style' => 'ul',
            'short_ping' => true,
            'callback' => 'better_comments'
        ));
        ?>
    </ul>
    <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
        <nav class="navigation comment-navigation" role="navigation">
            <h2 class="screen-reader-text section-heading"><?php _e('صفحه‌بندی دیدگاه‌ها'); ?></h2>
            <div class="nav-previous"><?php previous_comments_link(__('&larr; کامنت‌های قدیمی‌تر')); ?></div>
            <div class="nav-next"><?php next_comments_link(__('کامنت‌های جدیدتر &rarr;')); ?></div>
        </nav>
    <?php endif; ?>
<?php endif;

if (!comments_open() && get_comments_number()) : ?>
    <p class="no-comments"><?php _e('کامنت‌ها بسته شده است.', 'twentythirteen'); ?></p>
<?php endif;

$fields = array(
    'author' => '<div class="form_input"><input id="author" name="author" class="form-control" placeholder="* نام خود را وارد کنید" type="text" value="' . esc_attr($commenter['comment_author']) . '" required="required" /></div>',
    'email' => '<div class="form_input"><input id="email" class="form-control" placeholder="* ایمیل خود را وارد کنید" name="email" value="' . esc_attr($commenter['comment_author_email']) . '" required="required" /></div>',
);

$comment_form = array(
    'title_reply' => 'شما هم می‌توانید در مورد این مقاله نظر بدهید',
    'class_form' => 'row mt-3',
    'comment_field' => '<div class="form_group"><textarea id="comment" placeholder="نظر شما" name="comment" class="form-control"></textarea></div>',
    'submit_button' => '<div><button id="%2$s" type="submit" class="btn btn-outline-danger %3$s" value="%4$s">ارسال نظر</button></div>',
    'fields' => $fields,
);

comment_form($comment_form);
