jQuery(function ($) {
    const products = Array.from(document.querySelectorAll('.message-box-ultra'));
    let currentProductIndex = 0;

    function showNextProduct() {
        if (products.length === 0) return;

        products.forEach(product => product.classList.remove('show'));

        const currentProduct = products[currentProductIndex];
        if (!currentProduct) return;

        currentProduct.classList.add('show');

        setTimeout(() => {
            currentProduct.classList.remove('show');
        }, 7000);

        currentProductIndex = (currentProductIndex + 1) % products.length;
    }

    function closeMessage() {
        const currentProduct = products.find(product => product.classList.contains('show'));
        if (currentProduct) {
            currentProduct.classList.remove('show');
        }
    }

    if (!window.location.pathname.includes("wp-admin") && products.length > 0) {
        setTimeout(() => {
            showNextProduct();
        }, 7000);

        setInterval(() => {
            showNextProduct();
        }, 30000);
    }

    window.closeMessage = closeMessage;
});



$('.ultra-product-little-grid_slider').owlCarousel({
    loop:true,
    margin:10,
    nav:true,
    dots:false,
    rtl:true,
    responsive:{
        0:{
            items:1.2
        },
        600:{
            items:2.2
        },
        1400:{
            items:5.2
        },
		1500:{
            items:6.3
        }
    }
});





function getItemsCount(width) {
  if (width > 1600) return 6.5;
  else if (width > 1440) return 5.5;
  else if (width > 1024) return 4.9;
  else if (width > 830) return 4.1;
  else if (width > 612) return 3.2;
  else if (width > 570) return 2.8;
  else if (width > 430) return 2.3;
  else if (width > 370) return 1.7;
  else return 1.2;
}

function initRelatedProductsProd() {
  const container = document.querySelector('.product-items');
  if (!container) return;

  const itemsCount = getItemsCount(container.offsetWidth);

  $('.related-products-prod').trigger('destroy.owl.carousel').owlCarousel({
    center: false,
    loop: true,
    dots: false,
    margin: 20,
    rtl: true,
    items: itemsCount,
  });
}

function initRelatedProducts() {
  const container = document.querySelector('.product-items');
  if (!container) return;

  const itemsCount = getItemsCount(container.offsetWidth);

  $('.related-products').trigger('destroy.owl.carousel').owlCarousel({
    loop: true,
    margin: 20,
    rtl: true,
    dots: false,
    items: itemsCount,
  });
}

// اجرای اولیه
initRelatedProductsProd();
initRelatedProducts();

// واکنش به تغییر اندازه
window.addEventListener('resize', () => {
  clearTimeout(window._owlResizeTimeout);
  window._owlResizeTimeout = setTimeout(() => {
    initRelatedProductsProd();
    initRelatedProducts();
  }, 300);
});





function initCrossSellSlider() {
  const container = document.querySelector('.cross-sell-slider');
  if (!container) return;

  const width = container.offsetWidth;
  const itemsCount = getItemsCount(width);

  console.log(`[CrossSell] عرض: ${width} → آیتم‌ها: ${itemsCount}`);

  $('.cross-sell-slider').trigger('destroy.owl.carousel').owlCarousel({
    center: false,
    loop: true,
    dots: false,
    nav: false,
    margin: 20,
    rtl: true,
    items: itemsCount,
  });
}

// اجرای اولیه
initCrossSellSlider();

// واکنش به تغییر اندازه فقط برای cross-sell
window.addEventListener('resize', () => {
  clearTimeout(window._crossSellTimeout);
  window._crossSellTimeout = setTimeout(() => {
    initCrossSellSlider();
  }, 300);
});





$(document).ready(function (){
    $('.hum-menu ul.sub-menu').prev('a').append("<i class='sub-menu-arrow fa fa-angle-left'></i>");

    $(".hum-menu a").has(".fa-angle-left").click(function (e) {
        e.preventDefault(); 

        var icon = $(this).find(".sub-menu-arrow"); 

        if (icon.hasClass("fa-angle-left")) {
            $(this).next("ul.sub-menu").slideToggle(); 
            icon.removeClass("fa-angle-left").addClass("fa-angle-down"); 
        } else {
            $(this).next("ul.sub-menu").hide(500); 
            icon.removeClass("fa-angle-down").addClass("fa-angle-left"); 
        }
    });
});



/* Set the width of the side navigation to 250px and the left margin of the page content to 250px and add a black background color to body */
function openNav() {
    document.getElementById("side-shop").style.display = "block";
  }
  
  /* Set the width of the side navigation to 0 and the left margin of the page content to 0, and the background color of body to white */
  function closeNav() {
    document.getElementById("side-shop").style.display = "none";
  }





  
// Elements
const emojiInputs = document.querySelectorAll(".emoji-input");
// Emoji List
const mojis = [
    "🤬",
    "🤬",
    "🤬",
    "😡",
    "😡",
    "😡",
    "😡",
    "😡",
    "😡",
    "😡",

    "😠",
    "😠",
    "😠",
    "😠",
    "😠",
    "😠",
    "😠",
    "😠",
    "😠",
    "😠",

    "🥴",
    "🥴",
    "🥴",
    "🥴",
    "🥴",
    "🥴",
    "🥴",
    "🥴",
    "🥴",
    "🥴",


    "😵",
    "😵",
    "😵",
    "😵",
    "😵",
    "😵",
    "😵",
    "😵",
    "😵",
    "😵",

    "😑",
    "😑",
    "😑",
    "😑",
    "😑",
    "😑",
    "😑",
    "😑",
    "😑",
    "😑",

    "😐",
    "😐",
    "😐",
    "😐",
    "😐",
    "😐",
    "😐",
    "😐",
    "😐",
    "😐",

    "🙂",
    "🙂",
    "🙂",
    "🙂",
    "🙂",
    "🙂",
    "🙂",
    "🙂",
    "🙂",
    "🙂",


    "😊",
    "😊",
    "😊",
    "😊",
    "😊",
    "😊",
    "😊",
    "😊",
    "😊",
    "😊",


    "😉",
    "😉",
    "😉",
    "😉",
    "😉",
    "😉",
    "😉",
    "😉",
    "😉",
    "😉",


    "🤩",
    "🤩",
    "🤩",
    "🤩",
    "🤩",
    "🤩",
    "🤩",
    "🤩",
    "🤩",
    "🤩",
    "🤩",

];


// Event Listener To Change Emoji
emojiInputs.forEach((input) => {
    input.addEventListener("input", (e) => {
        let rangeValue = e.target.value;
        console.log(rangeValue);
        const emojielement = e.target.nextElementSibling;
        emojielement.textContent = mojis[rangeValue];
    });
});



document.addEventListener("DOMContentLoaded", function () {
  const insShare = document.getElementById("ins-share");
  const overlayIns = document.getElementById("overlay-ins");
  const modalInstaShare = document.getElementById("modal-insta-share");
  const closeBtnInsShare = document.getElementById("close-btn-ins-share");

	
  if (insShare && overlayIns && modalInstaShare && closeBtnInsShare) {
    insShare.addEventListener("click", function () {
      overlayIns.classList.add("is-visible");
      modalInstaShare.classList.add("is-visible");
    });

    closeBtnInsShare.addEventListener("click", function () {
      overlayIns.classList.remove("is-visible");
      modalInstaShare.classList.remove("is-visible");
    });

    overlayIns.addEventListener("click", function () {
      overlayIns.classList.remove("is-visible");
      modalInstaShare.classList.remove("is-visible");
    });
  } else {
    console.warn("Some elements are missing from the DOM. Event listeners were not added.");
  }
});



  