<?php
/*
Template Name: نمایش تمام محصولات تخفیف خورده
*/

get_header(); ?>
<section class="archive-product category-product-page cate-insale">
    <div class="container">
        <div class="post-content">
            <div class="main-box">
                <nav class="breadcrumb-ultra">
                    <?php
                    if (function_exists('ultra_breadcrumb')) {
                        echo ultra_breadcrumb();
                    }
                    ?>
                </nav>
                <div class="text-box">
                    <div class="prod-sale">
                        <div class="header-page">
                            <svg id="Ticket Star" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M21.4399 13.9939C18.7789 13.9939 18.7789 9.87952 21.4399 9.87952C21.4399 5.11236 21.4399 3.41089 12.0449 3.41089C2.6499 3.41089 2.6499 5.11236 2.6499 9.87952C5.3109 9.87952 5.3109 13.9939 2.6499 13.9939C2.6499 18.762 2.6499 20.4635 12.0449 20.4635C21.4399 20.4635 21.4399 18.762 21.4399 13.9939Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M12.0449 9.17102C11.3619 9.17102 11.2969 10.2605 10.8909 10.6461C10.4839 11.0307 9.22087 10.5911 9.04487 11.2742C8.86987 11.9582 10.0069 12.1903 10.1479 12.7767C10.2879 13.3631 9.59387 14.1873 10.1869 14.5985C10.7809 15.0078 11.4199 14.0803 12.0449 14.0803C12.6699 14.0803 13.3089 15.0078 13.9029 14.5985C14.4969 14.1873 13.8019 13.3631 13.9419 12.7767C14.0829 12.1903 15.2199 11.9582 15.0449 11.2742C14.8689 10.5911 13.6059 11.0307 13.1989 10.6461C12.7929 10.2605 12.7279 9.17102 12.0449 9.17102Z" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                            </svg>
                            <h1><?php the_title(); ?></h1>
                        </div>
                        <div class="f-insale-content">
                            <div class="insale-product product-items">
                                <?php
                                global $product;
                                $choosen_product = new WP_Query(array(
                                    'post_type' => 'product',
                                    'posts_per_page' => -1, // نمایش تمام محصولات
                                    'no_found_rows' => true,
                                    'meta_query' => array(
                                        array(
                                            'key' => 'status_timer_offer',
                                            'value' => 'yes',
                                            'compare' => '=',
                                        ),
                                    ),
                                ));
                                if ($choosen_product->have_posts()) :
                                    while ($choosen_product->have_posts()) : $choosen_product->the_post();
                                        $product = wc_get_product(get_the_ID()); // دریافت محصول
                                ?>
                                        <div class="item">
                                            <div class="item-content">
                                                <a href="<?php the_permalink(); ?>">
                                                    <figure>
                                                        <?php if (has_post_thumbnail()) {
                                                            the_post_thumbnail('product');
                                                        } else { ?>
                                                            <img src="<?php echo get_template_directory_uri() . '/assets/image/empty.webp' ?>" alt="No image available">
                                                        <?php } ?>
                                                    </figure>
                                                    <?php if ($product->is_on_sale()) : ?>
                                                        <div class="sale-image">
                                                            <svg width="112" height="73" viewBox="0 0 112 73" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M102.419 41.4925L111.209 24.3437L96.8749 11.4984L80.325 0.00268555L54.6504 3.84369L0.60498 14.1263L11.3588 72.3025L65.7392 63.8317L91.0789 58.1786L102.419 41.4925ZM87.9999 36C92.4182 36 95.9999 32.4183 95.9999 28C95.9999 23.5818 92.4182 20 87.9999 20C83.5817 20 79.9999 23.5818 79.9999 28C79.9999 32.4183 83.5817 36 87.9999 36Z" fill="#FF8E6E"/>
                                                            </svg>
                                                            <span><?= ultra_woocommerce_discount(get_the_id()); ?> % </span>
                                                        </div>
                                                    <?php endif; ?>
                                                    <h3><?php the_title(); ?></h3>
                                                    <?php if ($product->is_in_stock() && $product->get_price_html()) { ?>
                                                        <div class="price-section">
                                                            <?= $product->get_price_html(); ?>
                                                        </div>
                                                    <?php }
                                                    elseif (!$product->is_in_stock()) {
                                                        echo "<div class='not_stock'>موجود نیست !</div>";
                                                    } else {
                                                        echo "<div class='no_price'>تماس بگیرید !</div>";
                                                    }
                                                    ?>
                                                    <?php if ($ultra_options['display_timer']) {
                                                        get_template_part('template/index/timer');
                                                    } ?>
                                                </a>
                                            </div>
                                        </div>

                                    <?php endwhile;

                                endif;

                                wp_reset_postdata();
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="content"><?php the_content(); ?></div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
